; The use and distribution of the information
; contained herein may be restricted.
;
title	su,<setup user core>,24,26-jun-74,tge/tph/mhb

	org	su

;	internal
	.globl	catsus,catsup,catsua,tlptin,corfff

;	external
	.globl	scaini,scatab
;initial user area setup parameters

inicor  =10000		;initial user core size in bytes
ptagsiz	=400		;length of initial tag (statement header) area
catsus:	clrb	scaval		;initialize to no scaling
catsua:	mov	#1,runlvl	;run at the editor level
	clr	edflag		;clear all flags at this time
catsup:	mov	#mi,-(sp)	;initialize math hardware on exit
	clr	corfff			;core o.k. now
	mov	#inicor/4000,xrb	;initial core size in k
	.core			;get it allocated
	mov	#nstorg,r2	;beginning of killable user area
	mov	#cailen,r3	;length of initial core allocation
4$:	clr	(r2)+		;clear one word
	cmp	r2,r3		;see if we're done
	bne	4$		;not yet
	mov	#scth,r1	;start setting up
	mov	#ptaorg-taglen,(r1)+	;scth - statement 0
	mov	#ptaorg,(r1)+	;spta - statement base
	mov	#pdaorg,(r1)+	;spda - data base
	mov	#r1sorg,(r1)+	;r1corg - r1stack
	movb	scaval,r2	;fetch the scaling value
	jsr	r5,scaini	;now init scaling items
	add	#scatab,r2	;make pointer to pi & one absolute
	mov	#pdaorg+picon,r1;get origin to pda data to set up
	mov	#8.,r3		;move 8. words
10$:	mov	(r2)+,(r1)+	;move pi and one
	sob	r3,10$
	mov	#begpda,r2	;get address of other non-zero data
	mov	#endnzd-begpda/2,r3;and its size
2$:	mov	(r2)+,(r1)+
	sob	r3,2$		;loop till done
	mov	#endpta-begpta/2,r3	;now do text area********
	mov	#ptaorg,r1	;to load pta
	mov	#begpta,r2	;start of program area
1$:	mov	(r2)+,(r1)+
	sob	r3,1$
	mov	spda,r0		;get us a base in r0
	mov	r0,r3		;copy
	add	#iolen+base,r3	;to get to slot0
	mov	#aryiob*400,r2	;flags!channel index
9$:	add	(r3),r3		;next iob (slot1 to start)
	add	#2,r2		;to next one
	mov	#iolen,(r3)	;set link
	mov	r2,slot(r3)	;set slot and flags
	cmpb	#15.*2,r2	;done
	bne	9$		;no
	clr	(r3)+		;last link is nil
	mov	#-iolen*16.-base+dispos,(r3)+	;(dispos-slot15) disposable area ptr
	mov	#pdaend-dispos,(r3)+	;length - killed by ro
	mov	#tmpch+1*iolen+base+pdaorg+2,r3	;iob for bas channel
	mov	#-tmpch-1*iolen-base+basbuf,(r3)+	;pntr
	mov	#1000,(r3)	;length
	mov	r1corg,r1	;reset r1 stack
				;set tl stack pointers which live in csr area
tlptin:	mov	#tlinsp,r2	;parameter table pointer
	mov	(r2)+,r5	;number of table pairs
	mov	(r2)+,r4	;initial stack pointer pointer
10$:	mov	(r2)+,r3	;relative pointer
	add	r0,r3		;make it absolute
	mov	r3,(r4)+	;set xxsi
	mov	r3,(r4)+	;set xxsp
	sub	(r2)+,r3	;less length of stack
	mov	r3,(r4)+	;set xxsl
	sob	r5,10$
	rts	pc

;initial values for tl's stack variables
tlinsp:	+3
	cosi
	cosb+1			;cosp
	lcos
	opsb+1			;opsp
	lops
	oasb+2			;oasp
	loas

	tmporg	mi
	rts	pc		;dummy fpu turner oner
	unorg
;-------------------------------------------------------------------
;macro for building a table of values to insert into user
;area when it is set up.
;symbols which begin with $ are relative to the beginning of their area
;i.e. pta or pda.

;program text area -- referred to relative to spta 
	.macro	$	q14159,r27182
		.nlist
		.if	ne	q14159+begpta-.
		.error	;definitions do not match
		.endc
		.list
		r27182
	.endm
begpta:
		-taglen			;location of first statement header
		endpta-begpta		;positive limit assembled stuff
$ badbyt,	ppbadc*400!ppbadc	;(minsta) pop for error line
$ proptr,	endpta-begpta		;pludyn
$ tagptr,	-taglen			;last used word in statement header area
$ prolim,	cailen-ptaorg		;plulim
$ taglim,	-ptagsiz			;limit of statement header area
endpta:
	.macro	$	q14159,r27182
			.nlist
			.if	ne	q14159+begpda-.
			.error	;definitions do not match
			.endc
			.list
			r27182
	.endm

	.macro	$b	x,y
			.nlist
			.if	ne	x+begpda-.
			.error	;definitions do not match
			.endc
			.list
			.byte	y
	.endm

;program data area -- referred to relative to spda
;please see defines area in la where space is allocated
;for r1ext, matric, recoun, matria, matrib, etc.
begpda:					;defines the beginning of the pda
beghdr	=	begpda+lstpda	;*** !!defines current header area pointer
$ pda,		dumstr			;pointer to last and dummy string
;core allocation parameters
$ psd,		pdaend-pda		;current end of string area
$ stat,		+blinef			;lex analyzer status flags
$ nexstr,	pdaend-pda		;next available word in the string area
$ nexfre,	beghdr-begpda		;points to last cell used in string header area
$ strlim,	ptaorg-ptagsiz-pdaorg	;string limit -- leave room for a few tags
$ spclim,	r1sorg-pdaorg		;string header limit with 24 words slop
$ aryptr,	base			;first i/o array header item
;do not disturb cell order back to begpda

$ eddumm,	0			;string for naname.bas
	+	6			;pointer relative to start
	+	6			;length
		.enabl lc
		.ascii	/Noname/
		.dsabl lc
;permanent variable area--------------------------------------------
;core allocator variables-go in pda
;"nominals" are free space amounts guaranteed by ca

$ r1snom,	+100			;nominal for r1 stack
$ tagnom,	+626.			;nominal for statement headers
$ pronom,	+564.			;nominal for statement-push pop
$ hdrnom,	+342.			;nominal for string headers
$ strnow,	+0			;modified by ca
$ strnom,	+1000			;nominal for strings
;do not disturb cell order back to r1snom


$ sumnom,	+0			;sum of all nominals
$ nstrnm,	+0			;sum of all but string

	$ base,		.=.	;length of base area
slotm1:	.word	iolen		;link to the next
	.word	linbuf-base	;pointer to the buffer
	.word	linlen		;length of the buffer
	.word	0		;byte count
	.word	linbuf-base	;current location
	.byte	-2		;slot number
	.byte	0		;flag byte
$ tlmind,	beghdr-begpda	;(in iob) old value of str hdr ptr
$ rndm,		randy		;(in iob) random number storage bin

slot0:	.word	iolen		;link to the next
	.word	ttybuf-base-iolen	;(ttybuf-slot0)pointer to the buffer
	.word	ttylen		;length of the buffer
	.word	0		;byte count
	.word	ttybuf-base-iolen	;(ttybuf-slot0)current location
	.byte	0		;slot number
	.byte	flgpos/400!aryiob!force ;flag byte
	.word	0		;current position
endnzd:			;end non zero pda

	.end
