; The use and distribution of the information
; contained herein may be restricted.
;
title	io,<record io feature>,24,26-jun-74,tph/jdm

	.sbttl	buffer size function

	..	ppbufn,bufn

	.csect	mf

	.globl	intfun

bufn:	jsr	r5,intfun	;get a 'fai' arg
	args	fai
	mov	(r1)+,r3	;get channel number
	bic	#-17-1,r3	;make it legal
	ash	#4,r3		;times 16.
	add	spda,r3		;make absolute
	mov	length+base+iolen(r3),-(r1);set buffer's size
	rts	pc		;and exit
.rem %

	NO UNLOCK VERB YET


	.ifdf	hello
	org	xt,tkuloc-dotabv
	.word	douloc	;allow unlock verb
	.endc

	org	pt,0
	..	ppuloc,untloc

	.csect	up

	.globl	saint

	.ifdf	hello
;unlock verb

douloc:	jsr	r5,saint	;enter interpreter
	rt	pound		;must be a "#"
	rci			;now get any integer
	cb	ppuloc		;unlock pop
	quit			;allow modifiers
	.even
	.endc

untloc:	clr	xrb+xrlen
	asl	(r1)		;make index
	mov	(r1)+,xrb+xrci	;to become channel index
	movb	#dskhnd,xrb+xrci+1	;device type
	jmp	uuospc
%
	.ifdf	hello
	org	xt,tkget-dotabv
	.word	doget	;get
	.word	doput	;put
	.word	dofiel	;field
	.word	dolset	;lset
	.word	dorset	;rset
	.endc
	org	pt,0

	..	ppget,get
	..	ppput,put
	..	ppcvis,cvis
	..	ppcvfs,cvfs
	..	ppcvsi,cvsi
	..	ppcvsf,cvsf
	..	pplset,lset
	..	ppils1,m1lset
	..	ppils2,m2lset
	..	pprset,rset
	..	ppirs1,m1rset
	..	ppirs2,m2rset
	..	ppfset,field
	..	ppifs1,m1fset
	..	ppifs2,m2fset
	..	ppxlte,xlate
	.csect	io

	.globl	getset						;internal

	.ifdf	hello
	.globl	saint,tlidxh,select,rcicom			;(tr)
	.endc
	.globl	sso,pushs,lenp3,builds,ssi04,cvs3		;(rc)
	.globl	indo2,intfun,pstjs,indx90			;(ma)
	.globl	fltle2,prl14,mid9
; get a record

get:	jsr	pc,getset	;do common thing
	tst	-(r1)		;back up in case of ^c
	jsr	pc,ssi04	;now do the input
	tst	(r1)+		;but now dump the item
	clr	bytcnt(r3)	;and then clear inputted buffer
get08:	rts	pc		;and exit

getset:	mov	(r1)+,-(sp)	;save record number if any
	jsr	pc,sso		;select this slot for output
	add	r2,r3		;absolute r3 to header
	mov	(sp)+,curblk(r3)	;recover record number
	beq	get08		;just get next sequential
	tstb	flags(r3)	;is this a random access device?
	bmi	get08		;yes
	noracs	!fatal		;no

; put a record

put:	mov	(r1)+,-(sp)	;save count if any
	jsr	pc,getset	;get all set up
	mov	length(r3),r0	;get buffer length
	mov	(sp)+,r2	;now get count if any
	beq	1$		;no count so use buffer length
	cmp	r2,r0		;compare them
	bhi	1$		;if count > length then use length
	mov	r2,r0		;substitute count for length
1$:	mov	r0,bytcnt(r3)	;now set the real counter
	jmp	prl14		;and go do it
; left-justified string set

m1lset:	clr	-(r1)		;dummy second index to 0
m2lset:	jsr	pc,comast	;and do the indexing
	br	mlset		;now do the moving

lset:	jsr	pc,comset	;do the common thing
mlset:	sub	r2,r3		;r2=len(src)-len(dst)
	bge	2$		;if src>=dst then just move it to dst
	add	r3,r2		;r2 is now the len(src)
	jsr	pc,2$		;so copy src to dst
1$:	movb	#40,(r0)+	;and fill in padding
	inc	r3		;the count in r3 tells us
	bne	1$		;we have done it
2$:	dec	r2		;any of src left to move
	bmi	lset2		;no, exit
	movb	(r4)+,(r0)+	;yes, move it
	br	2$		;loop

; right-justified string set

rset:	jsr	pc,comset	;do the common thing
mrset:	add	r2,r0		;point to end of dst
	add	r3,r4		;and to end of src
	sub	r2,r3		;r3=len(src)-len(dst)
	bge	1$		;if src>dst, just move
	add	r3,r2		;if dst<src, then fill
	jsr	pc,1$		;move first
3$:	movb	#40,-(r0)	;fill one more byte
	inc	r3		;more?
	bne	3$		;yes, continue
1$:	dec	r2		;more src?
	bmi	lset2		;no, exit
	movb	-(r4),-(r0)	;yes, continue
	br	1$		;loop

m1rset:	clr	-(r1)		;dummy second index to 0
m2rset:	mov	#mrset,-(sp)	;return to "mrset"
comast:	jsr	pc,indo2	;do the indexing
	br	cmaset		;then continue in common

comset:	jsr	pc,pushs	;push dst string
cmaset:	mov	r1,r0		;save r1 stack pointer
	add	pntr(r0),r0	;now r0 is abs. pointer to dst
	jsr	pc,lenp3	;put len(dst) on r1 stack
	mov	(r1)+,r2	;now r2 is len(dst)
	mov	r1,r4		;save r1 stack pointer
	add	pntr(r4),r4	;now r4 is abs. pointer to src
	jsr	pc,lenp3	;put len(src) on r1 stack
	mov	(r1)+,r3	;now r3 is len(src)
lset2:	rts	pc		;and exit with conditions set
; make string into a floater

cvsf:	mov	#fltle2,-(sp)	;set (sp) to number bytes in a floater
	br	cvsf02		;and continue

; make string into an integer

cvsi:	mov	#2,-(sp)	;there are 2 bytes in an integer
cvsf02:	jsr	r5,intfun	;straighten out args
	args	fas		;we want a string
	mov	r1,r2		;copy the r1 stack pointer
	jsr	pc,pstjs	;and remove the string to j-space
	mov	(sp)+,r4	;get # of bytes in value
	mov	length(r2),r3	;get length of string
	add	pntr(r2),r2	;get abs ptr to string
1$:	dec	r3		;byte available in string?
	bpl	2$		;yes, so use it
	clrb	-(r1)		;nope, so use null (=000)
	br	3$		;and continue

2$:	movb	(r2)+,-(r1)	;use string byte here
3$:	sob	r4,1$		;do as many times as needed
	rts	pc		;then exit

; make floater into a string

cvfs:	jsr	r5,intfun	;get a floater
	args	faf
	mov	#fltle2,r3	;set string length in bytes
	br	cvis1		;and continue

; make integer into a string

cvis:	jsr	r5,intfun	;get an integer
	args	fai
	mov	#2,r3		;2 byte string
cvis1:	mov	r3,r2		;save string length
	jsr	pc,builds	;and get us a string
	add	r2,r1		;stack pointer when finished
	mov	r1,r4		;copy stack at completion
cvis2:	movb	-(r4),(r3)+	;copy one byte
	sob	r2,cvis2	;and loop
	jmp	cvs3		;then exit nicely
; field statement

field:	gwtxt	r0		;get the string header
	mov	spda,r2		;pick up base
	add	r2,r0		;make pointer absolute
fpop:	mov	r2,r3		;copy spda
	add	currio(r2),r3	;get specified slot
	cmp	(r0)+,(r3)+	;get past both links
	mov	r3,r4		;save ptr ptr
	add	(r3)+,r4	;make buf ptr absolute (+2)
	add	(r1)+,(r1)	;update field count by cur len
	cmp	(r1),(r3)	;off end of buffer?
	blos	.+4		;not yet anyway
	fielde	!fatal		;buffer too small for field statement
	add	(r1),r4		;first to end
	sub	-(r1),r4	;start of piece of string+2
	sub	r0,r4		;relativize pointer
	mov	r4,(r0)+	;save new pointer into buffer
	mov	(r1)+,(r0)	;and new length
	rts	pc		;end of this piece

m1fset:	clr	-(r1)		;dummy second index to 0
m2fset:	jsr	pc,indx90	;and do the indexing
	tstb	(r0)		;disk or core?
	bpl	.+4		;it is core
	diserr	!fatal		;if disk, then an error
	mov	spda,r2		;get bias
	mov	r3,r0		;indx90 returns str hdr in r3
	br	fpop		;and continue
; translate function (xlate(s$,t$))

xlate:	jsr	r5,intfun	;get 2 string for us
	args	fas,fas
	mov	strlen+length(r1),r3;get len(s$) for new string
	jsr	pc,builds	;and build a new string that size
	add	#strlen,(r0)	;de-link target string
	mov	r1,r5		;copy current r1 pointer
	tst	(r1)+		;skip t$ link word
	add	(r1)+,r5	;r5 -> t$
	mov	(r1)+,r4	;r4 = len(t$)
	mov	r1,r2		;copy r1 pointer now
	tst	(r1)+		;skip s$ link word
	add	(r1)+,r2	;r2 -> s$
xlate1:	dec	(r1)		;decrement len(s$)
	bmi	xlate2		;no more in s$
	clr	r0		;set up for loading value
	bisb	(r2)+,r0	;and get byte value
	cmp	r0,r4		;see if it is within range
	bge	xlate1		;ignore bytes out of range
	add	r5,r0		;make a pointer to new byte value
	movb	(r0),(r3)	;and get that new byte
	beq	xlate1		;ignore new 0 bytes
	inc	r3		;but, count others as real
	br	xlate1		;and continue

xlate2:	mov	spda,r0		;restore spda to r0
	jmp	mid9		;and exit setting up things
	.ifdf	hello
; compile lset and rset verbs

dolset:	jsr	r5,saint	;call interpreter
	p0			;clear left side count
	pbs	6		;push 6 on r1 stack - tlcomr
	b	dorst1		;now go to mainline code

	.even
dorset:	jsr	r5,saint	;call interpreter
	p0			;clear left side count
	pbs	7		;push 7 on r1 stack - tlcomr
dorst1:	r			;read over verb or comma
	cf			;compile left side, closed code block
	tj	equals,dorst2	;br if next is =
	t	comma		;else demand a comma
	cb	ppdups		;duplicate the string
	b	dorst1		;and loop

dorst2:	rcs			;read/compile a string
	ccb			;close code block
	tc			;adjust left side with dummy tlcomr
	quit			;and quit
; compile field statement

	.even
dofiel:	jsr	r5,saint	;call interpreter
	calls	selec5		;get channel
	cb	ppsso		;and select it
	cb	ppfix0		;count of character assign so far
	nej	dofi01		;done already?
dofi03:	cb	ppijs		;terminate pop - get rid of count
	quit			;and quit

dofi01:	ci			;compile an integer
	t	as		;demand an "as"
	rvs			;aim at variable
	pbs	8.		;code to end up with a ppfiel
	cfa			;compile field address
	ej	dofi03		;if end, the exit
	t	comma		;else demand a comma
	r			;skip the comma
	b	dofi01		;and continue

selec5:	sexit	select		;go external to select
; get and put
	.even
doget:	;jsr	pc,tlidxh	;for error recovery
	jsr	r5,saint	;call interpreter
	calls	doge03		;compile [#n,][record expr]
	cb	ppget		;normal get pp
	quit
	.even
doput:	jsr	r5,saint	;call interpreter
	calls	doge03		;compile [#n,][record expr]
	ntj	count,dopu01	;if not ,count then br
	rci			;get the count
	b	dopu02		;and continue
dopu01:	cb	ppfix0		;dummy in the count
dopu02:	cb	ppput		;and the put pp
	quit
doge03:	calls	selec5		;get #n
	ntj	record,doge01	;if not record then br
	calls	rcicon		;get integer and commas
	b	doge02
doge01:	cb	ppfix0		;dummy record to 0
doge02:	quits
rcicon:	sexit	rcicom		;go external

	.endc
	.end
