/ Monitor for PDP11/34

/ This program is loaded into the last 512 bytes of non-mapped memory.
/ The stack is initialised on entry to just before this program,
/ to allow for re-entry if desired.

/ Commands:

/	m address	prints out contents of memory location
/		<cr>	continues to next location
/		^	backs up to previous location
/		value	deposits value at that location
/	g address	starts execution at address
/	l		loads an absolute-loader format file
/			(prints out entry-point - does not commence execution)

/ Bus errors are caught and complained about.

/ Register usage:
/	r0	input/output bytes
/	r1	general scratch reg
/	r2	not used
/	r3	points to putc for shorter code
/	r4	used in mesg and dep as scratch reg
/	r5	current address being examined

	reset	= 5

	STK	= 8.		/ allow for this size stack before program

	tks	= 177560	/ KL11 CSR address
	tkb	= tks + 2
	tps	= tkb + 2
	tpb	= tps + 2


start:	mov	pc,sp
	tst	-(sp)		/ put stack just before the monitor
	mov	sp,r3
	sub	$STK,r3		/ allow for a STK byte stack
	mov	r3,lolim
	add	$end-start+STK+VBLES,r3
	mov	r3,uplim	/ initialise end-markers
	add	$buserr-end-VBLES,r3
	mov	r3,*$4		/ address of bus-error handler
	mov	r3,new4		/ initialise
	clr	*$6		/ new ps on bus-error
	clr	new6		/ initialise
	add	$putc-buserr,r3	/ points to putc routine

loop:	jsr	pc,mesg		/ main loop - print a prompt
		<\r\r\n* \0>
	jsr	pc,getc		/ get command
	cmpb	$'l,r0
	beq	load		/ l - load
	mov	r0,r1
	jsr	pc,*r3		/ echo command
	mov	$' ,r0
	jsr	pc,*r3		/ print a space
	cmpb	$'g,r1
	beq	goto		/ g - goto address
	cmpb	$'m,r1
	bne	loop		/ unrecognised entry

	jsr	pc,getnum	/ m - memory examine routine
mem:	jsr	pc,mesg
		<\r\r\n\0>
	mov	r5,r1
	jsr	pc,putnum	/ echo address
	mov	(r5)+,r1	/ possible bus error
	jsr	pc,putnum	/ print out contents
	jsr	pc,getc
	cmpb	$'\r,r0
	beq	mem
	cmpb	$'^,r0
	bne	dep
	jsr	pc,*r3
	cmp	-(r5),-(r5)	/ possible bus error
	br	mem

dep:	mov	r5,r4
	clr	r5
	jsr	pc,get1		/ already know first char
	mov	r5,-2(r4)
	mov	r4,r5
	br	mem

goto:	jsr	pc,getnum
	mov	new4,*$4
	mov	new6,*$6
	reset
	jmp	(r5)		/ possible bus error - or worse !

/ getnum reads in an octal digit terminated by a <cr>
/ the number is left in r5; r0 is used

getnum:	clr	r5
1:	jsr	pc,getc
get1:	jsr	pc,*r3		/ entry point from deposit code
	cmpb	$'\r,r0		/ stop on CR
	beq	fin
	sub	$'8,r0
	add	$'8-'0,r0
	bcc	start		/ illegal char - back to start
	/	ash	$3,r5
	asl	r5
	asl	r5
	asl	r5
	bis	r0,r5
	br	1b
fin:	rts	pc

/ Bus-errors are caught and complained about here
/ If the monitor was loading at the time, the remainder of the load is ignored
/ This routine must be positioned between code for normal operation, and code
/ for loading, to simplify the test

buserr:	cmp	(sp),pc		/ compare previous pc with current pc
	blo	1f		/ not loading
	jsr	pc,skip
1:	jsr	pc,mesg
		<bus err\0>
home:	br	start

/ mesg prints out the in-line string
/ which must be null-terminated and contain an even nr of chars
/ r0 and r4 are used

mesg:	mov	(sp)+,r4
1:	movb	(r4)+,r0
	jsr	pc,putc
	bne	1b
	jmp	(r4)

/ putnum prints out the number in r1 as 6 octal digits followed by a space

putnum:	mov	$30,r0		/ ('0') >> 1
	sec
2:	rol	r1
	rolb	r0
	jsr	pc,*r3
	mov	(pc)+,r0
		40\<8|200|6	/ blank in upper byte; 200 | '0/10 lower
4:	asl	r1
	beq	6f
	rolb	r0
	bcs	4b
	br	2b
6:	swab	r0		/ fall through to putc

putc:	tstb	*$tps
	bpl	putc
	movb	r0,*$tpb
	rts	pc

getc:	tstb	*$tks
	bpl	getc
	movb	*$tkb,r0
	rts	pc



/ start of absolute loader

/ Input format --
/	byte  -1  001
/	      -2  000
/	      -3  byte count-lower order
/	      -4  byte count-higher order
/	      -5  load address-lower order
/	      -6  load address-higher order
/			data
/			placed
/			here
/		cksm - last byte contains the checksum

/ The data is terminated by two bytes consisting of 001
/	(non-DEC-standard but necessary to see messages)

/ If the byte count is equal to 6, the load address specified
/ will be considered to be the desired jump address.

/ If the byte count is > 6, data will be loaded into memory.

/ Register usage:

/	r0	i/o byte
/	r1	load address
/	r2	checksum
/	r3	points to getb
/	r4	byte count
/	r5	word read in gwrd


load:	add	$getb-putc,r3	/ set up pointer
ld1:	clr	r2		/ initialise checksum
	jsr	pc,*r3		/ read a byte
	decb	r0		/ check for +1 (start of a block)
	bne	ld1
	jsr	pc,*r3		/ read another byte
	jsr	pc,gwrd		/ get full byte count
	mov	r5,r4
	sub	$4,r4		/ subtract 4 to make byte count correct
	cmp	$2,r4		/ was byte count 6 ?
	beq	ldend		/ finished if no data
	jsr	pc,gwrd		/ get load address
	mov	r5,r1

/ Read in remainder of data.
/ r0 will contain the expected checksum, and r2 will contain
/ the deviation from the expected checksum.
/ The monitor complains if the load tries to scribble on it

data:	jsr	pc,*r3		/ read a byte
	blt	1f		/ more data ?
	cmp	r1,lolim	/ trying to scramble monitor ?
	blo	2f
	cmp	r1,uplim
	blo	noway
2:	cmp	r1,$10		/ trying to scribble on bus-error vector ?
	bhis	3f
	cmp	r1,$4
	blo	3f
	mov	lolim,r5
	add	r1,r5
	movb	r0,end-start+STK-4(r5)
	inc	r1
	br	data
3:	movb	r0,(r1)+	/ possible bus error
	br	data
1:	tstb	r2		/ checksum correct ?
	beq	ld1		/ yes - go back for more
bad:	jsr	pc,skip		/ skip remainder of data
	jsr	pc,mesg		/ checksum error
		<chksum?\r\n\0>
	br	home		/ leap-frog back to start

noway:	jsr	pc,skip
	jsr	pc,mesg
		<ouch!\r\n\0>	/ blame DRM
	br	home		/ leap-frog back to start

/ Input a byte, decrement byte count, and accumulate checksum

getb:	jsr	pc,getc
	add	r0,r2		/ add to checksum
	bic	$177400,r0	/ mask off junk
	dec	r4
	rts	pc

/ Assemble one full word of data

gwrd:	jsr	pc,*r3		/ get one byte
	mov	r0,r5
	jsr	pc,*r3		/ get another byte
	swab	r0
	bic	$377,r0
	bis	r0,r5
	rts	pc

/ Skip remainder of data
/	(so can print out error or entry point message)

skip:	jsr	pc,*r3
	decb	r0
	bne	skip
	jsr	pc,*r3
	decb	r0
	bne	skip
	rts	pc

/ Get entry-point and print it out - then return to main loop

ldend:	jsr	pc,gwrd		/ get possible transfer address
	jsr	pc,*r3		/ get checksum
	tstb	r2		/ correct ?
	bne	bad		/ no
	jsr	pc,skip
	jsr	pc,mesg
		<ep \0>
	mov	r5,r1
	add	$putc-getb,r3	/ retore r3
	jsr	pc,putnum
	jmp	loop

end:				/ dummy label to indicate the end


/ Variables

VBLES	= 8.			/ bytes of memory for the following vbles

	.bss

new4:	.=.+2			/ reload bus-error vector from here
new6:	.=.+2			/ before executing loaded program
				/ NOTE: they MUST be in this order
				/ AND must be the first variables

lolim:	.=.+2			/ software write-protect markers
uplim:	.=.+2
