{ NPH  27-Feb-78  M2
  MONITOR is a program which resides in P2 EPROM.  It is  initiated
  at  power-up and performs all of the internal control and network
  communication functions of the asymmetric node.
  Normally, the program should run autonomously within P2 accepting
  commands and data via the network. However, the monitor will also
  respond to commands entered directly upon a diagnostic console if
  one is connected to P2.
  Network communication is  so  far only provided by a  single  du-
  plex  line to UNIX, and receiving buffer overflow is prevented by
  use  of the tty paging characters ^S and ^Q. When receiving char-
  acters  from UNIX, ^A (control-A) is recognized as the  SOH char-
  acter of a standard loader format binary  file  which  is  to  be
  loaded.
  Currently, the diagnostic console commands allow the direct  com-
  munication of the console with either UNIX or P1. }


MODULE monitor2;
 CONST msg1 = 'LSI11  University of York  NPHM2';
       cr = 015C; {carriage return}
       lf = 012C; {line-feed}
 VAR   i :integer;
       yon, zon :boolean;

DEVICE MODULE nwinterface[4];
 DEFINE nwread, nwwrite;
 CONST n=64; {buffer size}
       lowater=4;
       hiwater=60;
 VAR rcsr[175620B] :bits; {receiver status}
     rbuf[175622B] :char; {receiver buffer}
     xcsr[175624B] :bits; {transmitter status}
     xbuf[175626B] :char; {transmitter buffer}
     in1, in2, out1, out2, n1, n2 :integer;
     nonfull1, nonfull2, nonempty1, nonempty2 :signal;
     buf1, buf2 :ARRAY 1:n OF char;

 PROCEDURE nwwrite(ch :char);
 BEGIN
  IF n2=n
  THEN
   wait(nonfull2)
  END;
  buf2[in2]:=ch; in2:=(in2 MOD n) + 1;
  inc(n2); send(nonempty2)
 END nwwrite;

 PROCEDURE nwread(VAR ch :char);
 BEGIN
  IF n1=0
  THEN
   wait(nonempty1)
  ELSIF n1=lowater
  THEN
   nwwrite(021C) {control-Q}
  END;
  ch:=buf1[out1]; out1:=(out1 MOD n) + 1;
  dec(n1); send(nonfull1)
 END nwread;

 PROCESS rxdriver[320B];
 BEGIN
  LOOP
   IF n1=hiwater
   THEN
    nwwrite(023C) {control-S}
   ELSIF n1=n
   THEN
    wait(nonfull1)
   END;
   rcsr[6]:=true; doio; rcsr[6]:=false;
   buf1[in1]:=char(integer(rbuf) MOD 200B);
   in1:=(in1 MOD n) + 1;
   inc(n1); send(nonempty1)
  END
 END rxdriver;

 PROCESS txdriver[324B];
 BEGIN
  LOOP
   IF n2=0
   THEN
    wait(nonempty2)
   END;
   xbuf:=buf2[out2]; out2:=(out2 MOD n) + 1;
   xcsr[6]:=true; doio; xcsr[6]:=false;
   dec(n2); send(nonfull2)
  END
 END txdriver;

BEGIN {nwinterface}
 in1:=1; in2:=1; out1:=1; out2:=1;
 n1:=0; n2:=0;
 rxdriver; txdriver;
END nwinterface;


DEVICE MODULE p1console[4];
 DEFINE p1read, p1write;
 CONST n=64; {buffer size}
 VAR rcsr[175610B] :bits; {keyboard status}
     rbuf[175612B] :char; {receiver buffer}
     xcsr[175614B] :bits; {transmitter status}
     xbuf[175616B] :char; {transmitter buffer}
     in1, in2, out1, out2, n1, n2 :integer;
     nonfull1, nonfull2, nonempty1, nonempty2 :signal;
     buf1, buf2 :ARRAY 1:n OF char;

 PROCEDURE p1read(VAR ch :char);
 BEGIN
  IF n1=0
  THEN
   wait(nonempty1)
  END;
  ch:=buf1[out1]; out1:=(out1 MOD n) + 1;
  dec(n1); send(nonfull1)
 END p1read;

 PROCEDURE p1write(ch :char);
 BEGIN
  IF n2=n
  THEN
   wait(nonfull2)
  END;
  buf2[in2]:=ch; in2:=(in2 MOD n) + 1;
  inc(n2); send(nonempty2)
 END p1write;

 PROCESS rxdriver[310B];
 BEGIN
  LOOP
   IF n1=n
   THEN
    wait(nonfull1)
   END;
   rcsr[6]:=true; doio; rcsr[6]:=false;
   buf1[in1]:=char(integer(rbuf) MOD 200B);
   in1:=(in1 MOD n) + 1;
   inc(n1); send(nonempty1)
  END
 END rxdriver;

 PROCESS txdriver[314B];
 BEGIN
  LOOP
   IF n2=0
   THEN
    wait(nonempty2)
   END;
   xbuf:=buf2[out2]; out2:=(out2 MOD n) + 1;
   xcsr[6]:=true; doio; xcsr[6]:=false;
   dec(n2); send(nonfull2)
  END
 END txdriver;

BEGIN {p1console}
 in1:=1; in2:=1; out1:=1; out2:=1;
 n1:=0; n2:=0;
 rxdriver; txdriver;
END p1console;


DEVICE MODULE p2console[4];
 DEFINE p2read, p2write,readch;
 CONST n=16; {buffer size}
 VAR rcsr[177560B] :bits; {keyboard status}
     rbuf[177562B] :char; {receiver buffer}
     xcsr[177564B] :bits; {transmitter status}
     xbuf[177566B] :char; {transmitter buffer}
     in1, in2, out1, out2, n1, n2 :integer;
     nonfull1, nonfull2, nonempty1, nonempty2 :signal;
     buf1, buf2 :ARRAY 1:n OF char;

 PROCEDURE p2read(VAR ch :char);
 BEGIN
  IF n1=0
  THEN
   wait(nonempty1)
  END;
  ch:=buf1[out1]; out1:=(out1 MOD n) + 1;
  dec(n1); send(nonfull1)
 END p2read;

 PROCEDURE p2write(ch :char);
 BEGIN
  IF n2=n
  THEN
   wait(nonfull2)
  END;
  buf2[in2]:=ch; in2:=(in2 MOD n) + 1;
  inc(n2); send(nonempty2)
 END p2write;


{get a character from p2 console, with echo}

 PROCEDURE readch :char;
  VAR ch :char;
 BEGIN
  p2read(ch);
  p2write(ch);
  IF ch = 015C {carriage return}
  THEN
   p2write(012C) {line-feed}
  END;
  readch:=ch
 END readch;

 PROCESS rxdriver[60B];
 BEGIN
  LOOP
   IF n1=n
   THEN
    wait(nonfull1)
   END;
   rcsr[6]:=true; doio; rcsr[6]:=false;
   buf1[in1]:=char(integer(rbuf) MOD 200B);
   in1:=(in1 MOD n) + 1;
   inc(n1); send(nonempty1)
  END
 END rxdriver;

 PROCESS txdriver[64B];
 BEGIN
  LOOP
   IF n2=0
   THEN
    wait(nonempty2)
   END;
   xbuf:=buf2[out2]; out2:=(out2 MOD n) + 1;
   xcsr[6]:=true; doio; xcsr[6]:=false;
   dec(n2); send(nonfull2)
  END
 END txdriver;

BEGIN {p2console}
 in1:=1; in2:=1; out1:=1; out2:=1;
 n1:=0; n2:=0;
 rxdriver; txdriver;
END p2console;


DEVICE MODULE absoluteload[4];

{ The procedure "load" will  read  standard  loader  format  binary
  files from the network interface and load them into "store".  The
  array "store" represents absolute store, word  indexed,  but  one
  location  out  of  step (implementation restriction!).  The start
  address is returned in "staddr" , and if a checksum error  occurs
  then  "lderr"  will  return  a  true value.  No check is made for
  store overflow. }

DEFINE load,lderr,staddr;
USE nwread;

CONST cormax = 17777B; {8K words}
VAR store[02B]	  :ARRAY 1:cormax OF integer;
    rcsr[175620B] :bits; {receiver status}
    rbuf[175622B] :integer; {receiver buffer}
    sp		  :integer; {store pointer}
    byte	  :integer; {a data byte}
    check	  :integer; {checksum}
    bcount	  :integer; {byte count}
    staddr	  :integer; {start address}
    lderr	  :boolean; {load failure flag}


{input a data byte, accumulate checksum, decrement the count}

PROCEDURE readb :integer;
 VAR tmp :integer;
BEGIN
 LOOP
  WHEN rcsr[7]
  DO
   tmp:=rbuf MOD 400B;
   check:=check+tmp;
   dec(bcount);
   readb:=tmp
  EXIT
 END
END readb;


{Assemble one full word of data}

PROCEDURE readw :integer;
BEGIN
 readw:=readb + (readb*256)
END readw;


PROCEDURE load;
 VAR finished   :boolean;
BEGIN
 rcsr[6]:=false; {turn off interrupts}
 finished:=false; lderr:=false;
 WHILE (NOT finished) AND (NOT lderr)
 DO
  check:=1; {initialise checksum}
  byte:=readb; {lose the zero}
  bcount:=readw - 4; {get corrected byte count}
  IF bcount=2 {was byte count 6?}
  THEN
   staddr:=readw; {get jump address}
   byte:=readb;	{get checksum}
   IF (check MOD 400B)=0
   THEN
    finished:=true
   ELSE
    lderr:=true
   END
  ELSE
   sp:=readw - 1; {get corrected load address}
   LOOP {read in the remainder of the data}
    WHEN bcount=0
    DO
     byte:=readb; {get checksum byte}
     IF (check MOD 400B)=0
     THEN
      REPEAT {look for next block}
      UNTIL readb=1
     ELSE
      lderr:=true
     END
    EXIT;
    IF bcount>1
    THEN
     store[sp]:=readw
    ELSE
     store[sp]:=readb
    END;
    inc(sp)
   END {loop}
  END {if}
 END {while}
END load;

END absoluteload;


{decode two character commands from p2 console}

PROCESS x;
 VAR ch :char;
BEGIN
 LOOP
  p2write(052C); {asterisk}
  CASE readch OF
   'N' :BEGIN
	 IF readch = 'W'
	 THEN {communication with n/w}
	  yon:=true;
	  LOOP
	   p2read(ch);
	   WHEN ch = 032C {control-Z}
	   DO
	    yon:=false
	   EXIT;
	   nwwrite(ch)
	  END
	 END
	END;
   'P' :BEGIN
	 IF readch = '1'
	 THEN {communication with P1}
	  zon:=true;
	  LOOP
	   p2read(ch);
	   WHEN ch = 032C {control-Z}
	   DO
	    zon:=false
	   EXIT;
	   p1write(ch)
	  END
	 END
	END
   END; {case}
  p2write(cr); p2write(lf);
 END {loop}
END x;

{route characters from n/w to p2 console}

PROCESS y;
 VAR ch :char;
BEGIN
 LOOP
  nwread(ch);
  IF ch=01C {control-A}
  THEN
   p2write(014C); {control-L}
   load;
   IF NOT lderr
   THEN
    halt(staddr)
   ELSE
    halt(23B) {special error code}
   END
  ELSIF yon
  THEN
   p2write(ch)
  END
 END
END y;

{route characters from p1 to p2 console}

PROCESS z;
 VAR ch :char;
BEGIN
 LOOP
  p1read(ch);
  IF zon
  THEN
   p2write(ch)
  END
 END
END z;


BEGIN {monitor1}
 p2write(014C); {control-L}
 i:=1;
 REPEAT
  p2write(msg1[i]);
  inc(i)
 UNTIL i = 33;
 p2write(cr);
 p2write(lf);
 yon:=false; zon:=false;
 x;y;z
END monitor2.
{
.bp
}
