/	TITLE	BCPL CONTROL
/ Controls entry & exit of whole program and all procedures,
/ declares global vector and BCPL stack area.
/ UNIX enters at .text location 0: control is passed to
/ the head of each object module of the user's program or library,
/ where a jump bypasses the text proper, setting only the
/ global vector presets and falling into the next module.
/ This control module is always loaded, loaded last, and is
/ thus entered at G0.
/ The program is then entered as a BCPL routine called "MAINPROGRAM".
/ Procedure calls take the form:
/	jsr	r0, ROUTINE
/	N
/ where N = 2 * new frame height + 6.
/ Procedures start:
/	jsr	r1, ENTER
/	TITLE
/ Procedure exit is just:
/	jmp	EXIT
	p=r5
	.globl	ENTER
	.globl	EXIT
	.globl	GV
	.globl	G0
	.globl	G1
	.text
G0:	mov	$ENTRY, GV
	mov	$STACK, p
	jsr	r0, *GV
	6
TITLE:	13
	<MAINPROGRAM\0>
ENTRY:	jsr	r1, ENTER
	TITLE
	jmp	*GV+2.
ENTER:	mov	(r0)+, r2       / Get frame height + 6 bytes.
	add	p, r2           / Calculate new frame pointer + 6 bytes.
	mov	(r1)+, -(r2)    / Stack procedure name.
	mov	p, -(r2)        / Stack old frame pointer.
	mov	r0, -(r2)       / Stack link.
	mov	r2, p           / Set new frame pointer.
	cmp	(sp)+, (sp)+    / Clear junk off stack.
	mov	r1, pc          / Continue procedure.
EXIT:	mov	(p)+, r1        / Get link.
	mov	(p), p          / Reset frame pointer.
	mov	r1, pc          / Return.
	.bss
GV:	.=.+802.
STACK:	.=.+40000.
