; The use and distribution of the information
; contained herein may be restricted.
;
title	xcma4,<math module>,24,26-jun-74,tge/ld/mhb/tph

.sbttl	4-wd fl-pt add,sub,mul,div,cmp, and conversion routines

	org	ma

;fl-pt trap-handling routine

;fpp.in entry:
;	sp	fec
;		fea
;		pc
;		ps
;
.if	df	fpu
fpp.in:
	.sig
	+	sigfpt
	+	fpp.in
.if eq xsys
	stst	-(sp)		;not 100% right
.iff
	stst.			;100% right
.endc
	mov	r3,-(sp)	;save r3 and
	mov	r5,-(sp)	; r5 also
	mov	4(sp),r3	;get fec
	mov	6(sp),r5	; and fea also
	bit	r3,#-16-1	;is fec a legal code??
	bne	xxx.in		;nope
	add	r3,pc		;yep, so index on it
	br	xxx.in		; 0, unused on pdp-11/45
	br	xxx.in		; 2, fl. op code error
	br	fpidv0		; 4, divide by 0
	br	fpiice		; 6, integer conversion error
	br	fpiflo		;10, overflow
	br	fpiflo		;12, underflow
	br	fpiclr		;14, undefined variable
	br	xxx.in		;16, maint. trap

fpiice:	post,	pstfix		;post error
fpiext:	mov	(sp)+,r5	;restore r5 and
	mov	(sp)+,r3	; r3 also
	cmp	(sp)+,(sp)+	;knock off fec,fea
	rti			;and exit

fpidv0:	post,	pstdv0		;post error
fpiclr:	mov	(r5),r5		;get instruction in error
	ash	#-4,r5		;shift right 4 for
	bic	#-14-1,r5	;for f0, f1, f2, or f3 (0, 4, 10, or 14)
	add	r5,pc		;now index
	clrf	f0		;f0<-0
	br	fpiext
	clrf	f1		;f1<-0
	br	fpiext
	clrf	f2		;f2<-0
	br	fpiext
	clrf	f3		;f3<-0
	br	fpiext

fpiflo:	post,	pstflt		;post error
	br	fpiclr		;and zero a register
	.endc
;	flt	the float routine
;	calling sequence:
;	called with an integer on the r1 stack
;		jsr	pc,flt
;		(return)
;	returns with the integer converted to a floating-point number
;	on the r1 stack.
;
;	$ir	is the two-word polish version of the flt routine
;	$id	is the four-word polish version of the flt routine
;
flt:	.if	ndf	decmap
	mov	r0,-(sp)	;save r0
	jsr	r4,$ir		;also save r4
	.word	fixtwo		;exit by restoring r0 and r4
	.iff
	.if	df	fpu
	setd
	seti			;short integers
	ldcid	(r1)+,f0	;convert to double
	mov	scafac,r2	;get scaling pointer
	beq	1$		;none
	muld	(r2),f0		;one, so scale
1$:	std	f0,-(r1)	;store result
	rts	pc
	.iff
	mov	r0,-(sp)	;save r0
	jsr	r4,$ir		;also save r4
	.word	chkscl,$mld,fixtwo
chkscl:	mov	scafac,r0	;get scaling pointer
	beq	3$		;none
	jsr	pc,pushf2	;put scale factor on stack
2$:	jmp	@(r4)+
3$:	tst	(r4)+		;no scaling, so skip next op
	br	2$
	.endc
	.endc
	.if	df	fpu
$ir:
	.if	eq	fltlen-4
$id:	setd
	.endc
	.if	ne	fltlen-4
	setf
	.endc
	seti			;short integers
	ldcif	(r1)+,f0	;convert
	stf	f0,-(r1)	;push result
	jmp	@(r4)+
	.endc
	.if	ndf	fpu
$id:
$ir:
	mov	#220,r2		;get max. possible exponent+1
	mov	(r1),r0		;get int. arg.
	.if	eq	fltlen-4
	clr	(r1)		;clear a couple of l.sig. words
	clr	-(r1)
	mov	r0,-(r1)	;saving the arg, of course
	.endc
	clc
	bgt	pos
	beq	zerf
	neg	r0		;get absolute value
pos:	rol	-(sp)		;save sign
	clrb	(r1)		;clear lowest order fraction
fnorm:	rol	r0		;look for normal bit
	bcs	normft		;jump if found
	dec	r2		;decrease exponent
	br	fnorm		;try again
normft:	movb	r0,1(r1)	;save low order fraction
	clrb	r0
	bisb	r2,r0		;combine exponent and high order fraction
	swab	r0
	ror	(sp)+		;get sign
	ror	r0		;insert sign in result
	rorb	1(r1)
zerf:	mov	r0,-(r1)	;output result
	jmp	@(r4)+
	.endc
;	addf	the double precision add routine
;	calling sequence:
;	called with the two (4-wd fl-pt) arguments on the r1 stack
;		jsr	pc,addf
;		(return)
;	returns with the sum on the r1 stack
;
;	subf	 the double precision subtract routine
;	calling sequence:
;	called with the two (4-wd fl-pt) arguments on the r1 stack
;		jsr	pc,subf
;		(return)
;	subtracts the top item from the second item
;	and returns with the difference on the r1 stack
;
;	$add,$sbd are the polish versions of the double precision
;	add and subtract routines
;
	a1=0
	b1=2.
	c1=4.
	d1=6.
	a2=8.
	b2=10.
	c2=12.
	d2=14.
	signs=0.
$sbd:	add	#100000,(r1)	;polish rsts entry
	br	$add
subf:	add	#100000,(r1)	;normal rsts entry
addf:	mov	#rtsloc,r4
$add:
	.if	df	fpu
	setd
	ldd	(r1)+,f0	;get operand
	addd	(r1)+,f0	;add
	std	f0,-(r1)	;sum to stack
	jmp	@(r4)+
	.endc
	.if	ndf	fpu
	mov	r4,-(sp)
	mov	r5,-(sp)
	clr	-(sp)		;clear signs
	clr	r4		;clear exponents
	clr	r5
	add	#8.,r1		;fiddle with r1 stack pointer
	mov	r1,r2		;and into r2 with it
	asl	-(r2)		;shift out sign of top item
	rol	-(r2)
	rol	-(r2)		;shift a1
	rol	-(r2)		;shift a2
	bisb	1(r2),r4	;get e1
	beq	a1z1		;jump if zero
	rolb	(sp)		;get s1
	mov	r2,r1		;the real r1 stack pointer returns
	add	#16.,r2		;now to look at second stack item
	asl	-(r2)		;shift out sign of second item
	rol	-(r2)
	rol	-(r2)
	rol	-(r2)
	bisb	1(r2),r5  	;get e2
	bne	a2nz		;jump if not 0
	mov	r1,r2		;copy stack pointer
	rorb	(sp)		;reconstruct a1
	ror	(r2)+
	ror	(r2)+
	ror	(r2)+
	ror	(r2)+
	mov	(r1)+,(r2)+  	;first arg to top of stack
	mov	(r1)+,(r2)+
	mov	(r1)+,(r2)+
	mov	(r1)+,(r2)+
a1z1:	tst	(sp)+		;flush signs
	jmp	out		;done
a2nz:	rolb	signs+1(sp)   	;get s2
	movb	#1,a2+1(r1)	;insert normal bit
	movb	#1,a1+1(r1)	;insert normal bit
	sub	r4,r5		;r5=e2-e1, r4=e1
	bgt	expa		;jump if e2>e1
	mov	a2(r1),r0	;r0=a2
	mov	b2(r1),-(sp)	;r1=b2
	mov	c2(r1),r2
	mov	d2(r1),r3
	mov	(r1)+,d1(r1)
	mov	(r1)+,d1(r1)	;pop 1 arg but save first
	mov	(r1)+,d1(r1)
	mov	(r1)+,d1(r1)
	br	schk		;go check signs
expa:	add	r5,r4		;r5=e2-e1,r4=e2,e2>e1
	mov	(r1)+,r0	;r0=a1
	mov	(r1)+,-(sp)	;r1=b1
	mov	(r1)+,r2
	mov	(r1)+,r3
	swab	2(sp)		;exchange signs
	neg	r5		;e1-e2
schk:	mov	(sp)+,-(r1)	;b2 or b1 to (r1)
	cmpb	signs+1(sp),(sp)	;compare signs
	beq	echk		;they're the same. check exponent
	neg	r3		;negate operand
	adc	r2
	adc	(r1)
	adc	r0
	neg	r2
	adc	(r1)
	adc	r0
	neg	(r1)
	adc	r0
	neg	r0
echk:	tst	r5		;check exponents
	beq	shftd		;jump if e1=e2
	cmp	#-57.,r5	;is there any point in shifting?
	ble	shftr		;yes
	mov	a1+2(r1),r0	;answer is operand with
	mov	b1+2(r1),(r1)	;larger exponent
	mov	c1+2(r1),r2
	mov	d1+2(r1),r3
	br	normd
shftr:	cmp	#-8.,r5		;check # of bits to shift
	ble	sr8		;jump if not more than 1/2 word
	tst	r0
	sxt	-(sp)		;extend sign
shftr1:	cmp	#-16.,r5
	blt	sr16		;jump if not more than a word to shift
	mov	r2,r3		;shift a word at a time
	mov	(r1),r2
	mov	r0,(r1)
	mov	(sp),r0		;use extension
	add	#16.,r5		;adjust exponent
	bne	shftr1		;try again
	tst	(sp)+		;pop extension
	br	shftd		;shift is all done
sr16:	cmp	#-3,r5		;jump if not more than 3 to shift
	ble	sr8a
	mov	r1,(sp)		;save r1 stack ptr
	mov	(r1),r1
	mov	r4,-(sp)	;save exp and shift count
	mov	r5,-(sp)
	mov	r1,r4		;save r1
	ashc	r5,r0		;shift high order
	mov	r2,r5		;save r2
	ashc	(sp),r4		;shift it
	mov	r2,r4
	mov	r5,r2		;r2 done
	mov	r3,r5		;set up low order
	ashc	(sp)+,r4	;do low order
	mov	r5,r3
	mov	(sp)+,r4	;restore exponent to r4
	mov	r1,@(sp)
	mov	(sp)+,r1	;restore r1 stack ptr.
	br	shftd
sr8a:	tst	(sp)+		;pop extension
sr8:	asr	r0		;shift right
	ror	(r1)
	ror	r2
	ror	r3
	inc	r5		;count loop
	blt	sr8
shftd:	add	d1+2(r1),r3	;form the sum
	adc	r2
	adc	(r1)
	adc	r0
	add	c1+2(r1),r2
	adc	(r1)
	adc	r0
	add	b1+2(r1),(r1)
	adc	r0
	add	a1+2(r1),r0
	cmpb	signs+1(sp),(sp)	;check for unequal signs
	bne	sub		;go clean up subtract
	bit	r0,#1000
	beq	normd		;jump if no normal bit overflow
	asr	r0
	ror	(r1)
	ror	r2
	ror	r3
	inc	r4		;increase exponent
normd:	swab	r4		;move exponent left
	bne	overf		;jump if overflow
	bisb	r0,r4		;insert high order fraction
	ror	(sp)+		;insert sign
	ror	r4
	ror	(r1)
	ror	r2
	ror	r3
	adc	r3
	adc	r2
	adc	(r1)
	adc	r4
	bvs	over7		;jump if overflow on round
	bcs	over7
nflow:	mov	r4,a1+2(r1)	;store exponent and sign
	mov	(r1)+,b1(r1)	;insert low order fraction
	mov	r2,c1(r1)
	mov	r3,d1(r1)
out:	mov	(sp)+,r5
	mov	(sp)+,r4
	jmp	@(r4)+		;done. return
;
utest:	tst	r4		;check for underflow
	bgt	normd
overf:	tst	(sp)+		;pop sign
over7:	post,	pstflt
	clr	(r1)		;underflow and overflow--treat as 0
	clr	r2
	clr	r3
over8:	clr	r4
	br	nflow		;finish out normally
zero:	tst	(sp)+		;pop sign
	br	over8
;
sub:	tst	r0		;check high order result fraction
	bgt	bit9		;if positive sign is ok
	beq	ztest		;check for zero result
	neg	r3		;get absolute value
	adc	r2
	adc	(r1)
	adc	r0
	neg	r2
	adc	(r1)
	adc	r0
	neg	(r1)
	adc	r0
	swab	(sp)		;exchange signs
	neg	r0
	beq	ztest		;check for zero result
bit9:
bit9a:	bit	r0,#400		;check normal bit
	bne	utest		;jump if found
	dec	r4		;decrease exponent
	asl	r3		;double fraction
	rol	r2
	rol	(r1)
	rol	r0
	br	bit9a		;try again
ztest:	sub	#8.,r4		;reduce exponent
	tst	(r1)
	bne	zt1		;jump if only r0=0
	sub	#16.,r4
	mov	r2,(r1)
	bne	zt2		;jump if r2 not 0
	sub	#16.,r4
	tst	r3
	beq	zero		;answer is 0
	bisb	r3,(r1)		;move bytes to r0,(r1)
	swab	(r1)
	swab	r3
	bisb	r3,r0
	clr	r3		;make all others 0
	br	bit9		;go normalize
zt2:	mov	r3,r2
	clr	r3
zt1:	swab	(r1)		;move all bytes left
	bisb	(r1),r0
	clrb	(r1)
	swab	r2
	bisb	r2,(r1)
	clrb	r2
	swab	r3
	bisb	r3,r2
	clrb	r3
	br	bit9		;go normalize what's left
	.endc
;	fixf	the fixf function
;	calling sequence:
;	called with arg (4-word fl-pt no) on the r1 stack
;		jsr	pc,fixf
;		(return)
;	returns sign of arg * greatest real integer <=abs(arg)
;	on the r1 stack
;
;	$dint	same function as fixf, but called
;	in the polish mode with the arg and return on the stack.
;
fixf:	.if	df	decmap
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.endc
	.if	df	decmap
	.if	ndf	fpu
scafix:
	.endc
	.endc
fixf1:	mov	#rtsloc,r4
$dint:
	.if	df	fpu
	setd
	ldd	(r1),f0		;load arg
	modd	#1.0,f0		;get integer part
	std	f1,(r1)		;push integer
	jmp	@(r4)+		;return to caller
	.endc
	.if	ndf	fpu
	mov	r4,-(sp)
	mov	r5,-(sp)
	mov	(r1)+,r2	;spread number out
	mov	(r1)+,r3
	mov	(r1)+,r4
	mov	(r1)+,r5
	mov	r1,-(sp)	;save r1 stack pointer
	mov	r2,r0		;get exponent
	rol	r0
	clrb	r0
	swab	r0
	sub	#270,r0		;convert to -shift count
	bge	done11		;jump if arg must be integer already
	cmp	#-70,r0
	blt	shift		;jump to get integer part
	clr	r2		;answer is 0
	clr	r3
c23:	clr	r4
	clr	r5
	br	done11
shift:	cmp	#-32.,r0	;check for high or low order truncation
	blt	r23		;low
	beq	c23		;clear low order
	add	#32.,r0		;high order parts
	ashc	r0,r2		;shift out fraction
	neg	r0		;set to shift left
	ashc	r0,r2		;bring in the 0's
	br	c23		;go clear low order
r23:	ashc	r0,r4
	neg	r0
	ashc	r0,r4		;shift in 0's
done11:	mov	(sp)+,r1	;restore r1 stack pointer
	mov	r5,-(r1)	;push result
	mov	r4,-(r1)
	mov	r3,-(r1)
	mov	r2,-(r1)
	mov	(sp)+,r5
	mov	(sp)+,r4
	jmp	@(r4)+		;return
	.endc
;	mulf     the double multiply routine
;	calling sequence:
;	called with the two (4-wd fl-pt) arguments on the r1 stack
;		jsr	pc,mulf
;		(return)
;	returns with the product on the r1 stack
;
;	$mld is the polish version of the double precision
;	multiply routine
;
	a=2
	b=10.
	reslt=12.
	sign=2
	.if	df	decmap
mulf.s:
	.if	df	fpu
	setd
	ldd	(r1)+,f0	;get one operand
	muld	(r1),f0		;and multiply by other
	mov	scafac,r0	;get scaling pointer
	beq	1$		;none
	divd	(r0),f0		;correct answer
	jmp	scafix		;fix answer
1$:	std	f0,(r1)		;store answer
	rts	pc
	.iff
	tst	scafac		;scaling?
	beq	mulf		;nope
	jsr	pc,mulf		;yep, multiply first
	jsr	pc,divfsc	;divide by scaling factor
	br	scafix		;now fix result
mulfsc:	mov	scafac,r0	;get scaling pointer
	.endc
mulfr0:	jsr	pc,pushf2	;push via r0
	.endc
mulf:	mov	#rtsloc,r4
$mld:
	.if	df	fpu
	setd
	ldd	(r1)+,f0	;get operand
	muld	(r1)+,f0	;product
	std	f0,-(r1)	;product to stack
	jmp	@(r4)+
	.endc
	.if	ndf	fpu
	mov	r4,-(sp)
	mov	r5,-(sp)
	asl	(r1)		;shift multiplicand
	beq	zero1		;jump if answer is zero
	rol	-(sp)		;keep sign
	clr	-(sp)		;clear exponent
	movb	1(r1),(sp)	;keep multiplicand exponent
	movb	(r1),a+1-2(r1)	;shift fraction left
	sec			;insert normal bit
	ror	(r1)
	movb	a+3-2(r1),(r1)
	swab	a+2-2(r1)
	movb	a+5-2(r1),a+2-2(r1)
	swab	a+4-2(r1)
	movb	a+7-2(r1),a+4-2(r1)
	swab	a+6-2(r1)
	clrb	a+6-2(r1)	;make room for extra bits
	asl	b-2(r1)		;shift high multiplier
	bne	nonz		;jump if not zero
	cmp	(sp)+,(sp)+	;flush sign and exponent
zero1:	jmp	zero2
nonz:	adc	sign(sp)	;get product sign
	clr	r0		;clear product
	clr	-(r1)
	clr	r4
	bisb	b+1(r1),r4	;get exponent
	add	r4,(sp)		;get sum of exponents
	movb	#1,b+1(r1)	;insert normal bit
	ror	b(r1)
	swab	b(r1)		;left justify fraction
	movb	b+3(r1),b(r1)
	swab	b+2(r1)
	movb	b+5(r1),b+2(r1)
	swab	b+4(r1)
	movb	b+7(r1),b+4(r1)
	swab	b+6(r1)
	clrb	b+6(r1)
	mov	a(r1),-(sp)
	mov	b+6(r1),r4	;get a1*b4
	jsr	pc,emult
	mov	r4,r2		;result to product
	mov	r5,r3
	mov	a+2(r1),-(sp)
	mov	b+4(r1),r4	;get a2*b3
	jsr	pc,emult
	add	r4,r2		;add to product
	adc	(r1)
	add	r5,r3
	adc	r2
	adc	(r1)
	mov	a+4(r1),-(sp)
	mov	b+2(r1),r4	;get a3*b2
	jsr	pc,emult
	add	r4,r2
	adc	(r1)
	add	r5,r3
	adc	r2
	adc	(r1)
	mov	a+6(r1),-(sp)
	mov	b(r1),r4	;get a4*b1
	jsr	pc,emult
	add	r4,r2
	adc	(r1)
	add	r5,r3
	adc	r2
	adc	(r1)
	mov	r2,r3		;divide by 2**16
	mov	(r1),r2
	clr	(r1)
	mov	a(r1),-(sp)
	mov	b+4(r1),r4	;get a1*b3
	jsr	pc,emult
	add	r4,r2
	adc	(r1)
	add	r5,r3
	adc	r2
	adc	(r1)
	mov	a+2(r1),-(sp)
	mov	b+2(r1),r4	;get a2*b2
	jsr	pc,emult
	add	r4,r2
	adc	(r1)
	add	r5,r3
	adc	r2
	adc	(r1)
	mov	a+4(r1),-(sp)
	mov	b(r1),r4	;get a3*b1
	jsr	pc,emult
	add	r4,r2
	adc	(r1)
	add	r5,r3
	adc	r2
	adc	(r1)
	mov	a(r1),-(sp)
	mov	b+2(r1),r4	;get a1*b2
	jsr	pc,emult
	add	r4,(r1)
	adc	r0
	add	r5,r2
	adc	(r1)
	adc	r0
	mov	a+2(r1),-(sp)
	mov	b(r1),r4	;get a2*b1
	jsr	pc,emult
	add	r4,(r1)
	adc	r0
	add	r5,r2
	adc	(r1)
	adc	r0
	mov	a(r1),-(sp)
	mov	b(r1),r4	;get a1*b1
	jsr	pc,emult
	add	r4,r0
	add	r5,(r1)
	adc	r0
	mov	(sp)+,r4	;get sum of exponents
	asl	r3		;shift out normal bit
	rol	r2
	rol	(r1)
	rol	r0
	bcs	norm		;jump if it was found
	asl	r3
	rol	r2
	rol	(r1)
	rol	r0		;must have got it now
	dec	r4		;adjust exponent
norm:	sub	#200,r4		;take out one of the excess 128's
	ble	under1		;jump if underflow
	cmp	#377,r4
	blt	over2		;jump if overflow
	clrb	r3
	bisb	r2,r3		;shift fraction right
	swab	r3
	clrb	r2
	bisb	(r1),r2
	swab	r2
	clrb	(r1)
	bisb	r0,(r1)
	swab	(r1)
	clrb	r0
	bisb	r4,r0
	swab	r0
	ror	(sp)+		;get product sign
	ror	r0		;insert it in result
	ror	(r1)
	ror	r2
	ror	r3
	adc	r3		;round result
	adc	r2
	adc	(r1)
	adc	r0
	bcs	over1		;jump if overflow on round
	bvs	over1
out2:	mov	(r1)+,-(sp)	;temp save of (r1)
	add	#16.,r1		;pop arguments
	mov	r3,-(r1)	;push result
	mov	r2,-(r1)
	mov	(sp)+,-(r1)
	mov	r0,-(r1)
	mov	(sp)+,r5
	mov	(sp)+,r4
	jmp	@(r4)+		;return
over1:	tst	-(sp)		;fake sign
over2:
under1:	post,	pstflt		;under or overflow
	cmp	(sp)+,(r1)+	;flush sign and extra word in r1
zero2:	clr	r0		;clear high order result
	clr	-(r1)		;clear low order
	clr	r2
	clr	r3
	br	out2
emult:	clr	-(sp)		;clear high product
	tst	r4		;test multiplicand
	beq	mz		;jump if 0
	bgt	mplus		;+
	tst	4(sp)		;test multiplier
	beq	mz		;jump if 0
	bgt	mneg1		;+
	br	mneg
mplus:	tst	4(sp)		;test multiplier
	beq	mz		;jump if 0
	bgt	mltq		;+
	add	r4,(sp)
	br	mltq
mneg:	add	r4,(sp)
mneg1:	add	4(sp),(sp)
mltq:	mul	4(sp),r4	;get product
mdone:	add	(sp)+,r4	;add in high order parts
	mov	(sp)+,(sp)	;flush multiplier
	rts	pc		;return
mz:	clr	r4		;result is 0
	clr	r5
	br	mdone
	.endc
;	divf	the double divide routine
;	calling sequence:
;	called with the two (4-wd fl-pt) arguments on the r1 stack
;	the numerator is the second item on the stack
;	and the denominator is on top.
;		jsr	pc,divf
;		(return)
;	returns with the quotient on the r1 stack
;
;	$dvd is the polish version of the double precision
;	divide routine
;
	d=0.
	nn=8.
	q=8.
	.if	df	decmap
divf.s:	mov	scafac,r0	;get scaling pointer
	beq	divf		;none
	.if	df	fpu
	setd
	ldd	(r1)+,f1	;save divisor
	ldd	(r1),f0		;get dividend
	muld	(r0),f0		;scale dividend
	divd	f1,f0		;now divide
	jmp	scafix		;then fix result
	.iff
	movflt	(r1)+,-(sp)	;save divisor
	jsr	pc,mulfr0	;correct dividend
	movflt	(sp)+,-(r1)	;restore divisor
	jsr	pc,divf		;now divide
	jmp	scafix		;and fix result
divfsc:	mov	scafac,r0	;get scaling pointer
divfr0:	jsr	pc,pushf2	;push via r0
	.endc
	.endc
divf:	mov	#rtsloc,r4	;set return for dos convention
$dvd:
	.if	df	fpu
	setd
	ldd	(r1)+,f1	;get divisor
	ldd	(r1)+,f0	;get dividend
	divd	f1,f0		;get quotient
	std	f0,-(r1)	;to stack
	jmp	@(r4)+
	.endc
	.if	ndf	fpu
	mov	r4,-(sp)
	mov	r5,-(sp)
	clr	r2
	clr	r3
	clr	r4
	clr	r5
	clr	-(sp)
	asl	nn+0(r1)		;shift numerator
	rol	(sp)		;get numerator sign
	clr	-(sp)
	tst	(r1)		;check for division by 0
	beq	dchk		;and it is too
	bisb	nn+1(r1),(sp)	;get numerator exponent
	beq	zero3		;jump if numerator is zero
	bisb	n(r1),r2
	swab	r2		;left justify numerator fraction
	sec			;insert normal bit
	ror	r2
	bisb	nn+3(r1),r2
	bisb	nn+2(r1),r3
	swab	r3
	bisb	nn+5(r1),r3
	bisb	nn+4(r1),r4
	swab	r4
	bisb	nn+7(r1),r4
	bisb	nn+6(r1),r5
	swab	r5
	asl	(r1)		;shift denominator
	adc	2(sp)		;get result sign
	clr	r0
	bisb	d+1(r1),r0	;get divisor exponent
	sub	r0,(sp)		;subtract exponents
	swab	(r1)		;left justify denominator
	sec			;insert normal bit
	ror	(r1)
	movb	d+3(r1),(r1)
	movb	d+2(r1),d+3(r1)
	movb	d+5(r1),d+2(r1)
	movb	d+4(r1),d+5(r1)
	movb	d+7(r1),d+4(r1)
	movb	d+6(r1),d+7(r1)
	clrb	d+6(r1)
	clr	q(r1)		;clear quotient
	clr	q+2(r1)
	clr	q+4(r1)
	cmp	r2,(r1)		;compare high num. and den.
	bhi	dlow		;jump if denominator low
	blo	dhi		;jump if denominator high
	cmp	r3,d+2(r1)	;compare low order parts
	bhi	dlow
	blo	dhi
	cmp	r4,d+4(r1)
	bhi	dlow
	blo	dhi
	cmp	r5,d+6(r1)
	bhi	dlow
	bne	dhi
	inc	(sp)		;bump exponent
	clr	r0
	br	floatg
dchk:	post,	pstdv0		;division by zero
	br	ecall1
under2:	post,	pstflt		;under or overflow
ecall1:
zero3:	cmp	(sp)+,(sp)+	;flush exp and sign
	mov	r1,r2		;make result 0
	add	#8.,r2
	clr	(r2)+
	clr	(r2)+
	clr	(r2)+
	clr	(r2)+
	br	rtn
dlow:	ror	r2		;halve denominator  (c=0)
	ror	r3		;to ensure that n<d
	ror	r4
	ror	r5
	inc	(sp)		;compensate exponent
dhi:	mov	#9.,-(sp)	;go do first 9 quotient bits
	jsr	pc,div1
	movb	r0,q(r1)	;save all high order q fraction
				;except normal bit
	tst	(sp)		;see if done
	bne	float1		;yes, rest of numerator is 0
	mov	#16.,(sp)	;go do 16 more bits
	jsr	pc,div1
	mov	r0,q+2(r1)
	tst	(sp)
	bne	float1
	mov	#16.,(sp)
	jsr	pc,div1
	mov	r0,q+4(r1)
	tst	(sp)
	bne	float1
	mov	#16.,(sp)
	jsr	pc,div1
	br	float
float1:	clr	r0		;clear lowest order quotient
float:	tst	(sp)+		;exp.to top of sp
floatg:	add	#200,(sp)	;add in excess 200
	ble	under2		;underflow
	cmp	#377,(sp)
	blt	over4		;overflow
	movb	(sp),q+1(r1)	;insert exponent in reslt
	tst	(sp)+		;pop exponent
	ror	(sp)+		;insert quotient sign
	ror	q+0(r1)
	ror	q+2(r1)
	ror	q+4(r1)
	ror	r0
	adc	r0		;round
	adc	q+4(r1)
	adc	q+2(r1)
	adc	q+0(r1)
	mov	r0,q+6(r1)	;insert low order fraction
	bcs	over6
	bvs	over6
rtn:	mov	(sp)+,r5
	mov	(sp)+,r4
	add	#8.,r1		;flush first argument
	jmp	@(r4)+
over6:	cmp	-(sp),-(sp)	;fake sign and exp.
over4:	br	ecall1
div1:	asl	r0		;shift quotient
	asl	r5		;shift numerator
	rol	r4
	rol	r3
	rol	r2
	bcs	go		;guaranteed to go
	cmp	(r1),r2		;compare high divisor and dividend
	bhi	nogo		;jump if divisor bigger
	blo	go		;jump if divisor smaller
	cmp	d+2(r1),r3	;check the low orders
	bhi	nogo
	blo	go
	cmp	d+4(r1),r4
	bhi	nogo
	blo	go
	cmp	d+6(r1),r5
	bhi	nogo
	beq	neqd		;jump if numerator =denominator
go:	sub	d+6(r1),r5	;n=n-d
	sbc	r4
	sbc	r3
	sbc	r2
	sub	d+4(r1),r4
	sbc	r3
	sbc	r2
	sub	d+2(r1),r3
	sbc	r2
	sub	(r1),r2
	inc	r0		;insert quotient bit
nogo:	dec	2(sp)		;count loop
	bgt	div1
	rts	pc
neqd:	inc	r0		;insert last 1 bit in quotient
	br	eq1
eq2:	asl	r0		;finish out quotient with 0's
eq1:	dec	2(sp)
	bgt	eq2
	inc	2(sp)		;flag no more numerator
	rts	pc		;return to caller
	.endc
;	fix	the fix routine
;	calling sequence:
;	called with a floating-point number on the r1 stack
;		jsr	pc,fix
;		(return)
;	returns with the floating-point number converted to an integer
;	and stored on the r1 stack
;
;	$ri	is the two-word polish version of the fix routine
;	$di	is the four-word polish version of the fix routine
;
fix:	.if	ndf	decmap
	mov	r0,-(sp)	;r0 gets saved
	jsr	r4,$ri		;so does r4
	.word	fixtwo		;return from fix routine
fixtwo:	mov	(sp)+,r4	;restore r4
	mov	(sp)+,r0	;and r0
	rts	pc
	.iff
	.if	df	fpu
	setd
	seti			;short integers
	ldd	(r1)+,f0	;get floating number
	mov	scafac,r2	;get scaling pointer
	beq	1$		;none
	divd	(r2),f0		;divide by scaling factor
1$:	stcdi	f0,-(r1)	;convert and stash on r1 stack
	rts	pc		;then exit
	.iff
	mov	r0,-(sp)	;r0 gets saved
	jsr	r4,chkscl	;go check for scaling
	.word	$dvd,$ri,fixtwo
fixtwo:	mov	(sp)+,r4	;restore r4
	mov	(sp)+,r0	;and r0
	rts	pc
	.endc
	.endc
$ri:
	.if	df	fpu
	.if	eq	fltlen-4
$di:	setd			;double precision
	.endc
	.if	ne	fltlen-4
	setf
	.endc
	seti			;short integers
	ldd	(r1)+,f0	;get arg
	stcdi	f0,-(r1)	;convert
	jmp	@(r4)+		;return
	.endc

	.if	ndf	fpu
	.if	eq	fltlen-4
$di:	mov	(r1)+,2(r1)	;trunc. to real format
	mov	(r1)+,2(r1)
	.endc
	clr	r2		;clear work space
	inc	r2		;set up normal bit
	mov	(r1)+,r0	;get real argument
	rol	(r1)		;get sign
	rol	r0		;and
	rol	-(sp)		;save it
	movb	r0,r3		;get high order fraction
	clrb	r0
	swab	r0		;get exponent
	sub	#201,r0
	blt	zero5		;jump if it is too small
	beq	done2
	cmp	#15.,r0
	blt	over3		;jump if it is too big
	swab	r3		;form 16 bits of high order fraction
	clrb	r3
	bisb	1(r1),r3
	ashc	r0,r2
done2:	neg	r2		;make -
	bvs	negm		;jump if possible negmax
	bgt	over3		;jump if more than 15 bits
sign2:	ror	(sp)+		;get sign
	bcs	out4		;jump if -
	neg	r2		;- result
out4:	mov	r2,(r1)		;store integer result
	jmp	@(r4)+		;return to caller
negm:	ror	(sp)+
	bcs	out4		;ok if result to be -
	tst	-(sp)		;fake sign
over3:	post,	pstfix
zero5:	clr	r2		;answer is 0
	br	sign2
	.endc
;	cmpf	the double precision compare routine
;	calling sequence:
;	called with the two (4-wd fl-pt)
;	comparands on the r1 stack:
;	first is at 8(r1), second is (r1)
;		jsr	pc,cmpf
;		(return)
;	returns with only the first comparand
;	on the r1 stack and with the condition codes set as follows:
;	first < second  n=1, z=0
;	first = second  n=0, z=1
;	first > second  n=0, z=0
;
;	$cmd	is the double precision polish version of the compare routine
;
cmpf:	mov	#rtsloc,r4	;set return for rsts
$cmd:
	.if	df	fpu
	setd
	ldd	(r1)+,f0	;get second arg
	cmpd	(r1),f0		;compare
	cfcc			;get condition codes
	jmp	@(r4)+
	.endc
	.if	ndf	fpu
	mov	#16601,r0	;get 00xxxxx   xxxx01 in r0
	mov	8.(r1),r3	;get high order first arg
	bge	fpos		;jump if first arg +
	asl	r0		;flag first arg -
	mov	(r1)+,r2	;get high second arg
	blt	same		;jump if both signs -
	br	neg		;jump if first - and second +
fpos:	mov	(r1)+,r2
	blt	pls		;jump if first + and second -
same:	cmp	r3,r2		;compare magnitudes
	bne	out1		;jump if different
	cmp	8.(r1),(r1)
	bne	out1
	cmp	10.(r1),2(r1)
	bne	out1
	cmp	12.(r1),4(r1)
	bne	out1
	clr	r0		;flag =
out1:	ror	r0		;save c bit and test second arg -
	bcs	pls		;jump if second arg +
neg:	neg	r0		;reverse c bit
pls:	add	#6,r1		;pop args, leaving second arg for rsts
	tst	r0		;set z and n bits correctly
	jmp	@(r4)+		;return to caller
	.endc
	.end
