#
/*
 *	lpr -- spool printout for online printer.
 *		has been modified extensively from distrib
 *
 */

#define TLIMIT	3	/* max number of 256 block increments allowed
			   for copy file */
#define privlusr 5		/* the elite can have prty print */

char tfnmh[]	"/tmp/lpd/tfaXXXXXX";
char lfnmh[]	"/tmp/lpd/lfaXXXXXX";
char cfnmh[]	"/tmp/lpd/cfaXXXXXX";
char dfnmh[]	"/tmp/lpd/x/dfxXXXXXX";

 
int	nact;
int	tff;
int	quick;
int	iden;
int	wflag;
char	statbuf[20];
int	buf[256];
char	remmsg[]	": can't remove\n";
unsigned ncopies	0;

struct {
	int	hi_int;
	int	lo_int;
};

struct {
	char	lo_byte;
	char	hi_byte;
}

main(argc, argv)
int argc;
char *argv[];
{
	register char *arg ,*cb;
	int flag=0,xban=0,push=0;	char *xmsg=0;
	int register f;
	extern rubout();

	if( ! (signal(2, 1) & 01) ) signal(2, rubout);
	mktemp(lfnmh); mktemp(cfnmh);
	tff = creat(mktemp(tfnmh), 0600);
	if(tff < 0)
	{
		prints(2, tfnmh);
		prints(2, ": can't create\n");
		exit(1);
	}
	while (argc>1 && (arg = argv[1])[0]=='-')
	{
		switch (0177 & arg[1])
		{

	    case 'c':
			flag = '+';
			break;

	    case 'r':
			flag = '-';
			break;

	    case 'e':
			if(arg[2] > '0' && arg[2] <= '9')
				quick =+ arg[2]-'0';
			else quick++;
			break;

	    case 's':
			quick--;
			break;
	    case 'i':
			cb = &buf[100];
			arg++;
			while(*cb++ = *++arg);
			cb[-1] = ':';
			iden++;
			break;
	    case 'x':
			xban++;
			break;
	    case 'p':
			push++;
			break;
	    case 'm':
			xmsg = arg+1;
			break;
	    case 'n':
			ncopies = &arg[2];
			break;
		}
		argc--;
		argv++;
	}
	f = getuid();
	if( ( f == 0 ) && ( quick >= 0 ) ) quick=9;	/* ensure us super user types dont wait */
	if(f <= privlusr)
		quick++;
	else	if(quick > 0) quick = 0;
	if(quick < -1) quick = -1;
	if(quick >= 9) quick = 9-(f!=0);
	if(xban==0) ident();
	if(push) card('p',"p");
	if( ncopies ) card('n', ncopies);
	if(argc == 1)
		copy(0);
	while(--argc)
	{
		arg = *++argv;
		if( !owner(arg) ) continue;
		if(flag == '+')
			goto cf;
		if(*arg == '/'  )
		{
			if( (f=open(arg,0))<=0 )
			{
				prints(2, arg);
				prints(2, ": can't open\n");
				continue;
			}
			close(f);
			card('F', arg);
			if( flag == '-' )
				if( wflag )
					card('u',arg);
				else
				{
					prints(2, arg);
					prints(2, remmsg);
				}
			nact++;
			continue;
		}
		f = ranname(lfnmh);
		if(link(arg, f))
				goto cf;
		card('F', f);
		card('U', f);
		nact++;
		goto df;
	cf:
		f = open(arg, 0);
		if(f < 0)
		{
			prints(2, arg);
			prints(2, ": can't open\n");
			continue;
		}
		copy(f);
		close(f);
	df:
		if( (flag == '-') )
			if( wflag )
				f = unlink(arg);
			else
			{
				prints(2, arg);
				prints(2, remmsg);
			}
	}

	if( xmsg ){
		*xmsg = ttyn(2);
		card('M', xmsg);
	}
	if( fork() ) exit(0);	/* return control to user */
	if(nact)
	{
		dfnmh[13] =- quick;
		if(link(tfnmh,mktemp(dfnmh)))
		{
			prints(2, "can't rename in LPD\n");
			exit();
		}
		unlink(tfnmh);
		execl("/etc/lpd", "lpd", 0);
	}
	unlink(tfnmh);
}

copy(f)
int f;
{
	int register i;	long nc;
	int ff, fn;

	ff = creat(fn=ranname(cfnmh),0666);
	if(ff < 0) {
		prints(2, "can't create in LPD spool\n");
		return;
	}
	nc = 0;
	while((i = read(f, buf, 512)) > 0) {
		write(ff, buf, i);
		nc =+ i;
		if(nc.hi_int > TLIMIT) {
			prints(2, "copy file is too large\n");
			break;
		}
	}
	close(ff);
	card('F', fn);
	card('U', fn);
	nact++;
}

card(c, s)
int c;
char s[];
{
	write(tff,&c,1);
	write(tff,s,39);	/* lpd record size is 40 chars */
}

ident()
{
	register char *b1p, *b2p;

	b2p = &buf[100];
	if(!iden && getpw(getuid(), b2p)) b2p = "pdp:";
	b1p = b2p;
	while(*b2p++ != ':') ;
	b2p[-1] = 0;
	card('L', b1p);
}

ranname(s)
char s[];
{

loop:
	s[11]++;
	if(stat(s, statbuf))
		return(s);
	goto loop;
}

owner(file)
char	*file;
{
	register uid;

	wflag = 0;
	if( stat(file, statbuf)<0 ){
		prints(2, file);
		prints(2, ": non-existent\n");
		return(0);
	}
	wflag = !(statbuf[5] & 0140);	/* file is ordinary */
	if( ( statbuf[7] == ( uid = (getuid() & 0377))) || (uid == 0 ) )
		return(1);
	wflag = wflag && (statbuf[4] & 02);
	return( statbuf[4] & 04 );	/* read permission */
}
rubout()
{
	unlink(tfnmh); unlink(cfnmh);
	unlink(lfnmh); unlink(dfnmh);
	exit(-1);
}
