#
#include	"libr.h"

main(argc,argv)
int argc;
char **argv;
{
	iargc = argc - 1;
	iargv = &argv[1];

	memlow = sbrk(GOBBLE);
	if(memlow == -1)
		ferror("Core allocation failure.");
	memhigh = memlow + GOBBLE;

	if(pass1())
		pass2();
}
pass1()
{
	int listf,actionf;
	int cmd,lcount;
	int *whmod,*whsym;
	register char *rr1,*rr2;
	register struct mod *modpnt;
	struct mod *clist;
	struct file *whfile;

	listf = 0;
	actionf = 0;
	if((libfile = getfile()) == NIL)
		ferror("Cannot get library name");
	command = makelist(libfile);

	while(cmd = getcmd())
	switch(cmd) {

	case GLOBAL:
		actionf++;
		whmod = getarg();
		if(whmod == NIL)
			ferror("No module name for GLOBAL");
		modpnt = find(command,whmod);
		if(modpnt == NIL) {
			radixout(whmod);
			ferror(": not found");
		}
		while(whsym = getarg()) {
			for(rr1 = modpnt->mg; rr1 != NIL && req(rr1->gn,whsym) == NIL; rr1 = rr1->gf);
			if(rr1 == NIL) {
				radixout(whsym);
				ferror(" : symbol not found");
			}
			if(rr1->gb == NIL)
				modpnt->mg = rr1->gf;
			else
				rr1->gb->gf = rr1->gf;
			if(rr1->gf != NIL)
				rr1->gf->gb = rr1->gb;
		}
		break;

	case DELETE:
		actionf++;
		while(whmod = getarg()) {
			modpnt = find(command,whmod);
			if(modpnt == NIL) {
				radixout(whmod);
				ferror(": module not found");
			}
			modpnt->ma = ACT_DEL;
		}
		break;

	case APPEND:
		actionf++;
		while(whfile = getfile()) {
			clist = makelist(whfile);
			if(clist == NIL) {
				fileout(whfile);
				ferror(" : file empty");
			}
			if(command == NIL)
				command = clist;
			else {
				for(rr1 = command; rr1->mf != NIL; rr1 = rr1->mf);
				rr1->mf = clist;
				clist->mb = rr1;
			}
		}
		break;

	case INSERT:
		actionf++;
		whmod = getarg();
		if(whmod == NIL) 
			ferror("No module name for insert");
		modpnt = find(command,whmod);
		if(modpnt == NIL) {
			radixout(whmod);
			ferror(": cannot find module");
		}
		while(whfile = getfile()) {
			clist = makelist(whfile);
			if(clist == NIL) {
				fileout(whfile);
				ferror(" : cannot open");
			}
			for(rr1 = clist; rr1->mf != NIL; rr1 = rr1->mf);
			modpnt->mb->mf = clist;
			clist->mb = modpnt->mb;
			rr1->mf = modpnt;
			modpnt->mb = rr1;
		}
		break;

	case LIST:
		listf++;
		break;

	case REPLACE:
		actionf++;
		while(whfile = getfile()) {
			clist = makelist(whfile);
			if(clist == NIL) {
				fileout(whfile);
				ferror(": cannot open");
			}
			modpnt = find(command,clist->mf->mn);
			if(modpnt == NIL) {
				radixout(clist->mf->mn);
				ferror(": cannot find module");
			}
			modpnt->mb->mf = clist;
			clist->mb = modpnt->mb;
			modpnt->mb = clist->mf;
			clist = clist->mf->mf;
			modpnt->mb->mf = modpnt;
			modpnt->ma = ACT_DEL;
			while(clist->ma != ACT_CLS) {
				modpnt = find(modpnt,clist->mn);
				if(modpnt == NIL) {
					radixout(clist->mn);
					ferror(": module not found");
				}
				modpnt->mb->mf = clist;
				clist->mb = modpnt->mb;
				modpnt->mb = clist;
				clist = clist->mf;
				modpnt->mf->mf = modpnt;
				modpnt->ma = ACT_DEL;
			}
			modpnt->mb->mf = clist;
			clist->mb = modpnt->mb;
			modpnt->mb = clist;
			clist->mf = modpnt;
		}
		break;
	case	CREF:
		creff++;
		listf++;
		break;

	}	/* end of switch */

	if(command == NIL) 
		ferror("Null library");

	if(listf) {
		printf("\n\nContents of library ");
		fileout(libfile);
		printf("\nModule\tIdent\tDeclares\n\n");
		for(rr1 = command; rr1 != NIL; rr1 = rr1->mf)
			if(rr1->ma == ACT_PAS) {
				radixout(rr1->mn); printf("\t");
				radixout(rr1->mv); putchar('\t');
				lcount = 6;
				for(rr2 = rr1->mg; rr2 != NIL; rr2 = rr2->gf) {
					radixout(rr2->gn);
					printf("\t");
					if(--lcount == 0) {
						printf("\n\t\t");
						lcount = 6;
					}
				}
				if(lcount != 6)
					printf("\n");
				printf("\n");
			}
	}

	crefout();
	return(actionf);
}

radixout(w)
int *w;
{
	register int c1,c3,c2;
	extern int ldivr;
	char *ss;
	
	ss = " abcdefghijklmnopqrstuvwxyz$. 0123456789";

	c3 = 2;
	do {
		c1 = *w++;
		c2 = lrem(0,c1,050);
		c1 = ldiv(0,c1,050);
		c1 = ldiv(0,c1,050);
		putchar(ss[c1]);
		putchar(ss[ldivr]);
		putchar(ss[c2]);
	} while(--c3);
}

struct mod *find(list,name)
struct mod*list;
int *name;
{
	register struct mod *mm;

	for(mm = list; mm != NIL; mm = mm->mf)
		if(mm->ma == ACT_PAS && req(mm->mn,name))
			return(mm);
	return(NIL);
}

req(r1,r2)
int *r1,*r2;
{
	if(*r1++ == *r2++ && *r1 == *r2)
		return(1);
	return(NIL);
}

fileout(f)
struct file *f;
{
	printf("%s",f->fn);
}

ferror(s)
char *s;
{
	printf("%s\n",s);
	exit(1);
}

struct buf *openi(fp)
struct file *fp;
{
	register struct buf *bp,*cp;
	register int i;

	for(bp = &inbuf; bp->nxtbuf != NIL && bp->fildes != NIL; bp = bp->nxtbuf);
	if(bp->fildes != NIL) {
		cp = getcore(sizeof inbuf);
		bp->nxtbuf = cp;
		bp = cp;
	}
	i = open(fp->fn,0);
	if(i == -1)
		return(NIL);
	bp->fildes = i;
	bp->nonused = 0;
	return(bp);
}

closei(bp)
struct buf *bp;
{
	close(bp->fildes);
	bp->fildes = NIL;
}

struct mod *makelist(fp)
struct file *fp;
{
	register struct mod *em;
	register char *cp;
	register int t;
	struct mod *mm;
	struct buf *bp;
	int icount,ignore;
	struct glist *gx;

	if((bp = openi(fp)) == NIL)
		return(NIL);

	gx = NIL;
	mm = em = getcore(S_MOD);
	em->ma = ACT_INF;
	em->mff = fp;
	while(t=getrec(bp))
		switch(t) {

		case GSD:
			while((t = getgsd()) >= 0)
				switch(t) {
				
				case MDN:
					cp = getcore(S_MOD);
					em->mf = cp;
					cp->mb = em;
					cp->ma = ACT_PAS;
					cp->mff = fp;
					em = cp;
					em->mn[0] = gsd.gsdnm[0];
					em->mn[1] = gsd.gsdnm[1];
					if(gx != NIL) {
						ignore = 1;
						em->mg = gx;
						gx = NIL;
					} else
						ignore = NIL;
					break;

				case GSN:
					if((gsd.fb&DEF) && ignore == NIL ) {
						cp = getcore(S_GLIST);
						cp->gn[0] = gsd.gsdnm[0];
						cp->gn[1] = gsd.gsdnm[1];
						cp->gf = em->mg;
						if(em->mg != NIL)
							em->mg->gb = cp;
						em->mg = cp;
					}
					if((gsd.fb&DEF) == 0) {
						cp = getcore(S_GLIST);
						cp->gn[0] = gsd.gsdnm[0];
						cp->gn[1] = gsd.gsdnm[1];
						cp->gf = em->mr;
						if(em->mr != NIL)
							em->mr->gb = cp;
						em->mr = cp;
					}
					break;

				case PVI:
					em->mv[0] = gsd.gsdnm[0];
					em->mv[1] = gsd.gsdnm[1];
					break;

				}

		case LMOD:
			for(t = 0; t<bcount;) {
				cp = getcore(S_GLIST);
				if(gx == NIL)
					gx = cp;
				else {
					cp->gf = gx;
					gx->gb = cp;
				}
				gx = cp;
				cp = cp->gn;
				icount = 4;
				do
					*cp++ = binbuf[t++];
				while(--icount);
			}
			break;

		}
	cp = getcore(S_MOD);
	cp->ma = ACT_CLS;
	cp->mff = fp;
	em->mf = cp;
	cp->mb = em;
	closei(bp);
	return(mm);
}

char *getitem(itemcode)
{
	register char *r;
	static char *sitem;
	if(sitem == NIL)
		sitem = rawitem();
	if(*sitem == '-' && itemcode ==ARGUMENT)
		return(NIL);
	r = sitem;
	sitem = NIL;
	return(r);
}

char *rawitem()
{
	if(index == iargc)
		return(NIL);
	return(iargv[index++]);
}

