#
#include "../gpac.h"
#include "../error_codes.h"

line(dx, dy)
	double dx, dy;
	{
	return(lineto(Gx_beg+dx, Gy_beg+dy));
	}

moveto(x, y)
	double x, y;
	{
	return(Gcurset(x, y, BPOINT));
	}

move(dx, dy)
	double dx, dy;
	{
	return(Gcurset(Gx_beg+dx, Gy_beg+dy, BPOINT));
	}

point(x, y)
	double x, y;
	{
	return(Gcurset(x, y, VPOINT));
	}

lineto(x, y)
	double x, y;
	{
	register ix, iy, indicator;
	double old_x, old_y;

	if((Gcontrol_state & SEG_OPEN) && !(Gmem_status & CORE_FULL))
		{
		if(Gctm_pu)
			Gctm_update();
		Gx_beg = x;
		Gy_beg = y;
		old_x = Gtransx_beg;
		old_y = Gtransy_beg;
		if(Gctm_mod)
			Gctm_trans(&x, &y);
		Gtransx_beg = x;
		Gtransy_beg = y;
		/*
		 * clip the line please
		 */
		Gclip(old_x, old_y, x, y);
		GOOD_RETURN;
		}
	   else
		return(Gerror(SEG_COREERR));
	}



Gcurset(x, y, intensity)
	double x;
	double y;
	int intensity;
	{
	register ix, iy;
	register i;

	if((Gcontrol_status & SEG_OPEN) && !(Gmem_status & CORE_FULL))
		{
		if(Gfill)
			Gclosefill(x, y);
		Gx_beg = x;
		Gy_beg = y;
		if(Gctm_mod)
			Gctm_trans(&x, &y);
		Gtransx_beg = x;
		Gtransy_beg = y;
		if(!(i = Gregion(x, y)))
			{
			if(Gwv_mod)
				Gwv_trans(&x, &y);
			Gadd_queue(intensity, (ix = x+.5), (iy = y+.5));
			}
		   else
			if(Gfill)
				Gsidein(i, x, y, BPOINT);
		GOOD_RETURN;
		}
	   else
		return(Gerror(SEG_COREERR));
	}


Gclip(x1, y1, x2, y2)
	double x1, x2, y1, y2;
	{
	register c1, c2, ctemp;
	int codes, swap;
	double temp;

	swap = 0;
	c1 = Gregion(x1, y1);
	c2 = Gregion(x2, y2);
/*
printf("clip c1 and c2 are : %o %o\n", c1, c2);
*/
	codes = (c1<<4)+c2;
	if(Gfill && c1)
		Gsidein(c1, x1, y1, BVECTOR);
	while(c1 || c2)
		{
		if(c1 & c2) 
			{
			if(Gfill)
				Gsidein(c2, x2, y2, BVECTOR);
			return;
			}
		if(c1 == 0)
			{
			ctemp = c1;
			c1 = c2;
			c2 = ctemp;
			temp = x1;
			x1 = x2;
			x2 = temp;
			temp = y1;
			y1 = y2;
			y2 = temp;
			swap = !swap;
			}
		if(c1 & 01)
			{
			y1 = y1+(y2-y1)*(Gwx_left-x1)/(x2-x1);
			x1 = Gwx_left;
			}
		   else
		if(c1 & 02)
			{
			y1 = y1+(y2-y1)*(Gwx_right-x1)/(x2-x1);
			x1 = Gwx_right;
			}
		   else
		if(c1 & 04)
			{
			x1 = x1+(x2-x1)*(Gwy_bottom-y1)/(y2-y1);
			y1 = Gwy_bottom;
			}
		   else
		if(c1 & 010)
			{
			x1 = x1+(x2-x1)*(Gwy_top-y1)/(y2-y1);
			y1 = Gwy_top;
			}

		c1 = Gregion(x1, y1);
		if(!swap && Gfill && c1)
			Gsidein(c1, x1, y1, BVECTOR);
		}
	if(swap)
		{
		temp = x1;
		x1 = x2;
		x2 = temp;
		temp = y1;
		y1 = y2;
		y2 = temp;
		}
	if(Gwv_mod)
		Gwv_trans(&x2, &y2);
	if(codes >= 16)
		{
		if(Gwv_mod)
			Gwv_trans(&x1, &y1);
		Gadd_queue(Gblank_line, (c1 = x1+0.5), (c1 = y1+0.5));
		}
	Gadd_queue(VECTOR, (c1 = x2+0.5), (c1 = y2+0.5));
	}


Gregion(x, y)
	double x, y;
	{
	register i;

	if(x < Gwx_left)
		i = 01;
	   else
		if(x > Gwx_right)
			i = 02;
		   else
			i = 0;

	if(y < Gwy_bottom)
		i =| 04;
	   else
		if(y > Gwy_top)
			i =| 010;

	return(i);
	}
