#

	/*
	 * CONTROL MODULE FOR GPAC
	 */

#include "../gpac.h"
#include "../error_codes.h"

del_all(seg1, seg2)
	int seg1, seg2;
	{
	register *addr, *naddr;
	register struct segment *segp;
	int n;
	int *eaddr;

	if(seg1 <= 0 || seg2 < seg1 || seg2 > Gmax_segs)
		return(Gerror(ISERR, seg1));
	for(n = seg1; n <= seg2; n++)
		{
		if(Gseg_table[n].start_address == 0)
			continue;
		addr = Gnxt_seg(Gseg_table[n].end_address);
		Gset_nxtblk(Gseg_table[n].back_address, addr);
		for(segp = Gseg_table; segp <= &Gseg_table[Gmax_segs]; segp++)
			if(segp->start_address == addr)
				break;
		segp->back_address = Gseg_table[n].back_address;
		if(Gfil_end == Gseg_table[n].end_address)
			Gfil_end = segp->back_address;
		}

	Gwaitstop();

	for(n = seg1; n <= seg2; n++)
		{
		if(Gseg_table[n].start_address == 0)
			continue;
		eaddr = Gnxt_seg(Gseg_table[n].end_address);
		addr = Gseg_table[n].start_address;
		do
			{
			naddr = Gnxt_blk(addr);
			Grel_blk(addr-1);	/*  get back to start of block  */
			} while((addr = naddr) != eaddr);
		Gseg_table[n].start_address = 0;
		}
	Gcontrol_status =| CLEAR_SCREEN;
	GOOD_RETURN;
	}
