#

	/*
	 *	GPAC TABLET GW ROUTINES
	 */


#include "../gpac.h"
#include "../error_codes.h"
#include "tab.h"

activate(evnt_type, arg)
	int evnt_type, arg;
	{
	register i, mask;

	switch(evnt_type)
		{
		case INKING :
			if(Gtablet.buf_addr == 0)
				{
				Gtablet.buf_addr = Gget_blk();
				if(*(Gtablet.buf_addr)-2 > Gtablet.desired_ink_size)
					{
					Gtrimblk(Gtablet.buf_addr, Gtablet.desired_ink_size);
					Gtablet.curr_ink_size = Gtablet.desired_ink_size;
					}
				   else
					Gtablet.curr_ink_size = *Gtablet.buf_addr - 2;
				}
			clearink();
			Gactevnt[INKING] = ON;
			break;
		case Z_AXIS_DOWN :
		case BUTTON1_DOWN :
		case BUTTON2_DOWN :
		case BUTTON3_DOWN :
			Gactevnt[evnt_type] = ON;
			break;
		case Z_AXIS_UP :
		case BUTTON1_UP :
		case BUTTON2_UP :
		case BUTTON3_UP :
		case RANGE_OUT :
		case RANGE_IN :
		case INTRVL1 :
		case INTRVL2 :
		case INTRVL3 :
		case TIMEOUT :
		case TTY :
		default :
			return(Gerror(ACT_INVALERR, evnt_type));
		}
	GOOD_RETURN;
	}


