
/*
 *  Gremlin for the X window package.  Hacked from the aed gremlin.
 *  
 *  aed version copyright:
 *  Copyright -C- 1982 Barry S. Roitblat
 */
#include "gremlin.h"
#include "grem2.h"

char* malloc();

extern FontInfo *text_font[5][5];
extern char* text_font_names[5][5];

/* imports from graphics1.c */

extern int halftone;
extern Pattern	brush[];

extern int rmask, GrXMax, GrYMax, charysize, charxsize, descenders;

/* imports from main.c */

extern error();
extern OpaqueFrame FrameList[];
extern SEQ, CFONT, CSIZE, CBRUSH, CJUST;

extern Font pointfont;
extern POINT *POINTLIST;

/* The following is available to the outside world */

int artmode;
/*
 *  sick.  max number of vectors for X is assumed to be a full screen
 *  circle.
 */
Vertex vlist[2300];

GRVector(point1,point2,style)
POINT *point1,*point2;
int   style;
{
	int brushsize, bstyle;

	vlist[0].x = (int)point1->x;
	vlist[0].y = (int)point1->y;
	vlist[0].flags = 0;
	vlist[1].x = (int)point2->x;
	vlist[1].y = (int)point2->y;
	vlist[1].flags = VertexDrawLastPoint;
	
	switch(style)
	{
		case 3:
		case -4:
			brushsize = 3;
			break;
		case 6:
		case -7:
			brushsize = 2;
			break;
		default:
			brushsize = 1;
	}
	/*
	 *  negative styles are erase.  erasing thick brushes doesn't work
	 *  in X.10  Applies throught this file.
	 */
	if(style<0)
		XDraw(FrameList[PAGE_WIN].self,vlist,2,brushsize,brushsize,WhitePixel,GXcopy,AllPlanes);
	else
	{
		if(halftone) style +=NBRUSHES;
			XDrawPatterned(FrameList[PAGE_WIN].self,vlist,2,brushsize,brushsize,BlackPixel,WhitePixel,brush[style],GXcopyInverted,AllPlanes);
	}
}

#define pi 3.14159265357
#define log2_10 3.321915

/*
 *  should use X splines to do this.  there's some ugly rounding errors.
 */
int
GRArc(center,cpoint,angle,style)
POINT *center, *cpoint;
double angle;
int   style;
{
	double xs, ys, radius, resolution, t1, epsalon, fullcircle;
	double degreesperpoint;
	int    i, extent, brushsize;
	POINT  next, *foo;

	xs = cpoint->x - center->x;
	ys = cpoint->y - center->y;
	if ((xs == 0) && (ys == 0))       /* radius = 0 */
	{
		error("Arc: zero radius");
		return(-1);
	}

/* calculate drawing parameters */

	radius = sqrt(xs * xs + ys * ys);
	t1 = floor(log10(radius) * log2_10);
	resolution = pow(2.0, t1);
	epsalon = 1.0 / resolution;
	fullcircle = ceil(2 * pi * resolution);
	degreesperpoint = 360.0 / fullcircle;

	if (angle == 0) 
		extent = fullcircle;
	else extent = angle/degreesperpoint;

	for (i=0; i<extent; ++i)
	{
		if(i>=2300)
		{
			error("SHArc: circle too large.");
			return;
		}
		xs += epsalon * ys;
		vlist[i].x = (short) (xs + center->x) ;   /* round */
		ys -= epsalon * xs;
		vlist[i].y = (short) (ys + center->y) ;   /* round */
		vlist[i].flags = VertexDrawLastPoint;
	}   /* end for */;
	switch(style)
	{
		case 3:
		case -4:
			brushsize = 3;
			break;
		case 6:
		case -7:
			brushsize = 2;
			break;
		default:
			brushsize = 1;
	}
	if(style<0)
		XDraw(FrameList[PAGE_WIN].self,vlist,i,brushsize,brushsize,WhitePixel,GXcopy,AllPlanes);
	else
	{
		if(halftone) style +=NBRUSHES;
		XDrawPatterned(FrameList[PAGE_WIN].self,vlist,i,brushsize,brushsize,BlackPixel,WhitePixel,brush[style],GXcopyInverted,AllPlanes);
	}
	return(0);
}  /* end GRArc */;


#define MAXPOINTS 200

static Paramaterize(x, y, h, n)
float x[MAXPOINTS], y[MAXPOINTS], h[MAXPOINTS];
int n;
/*     This routine calculates parameteric values for use in calculating
 * curves.  The parametric values are returned in the array u.  The values
 * are an approximation of cumulative arc lengths of the curve (uses cord
 * length).  For additional information, see paper cited below.
 */

{
	int i,j;
	float u[MAXPOINTS];

	for (i=1; i<=n; ++i)
	{
		u[i] = 0;
		for (j=1; j<i; ++j)
		{
			u[i] += sqrt(pow((double) (x[j+1] - x[j]), (double) 2.0)
			         + pow((double) (y[j+1] - y[j]), (double) 2.0));
		}
	}
	for (i=1; i<n; ++i)
		h[i] = u[i+1] - u[i];
}  /* end Paramaterize */

static PeriodicSpline(h, z, dz, d2z, d3z, npoints)
float h[MAXPOINTS], z[MAXPOINTS];	/* Point list and paramaterization  */
float dz[MAXPOINTS];			/* to return the 1st derivative */
float d2z[MAXPOINTS], d3z[MAXPOINTS];	/* 2nd and 3rd derivatives */
int npoints;				/* number of valid points */
/*
 *     This routine solves for the cubic polynomial to fit a spline
 * curve to the the points  specified by the list of values.
 * The Curve generated is periodic.  The alogrithms for this 
 * curve are from the "Spline Curve Techniques" paper cited below.
 */

{
	float d[MAXPOINTS]; 
	float deltaz[MAXPOINTS], a[MAXPOINTS], b[MAXPOINTS];
	float c[MAXPOINTS], r[MAXPOINTS], s[MAXPOINTS];
	int i;

	            /* step 1 */
	for (i=1; i<npoints; ++i)
	{
		if (h[i] != 0)
			deltaz[i] = (z[i+1] - z[i]) / h[i];
		else
			deltaz[i] = 0;
	}
	h[0] = h[npoints-1];
	deltaz[0] = deltaz[npoints-1];

	            /* step 2 */
	for (i=1; i<npoints-1; ++i)
	{
		d[i] = deltaz[i+1] - deltaz[i];
	}
	d[0] = deltaz[1] - deltaz[0];

	            /* step 3a */
	a[1] = 2 * (h[0] + h[1]);
	if (a[1] == 0) return(-1);  /* 3 consecutive knots at same point */
	b[1] = d[0];
	c[1] = h[0];
	for (i=2; i<npoints-1; ++i)
	{
		a[i] = 2 * (h[i-1] + h[i]) - pow((double) h[i-1], (double) 2.0)
		            / a[i-1];
		if (a[i] == 0) return(-1);  /* 3 consec knots at same point */
		b[i] = d[i-1] - h[i-1] * b[i-1]/a[i-1];
		c[i] = -h[i-1] * c[i-1]/a[i-1];
	}

	            /* step 3b */
	r[npoints-1] = 1;
	s[npoints-1] = 0;
	for (i=npoints-2; i>0; --i)
	{
		r[i] = -(h[i] * r[i+1] + c[i])/a[i];
		s[i] = (6 * b[i] - h[i] * s[i+1])/a[i];
	}

	            /* step 4 */
	d2z[npoints-1] = (6 * d[npoints-2] - h[0] * s[1] 
	                   - h[npoints-1] * s[npoints-2]) 
	                 / (h[0] * r[1] + h[npoints-1] * r[npoints-2] 
	                    + 2 * (h[npoints-2] + h[0]));
	for (i=1; i<npoints-1; ++i)
	{
		d2z[i] = r[i] * d2z[npoints-1] + s[i];
	}
	d2z[npoints] = d2z[1];

	            /* step 5 */
	for (i=1; i<npoints; ++i)
	{
		dz[i] = deltaz[i] - h[i] * (2 * d2z[i] + d2z[i+1])/6;
		if (h[i] != 0)
			d3z[i] = (d2z[i+1] - d2z[i])/h[i];
		else
			d3z[i] = 0;
	}
	return(0);
}  /* end PeriodicSpline */


static NaturalEndSpline(h, z, dz, d2z, d3z, npoints)
float h[MAXPOINTS], z[MAXPOINTS];	/* Point list and parameterization */
float dz[MAXPOINTS];			/* to return the 1st derivative */
float d2z[MAXPOINTS], d3z[MAXPOINTS];	/* 2nd and 3rd derivatives */
int npoints;				/* number of valid points */
/*
 *     This routine solves for the cubic polynomial to fit a spline
 * curve the the points  specified by the list of values.  The alogrithms for
 * this curve are from the "Spline Curve Techniques" paper cited below.
 */

{
	float d[MAXPOINTS];
	float deltaz[MAXPOINTS], a[MAXPOINTS], b[MAXPOINTS];
	int i;

	            /* step 1 */
	for (i=1; i<npoints; ++i)
	{
		if (h[i] != 0)
			deltaz[i] = (z[i+1] - z[i]) / h[i];
		else
			deltaz[i] = 0;
	}
	deltaz[0] = deltaz[npoints-1];

	            /* step 2 */
	for (i=1; i<npoints-1; ++i)
	{
		d[i] = deltaz[i+1] - deltaz[i];
	}
	d[0] = deltaz[1] - deltaz[0];

	            /* step 3 */
	a[0] = 2 * (h[2] + h[1]);
	if (a[0] == 0) return(-1);  /* 3 consec knots at same point */
	b[0] = d[1];
	for (i=1; i<npoints-2; ++i)
	{
		a[i] = 2 * (h[i+1] + h[i+2]) - pow((double) h[i+1],(double) 2.0)
		             / a[i-1];
		if (a[i] == 0) return(-1);  /* 3 consec knots at same point */
		b[i] = d[i+1] - h[i+1] * b[i-1]/a[i-1];
	}

	            /* step 4 */
	d2z[npoints] = d2z[1] = 0;
	for (i=npoints-1; i>1; --i)
	{
		d2z[i] = (6 * b[i-2] - h[i] *d2z[i+1])/a[i-2];
	}

	            /* step 5 */
	for (i=1; i<npoints; ++i)
	{
		dz[i] = deltaz[i] - h[i] * (2 * d2z[i] + d2z[i+1])/6;
		if (h[i] != 0)
			d3z[i] = (d2z[i+1] - d2z[i])/h[i];
		else
			d3z[i] = 0;
	}
	return(0);
}  /* end NaturalEndSpline */


#define PointsPerInterval 16

GRCurve(pointlist,style)
POINT *pointlist;
int   style;
/*
 *    This routine generates a smooth curve through a set of points.  The 
 * method used is the parametric spline curve on unit knot mesh described
 * in "Spline Curve Techniques" by Patrick Baudelaire, Robert Flegal, and 
 * Robert Sproull -- Xerox Parc.
 */
{
	float h[MAXPOINTS];
	float x[MAXPOINTS], y[MAXPOINTS], dx[MAXPOINTS], dy[MAXPOINTS];
	float d2x[MAXPOINTS], d2y[MAXPOINTS], d3x[MAXPOINTS], d3y[MAXPOINTS];
	float t, t2, t3, xinter, yinter;
	POINT *ptr;
	int numpoints, i, j, k, stat, count, brushsize;

              /* Copy point list to array for easier access */

	ptr = pointlist;
	for (i=1; (!Nullpoint(ptr)); ++i)
	{
		x[i] = ptr->x;
		y[i] = ptr->y;
		if (i >= MAXPOINTS - 1) break;
		ptr = PTNextPoint(ptr);
	}

	     /* Solve for derivatives of the curve at each point 
              * separately for x and y (parametric).
	      */
	numpoints = i - 1;
	Paramaterize(x, y, h, numpoints);
  	stat = 0;
	if ((x[1] == x[numpoints]) && (y[1] == y[numpoints]))/* closed curve */
	{
		stat |= PeriodicSpline(h, x, dx, d2x, d3x, numpoints);
		stat |= PeriodicSpline(h, y, dy, d2y, d3y, numpoints);
	}
	else
	{
		stat |= NaturalEndSpline(h, x, dx, d2x, d3x, numpoints);
		stat |= NaturalEndSpline(h, y, dy, d2y, d3y, numpoints);
	}
	if (stat != 0) return(-1);  /* error occurred */
	     
	      /* generate the curve using the above information and 
	       * PointsPerInterval vectors between each specified knot.
	       */

	count = 0;
	for (j=1; j<numpoints; ++j)
	{
		for (k=0; k<=PointsPerInterval; ++k)
		{
			t = (float) k * h[j] / (float) PointsPerInterval;
			t2 = t * t;
			t3 = t * t * t;
			xinter = x[j] + t * dx[j] + t2 * d2x[j]/2.0
			       + t3 * d3x[j]/6.0;
			yinter = y[j] + t * dy[j] + t2 * d2y[j]/2.0
			       + t3 * d3y[j]/6.0;
			if(count>=1300)
			{
				error("Curve: too many vectors.");
				return;
			}
			vlist[count].x = xinter;
			vlist[count].y = yinter;
			vlist[count++].flags = 0;
		}  /* end for k */
	}  /* end for j */
	switch(style)
	{
		case 3:
		case -4:
			brushsize = 3;
			break;
		case 6:
		case -7:
			brushsize = 2;
			break;
		default:
			brushsize = 1;
	}
	if(style<0)
		XDraw(FrameList[PAGE_WIN].self,vlist,count,brushsize,brushsize,WhitePixel,GXcopy,AllPlanes);
	else
	{
		if(halftone) style +=NBRUSHES;
			XDrawPatterned(FrameList[PAGE_WIN].self,vlist,count,brushsize,brushsize,BlackPixel,WhitePixel,brush[style],GXcopyInverted,AllPlanes);
	}
	return(0);
}  /* end GRCurve */


GREraseText(justify,point1,font,size,string,pos)
int justify, font, size;
POINT *point1, *pos;
char string[];
{
	PutText(justify,point1,font,size,string,pos,1);
}

GRPutText(justify,point1,font,size,string,pos)
int justify, font, size;
POINT *point1, *pos;
char string[];
{
	PutText(justify,point1,font,size,string,pos,0);
}

/*
 *  this gets confusing with TextPut.
 */
PutText(justify,point1,font,size,string,pos,erase)
int justify, font, size,erase;
POINT *point1, *pos;
char string[];
{
	int length, nchars, i;

	if(font<0)
		font = -(++font);
	if(text_font[font][size]==NULL)
		text_font[font][size] = XOpenFont(text_font_names[font][size]);
	if(text_font[font][size]==NULL)
	{
		char mesg[50];

		sprintf(mesg,"Gremlin:  couldn't load font %s [%d][%d].",text_font_names[font][size],font,size);
		error(mesg);
		return;
	}

	nchars = strlen(string);
	length = XQueryWidth(string,text_font[font][size]->id);

    switch (justify)
	{
		  case BOTLEFT:	pos->x = point1->x;
				pos->y = point1->y - text_font[font][size]->height;
				break;
		  case BOTCENT:	pos->x = point1->x - (length/2);
				pos->y = point1->y - text_font[font][size]->height;
				break;
		 case BOTRIGHT:	pos->x = point1->x - length;
				pos->y = point1->y - text_font[font][size]->height;
				break;
		 case CENTLEFT:	pos->x = point1->x;
				pos->y = point1->y - (text_font[font][size]->height/2);
				break;
		 case CENTCENT:	pos->x = point1->x - (length/2);
				pos->y = point1->y - (text_font[font][size]->height/2);
				break;
		case CENTRIGHT:	pos->x = point1->x - length;
				pos->y = point1->y - (text_font[font][size]->height/2);
				break;
		  case TOPLEFT:	pos->x = point1->x;
				pos->y = point1->y;
				break;
		  case TOPCENT:	pos->x = point1->x - (length/2);
				pos->y = point1->y;
				break;
		 case TOPRIGHT:	pos->x = point1->x - length;
				pos->y = point1->y;
				break;
	}
	if (( pos->y + charysize ) > GrYMax )
		pos->y = GrYMax - charysize;
	if (pos->y < 0) pos->y = 0;

	if(halftone)
		XTextPad(FrameList[PAGE_WIN].self,(int)pos->x,(int)pos->y,string,strlen(string),text_font[font][size]->id,0,0,WhitePixel,BlackPixel,erase?GXcopyInverted:GXcopy,AllPlanes);
	else
		XTextPad(FrameList[PAGE_WIN].self,(int)pos->x,(int)pos->y,string,strlen(string),text_font[font][size]->id,0,0,BlackPixel,WhitePixel,erase?GXorInverted:GXand,AllPlanes);

} /* end PutText */;


GRClear(mask)
int mask;
{
	XClear(FrameList[PAGE_WIN].self);
}

GRDisplayPoint(x, y, number, mark)
int x, y, number, mark;
/*
 *      This routine displays a point on the screen.  The point is
 * displayed as a '+' centered about the point (x,y) and followed by
 * number.
 */

{
	POINT p1, p2;
	int psize;
	char	asc[4];
	
	if (artmode) psize = 1;
	else psize = 4;
	/* GRsetwmask(pointmask); */
	p1.y = p2.y = y;
	p1.x = x - psize;
	p2.x = x + psize +1;
	GRVector(&p1, &p2, mark);
	p1.x = p2.x = x;
	p1.y = y - psize;
	p2.y = y + psize +1;
	GRVector(&p1, &p2, mark);
	if ( !artmode )
	{
		sprintf(asc,"%d",number);
		XTextPad(FrameList[PAGE_WIN].self,x+3,y+3,asc,strlen(asc),pointfont,0,0,BlackPixel,WhitePixel,mark<1?GXorInverted:GXand,AllPlanes);
	}
}  /* end DisplayPoint */

GRErasePoint(x, y, number)
int x, y, number;
/*
 *      This routine erases the specified point by redrawing it in the
 * background color
 */

{
	GRDisplayPoint(x, y, number, -3);
}  /* end ErasePoint */

GRBlankPoints()
{
	POINT *plist;
	int	count;

	plist = POINTLIST;
	count = 0;
	while(!Nullpoint(plist))
	{
		GRErasePoint((int)plist->x,(int)plist->y,count++);
		plist = PTNextPoint(plist);
	}
}  /* end BlankPoints */

GRShowPoints()
{
	POINT *plist;
	int	count;

	plist = POINTLIST;
	count = 0;
	while(!Nullpoint(plist))
	{
		GRDisplayPoint((int)plist->x,(int)plist->y,count++,pointstyle);
		plist = PTNextPoint(plist);
	}
}

/*
 *  Undocumented feature.  Draws filled polygons.  Can't get tiled polygons,
 *  it crashes Qvss.  It's hooked up to button 2 of the vector icon.  I
 *  doubt that it works properly now.
 */
GRPolygon(pointlist,style)
POINT *pointlist;
int style;
{
	int count = 0;
	POINT *ptr;

	ptr = pointlist;
	while(!Nullpoint(ptr))
	{
		vlist[count].x = ptr->x;
		vlist[count].y = ptr->y;
		vlist[count++].flags = 0;
		ptr = PTNextPoint(ptr);
	}
	vlist[0].flags = VertexStartClosed;
	vlist[count].x = vlist[0].x;
	vlist[count].y = vlist[0].y;
	vlist[count++].flags = VertexEndClosed;

	XDrawFilled(FrameList[PAGE_WIN].self,vlist,count,style==-1?WhitePixel:BlackPixel,GXcopy,AllPlanes);
}

