.TH XTERM 1 "1 January 1985" "X Version 10"
.SH NAME
xterm - X window system terminal emulator
.SH SYNOPSIS
.B xterm
[ option ] ...
.SH DESCRIPTION
.I Xterm
is the
.I X
window system terminal emulator.
It attempts to emulate a DEC VT102 terminal (not yet completely implemented)
to provide a standard terminal type for programs not aware of the window
system directly.
Under 4.3BSD and Ultrix 1.2,
.I xterm
supports the terminal resizing facilities built into the system.
.PP
When started,
.I xterm
pops a small window onto the upper left corner,
with the size in characters and rows of the window as you size it.
Once the window is created, a pseudo terminal is allocated and a shell
is started on the slave side of the pty pair.
.PP
.I Xterm
understands the following options:
.TP 8
.B \-j
.I Xterm
will `jump scroll'; when
.I xterm
falls behind scrolling
the screen, it will move multiple lines up at once.
This option is disabled by Tektronix mode.
The VT100 escape sequences for smooth scroll can be used to enable/disable
this feature from a program,
or the `Mode Menu' can be used to set it interactively.
.TP 8
.B \-fn \fIfont\fP
The specified
.I font
will be used instead of the default font (which is vtsingle).
Any fixed width font may be used.
.PP
.TP 8
.B \-fb \fIfont\fP
The specified
.I font
will be used instead of the default bold font (which is vtbold).
This font must be the same height and width as the normal font.
.PP
.TP 8
.B =\fIgeometry\fP
\fIXterm\fP will take a normal X geometry specification.
This takes the form of ``=\fIwidth\fPx\fIheight\fP+\fIxoff\fP+\fIyoff\fP''.
See \fIX(1)\fP for details of this specification.
.PP
.TP 8
.B \fIhost\fP:\fIdisplay\fP
Normally,
.I xterm
gets the host and display number to use from the environment
variable ``DISPLAY''.  One can, however specify them explicitly.
The
.I host
specifies which machine to create the window on, and
the
.I display
argument specifies the display number.
For example,
``orpheus:1'' creates a shell window on display one on the machine
orpheus.
.PP
.TP 8
.B \-n \fIwindowname\fP
Allows you to set the name of the window for use by a window manager.
.PP
.TP 8
.B \-bw \fIborderwidth\fP
Allows you to specify the width of the window border in pixels.
.TP 8
.B \-b \fIborder\fP
.I Xterm
maintains an inner border (distance between characters and the window's
border) of one pixel.  The \fB-b\fP option allows you to set the size of this
border to 
.I border.
.PP
.TP 8
.B \-rv
The screen will be displayed with white characters on a black background,
rather than the default black on white.
.PP
.TP 8
.B \-fg \fIcolor\fP
On color displays, determines the color of the text.
.PP
.TP 8
.B \-bg \fIcolor\fP
On color displays, determines the color of the background.
.PP
.TP 8
.B \-bd \fIcolor\fP
On color displays, determines the color of the border.
.PP
.TP 8
.B \-cr \fIcolor\fP
On color displays, determines the color of the text cursor; default is the
text color.
.PP
.TP 8
.B \-ms \fIcolor\fP
On color displays, determines the color of the mouse cursor; default is the
text cursor color.
.PP
.TP 8
.B \-i
asks
.I xterm
to maintain a bitmap icon, rather than relying on a window manager for
an icon (see \fIxwm(1)\fP).
.PP
.TP 8
.B \-t
selects
.I Tektronix 4010
emulation in addition to normal vt102 emulation.  In this mode, the
default font is 6x10 and the default window size is 39x85.  If a key is
hit during Tektronix graphics output, the display may become garbled
(just like a real Tektronix).  The default screen size using the default
font is one-fourth the resolution of a Tektronix 4010; therefore, some
graphics may have discontinuities or may be suppressed entirely.
Furthermore, the font initially selected approximately represents the
standard Tektronix font, at best.  If the window is subsequently enlarged
or reduced, the font appears to shrink or grow, respectively.  Resizing
the window also affects resolution, and if the aspect ratio
(height/width) is altered,  Tektronix graphics will be restricted to the
largest box with a 4010's aspect ratio that will fit in the window.
This box is located in the upper left area of the window.  Text which
is part of Tektronix graphics output may not be cut (see MOUSE USAGE).
.PP
.TP 8
.B \-e command arguments
The specified 
.I command
will be executed in the window, rather than
starting a shell.
The command and and optional arguments must appear last on the xterm command
line.
.PP
.TP 8
.B \-s
When this option is specified, xterm no longer scrolls synchronously
with the display.
\fIXterm\fP no longer attempts to keep the screen completely up to date while
scrolling, but can then run faster when network latencies are very high.
This is typically useful when using \fIxterm\fP across a very large internet
or many hops.
.PP
.TP 8
.B \-L
indicates that
.I xterm
is being called by \fIinit(8)\fP, and should presume that its file descriptors
are already open on a slave pseudo-tty, and that \fIgetty\fP should be
run rather than the user's shell.  This option should only be used by \fIinit\fP.
.SH "MOUSE USAGE"
When using the mouse to create the window, a cursor and
a rubber banding box will outline where the window will be created on
the display.
If the left button is pressed, a HEIGHTxWIDTH (default 24x80)
size window will be created.
If the right button is pressed, a window the height of the display and
WIDTH (default 80) characters wide will be created.
If the center button is pressed and held down, the upper left hand
corner of the window will be set to that point on the display, and
(while continuing to depress the center button) an outline of the window
will be displayed and the pop up window in the upper left corner of the
screen will display the size in characters of the window.
.PP
Once the window is created,
.I xterm
allows you to save text and restore it within the same or other windows.
The button functions are enabled when holding down the ``shift'' key.
The left hand button takes the text from the cursor (at button release)
through the end of line (including the new line), saves it in the global cut
buffer, and immediately `retypes' the line, inserting it as keyboard input.
This provides a history mechanism.
The center button is used to save text into the cut buffer.
Move the cursor to beginning of the text,
and then hold the button down while moving the cursor to the end of the region
and releasing the button.  The saved text will not include the character
pointed by the mouse.  Furthermore, it is not possible to cut text which
was part of Tektronix graphics output.
The right hand button `types' the text from the cut buffer, inserting it
as keyboard input.
By cutting and pasting pieces of text without trailing new lines,
you can take text from several places in different windows and form a command
to the shell, for example, or take output from a program and insert it into
your favorite editor.
Since the cut buffer is globally shared among different applications,
you should regard it as a `file' whose contents you know.
The terminal emulator and other text programs should be treating it as if it
were a text file, i.e. the text is delimited by new lines.
.SH X DEFAULTS
.PP
.I Xterm
allows you to preset defaults in a customization file in your home
directory, called \fI.Xdefaults\fP.
The format of the file is ``programname.keyword:string''.
See \fIX(1)\fP for more details.
.I Xterm
obeys the convention for `MakeWindow' defaults.
Keywords recognized by
.I xterm
are listed below.
.PP
.TP 8
.B JumpScroll
If ``on'' jump scroll is enabled.
.PP
.TP 8
.B BodyFont
Set the default font.
.PP
.TP 8
.B InternalBorder
Set the space between the text and window border.
This is called padding above.
.PP
.TP 8
.B BorderWidth
Set the border width of the window.
.PP
.TP 8
.B ReverseVideo
If `on', reverse the definition of foreground and background color.
.PP
.TP 8
.B Foreground
Set the text color.
.PP
.TP 8
.B Background
Set the background color.
.PP
.TP 8
.B Border
Set the border color.
.PP
.TP 8
.B Cursor
Set the text cursor color.
.PP
.TP 8
.B Mouse
Set the mouse cursor color.
.PP
.TP 8
.B BitmapIcon
If `on', use a bitmap icon for this window.
.PP
.TP 8
.B BoldFont
Specify a default bold font.
.SH "MODE MENU"
.I Xterm
has a menu for changing the modes of the terminal.
The appearance of the menu is controlled by the defaults defined
in the \fIXMenu(3x)\fP manual page.
If you hold the ``control'' key down and press the middle mouse button,
a pop-up menu appears.
When you let up on the mouse button, the operation will be invoked.
You can set the following modes of the emulator:
``Smooth Scroll'' vs. ``Jump Scroll'',
``Reverse Video'' vs. ``Normal Video'',
``no wrap'' vs. ``auto wrap'',
``auto linefeed'' vs. ``normal linefeed'',
``application cursors'' vs. ``normal cursors'',
``application pad'' vs. ``numeric pad'',
and you can either ``soft reset'' or ``hard reset'' the emulator.
.PP
The scroll entry lets you control the scrolling behavior of the 
emulator as defined above.
The video entry lets you change from normal to reverse video and back.
The wrap entry lets you change to wrap at end of line or truncate at end
of line.
The linefeed entry lets you determine whether the emulator should
provide a linefeed when the line wraps.
The cursors entry lets you determine which escape sequences are generated
by the cursor keys.
The pad entry lets you determine if  the numeric keypad should generate
escape sequences or if it should generate numbers.
The soft reset entry will reset scroll regions.
This can be convenient when some program has left the scroll regions
set incorrectly (often a problem when using VMS or TOPS-20).
The full reset entry will clear the screen, reset tabs to every
eight columns, and reset the terminal modes to wrap and smooth scroll.
.SH ENVIRONMENT
.I Xterm
sets the environment variables ``TERM'' and ``TERMCAP'' properly for the
size window you have created.  It also uses and sets the environment
variable ``DISPLAY'' to specify which bit map display terminal to use.
.SH "SEE ALSO"
resize(1), xwm(1), X(1), pty(4), XMenu(3x)
.SH DIAGNOSTICS
The
.B \-d
flag turns on reporting of not understood escape sequences.
.SH BUGS
Does not perfectly emulate a VT102 (though it is pretty close).
While the 4010 emulation is  as complete as we wish to make it,
the Tektronix 4014 emulation is incomplete.
Many applications will run.
The display list for the Tektronix emulator needs more work.
.SH AUTHORS
Mark Vandevoorde (MIT-Athena), Bob McNamara (DEC-MAD),
Jim Gettys (MIT-Athena), Bob Scheifler (MIT-LCS), Doug Mink (SAO),
Jordan Hubbard (Berkeley).
.sp
VMS and TOPS-20 are trademarks of Digital Equipment Corporation.
.sp
Copyright (c) 1984, 1985, 1986 by Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full copyright notice.
