.TH XIMPV 1 "30 August 1985" "X Version 10"
.SH NAME
ximpv \- Imprint (Impress) Previewer for the X Window System
.SH SYNOPSIS
.B ximpv
[=\fIgeometry\fP] [-p#] [-rv] [-fg \fIcolor\fP] [-bg \fIcolor\fP] [-bd \fIcolor\fP] [-ms \fIcolor\fP] [\fIhost\fP:\fIdisplay\fP] file
.SH DESCRIPTION
.I Ximpv
is a program which runs under the X window system. It
is used to preview images which is destined for an Imagen laser
printer.
.PP
The 
.I -p# 
option, if used, will set the number of pages you can back up to #. Default
is five pages. Zero (or no number) runs faster as the pages do not have to be 
transferred to disk.
.PP
If the 
.I file 
given to ximpv is correct a square will appear on the
screen indicating text is about to appear.
If no 
.I file 
is given stdin must be from a pipe or an error message is printed
and the program aborted.
.PP
The pages of the file are displayed in the order.
Only about 2/3 of a page can be displayed at once (this is because
of aspect ratio differences).
.SH ARGUMENTS
.PP
.TP 8
.B -bd \fIcolor\fP
Specify the border color.
.PP
.TP 8
.B -ms \fIcolor\fP
Specify the mouse color.
.PP
.TP 8
.B -fg \fIcolor\fP
Specify the foreground color.
.PP
.TP 8
.B -bg \fIcolor\fP
Specify the background color.
.PP
.TP 8
.B -bw \fIwidth\fP
Specify the width of the border.
.PP
.TP 8
.B -rv
Cause \fIximpv\fP
to produce all output in black-on-white instead of white-on-black.
.PP
.TP 8
.B =\fIgeometry\fP
The previewer window is created with the specified
size specified by the geometry specification.
See \fIX(1)\fP for details of this specification.
.SH MOUSE
.PP
Clicking the right button will display the next window full, moving to the
next page as needed.  Clicking the middle button will move to the opposite
end of the current page.  Clicking the left button will
display the previous window full, moving to the previous page as needed.
.PP
Clicking the right button with the Shift key held down will display the next
window full to the right.
Clicking the middle button with the Shift key held down will move to the
opposite side of the current page.  Clicking the left button with the Shift
key held down will display the previous window full to the left.
.SH KEYBOARD
.PP
The user may move up and down the page
with the numeric pad keys:
.nf
.br
.ta 1.2i 1.8i 2.5i
	fine	medium	coarse
.br
up page	   7	   8	   9
.sp
down page	   1	   2	   3
.br
.fi
The numeric pad keys can also be used for horizontal motion:
.nf
.ne 3
.br
	left	center	right
.br
horizontal	   4	   5	   6
.fi
.br
.DT
.PP
You may also move forward or back in the document by using:
.br
.B -
for back a page,
.br
.B up-arrow
for back a window full,
.br
.B .
for forward a page,
.br
.B down-arrow
for forward a window full,
.br
.B ,
or
.B +
for forward to next new page.
.br
You may also move left and right in the document by small amounts using the
left and right arrow keys.
.br
The only other functional keys are the CNTRL
.B -D 
key and the CNTRL
.B -C
key, which exit the program.
.SH X DEFAULTS
.PP
Accepts the following defaults:
.PP
.TP 8
.B BorderWidth
Set the border width of the window.
.PP
.TP 8
.B ReverseVideo
If ``on'', reverse the definition of foreground and background color.
.PP
.TP 8
.B Foreground
Set the text/graphics color.
.PP
.TP 8
.B Background
Set the background color.
.PP
.TP 8
.B Border
Set the border color.
.PP
.TP 8
.B Mouse
Set the mouse cursor color.
.SH "SEE ALSO"
X(1), xproof(1), xdvi(1)
.SH ENVIRONMENT
Uses the environment variable ``DISPLAY'' to specify which bit map display
terminal to use.
.SH FILES
/usr/tmp/impvXXXXXX	circular buffer of screen images
.SH "SEE ALSO"
X(1).
.SH "AUTHOR"
Steven Sutphen and Ted Bentley, University of Alberta
Changes and enhancements for X by
Bob Scheifler, MIT Laboratory for Computer Science, and Jim Gettys,
DEC, Project Athena.
