.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH UWM 1 "27 January 1986" "X Version 10"
.SH NAME
.PP
uwm - Window Manager Client Application of X
.PP
.SH SYNTAX
.PP
\fBuwm \fP [-f \fIfilename\fP]
.PP
.SH DESCRIPTION
.PP
The \fIuwm\fP command is a window manager client 
application of the window 
server.
.PP
When the command is invoked, it traces a predefined search path
to locate any \fIuwm\fP startup files.  If no startup files
exist, \fIuwm\fP initializes its built-in default file.
.PP
If startup files exist in any of the following locations,
it adds the variables to the default variables.  
In the case of contention, the variables in the last file found
override previous specifications.  Files in the \fIuwm\fP
search path are:
.sp
  \fI/usr/new/lib/X/uwm/system.uwmrc
  $HOME/.uwmrc\fP
.PP
To use only the settings defined in a single startup file,
include the variables, \fBresetbindings\fP, \fBresetmenus\fP, 
\fBresetvariables\fP
at the top of that specific startup file.
.PP
.SH ARGUMENTS 
.IP "-f \fIfilename\fP"
Names an alternate file as a 
.I uwm 
startup file.
.PP
.SH STARTUP FILE VARIABLES
.PP
Variables are typically entered first, at the top of the startup
file.
By convention, \fBresetbindings\fP, \fBresetmenus\fP, and
\fBresetvariables\fP head the list.
.IP "\fBautoselect\fP/\fBnoautoselect\fP" 15
places menu cursor in first menu item.  If unspecified, menu
cursor is placed in the menu header when the menu is displayed.
.IP \fBdelta\fP=\fIpixels\fP
indicates the number of pixels the cursor is moved 
before the action is interpreted by the window manager as a command.
(Also refer to the \fBdelta\fP mouse action.)
.IP \fBfreeze\fP/\fBnofreeze\fP
locks all other client applications 
out of the server during certain window manager tasks, such as move 
and resize.
.IP \fBgrid\fP/\fBnogrid\fP
displays a finely-ruled grid to help 
you position an icon or window during resize or move operations.
.IP "\fBhiconpad\fP=\fIn\fP"
indicates the number of pixels to pad an icon horizontally.
The default is five pixels.
.IP "\fBhmenupad\fP=\fIn\fP"
indicates the amount of space in pixels, that each menu item is
padded above and below the text.
.IP "\fBiconfont\fP=\fIfontname\fP"
names the font that is displayed within icons.  
Font names are listed in the font directory, \fI/usr/new/lib/X/font\fP.
.IP "\fBmaxcolors\fP=\fIn\fP   "
limits the number of colors the window manager can use in a 
given invocation.  
If set to zero, or not specified,  
\fIuwm\fP assumes no limit to the number of colors it can take from 
the color map.  
\fBmaxcolors\fP counts colors as they are included in the file.
.IP "\fBnormali\fP/\fBnonormali\fP"
places icons created with \fBf.newiconify\fP within the root
window, even if it is placed partially off the screen.  With
\fBnonormali\fP the icon is placed exactly where the cursor leaves it.
.IP "\fBnormalw\fP/\fBnonormalw\fP" 
places window created with \fBf.newiconify\fP within the root
window, even if it is placed partially off the screen.  With
\fBnonormalw\fP the window is placed exactly where the cursor
leaves it. 
.IP \fBpush\fP=\fIn\fP
moves a window \fIn\fP number of pixels or a relative amount of
space, depending on whether \fBpushabsolute\fP or \fBpushrelative\fP 
is specified.
Use this variable in conjunction with \fBf.pushup,
f.pushdown, f.pushright\fP, or \fBf.pushleft\fP.
.IP \fBpushabsolute\fP/\fBpushrelative\fP
\fBpushabsolute\fP indicates that the number entered with push is
equivalent to pixels.
When an f.push (left, right, up, or down) function is called, 
the window is moved exactly that number of pixels.  
.IP
\fBpushrelative\fP indicates that the number entered with the push variable
represents a relative number.  When an f.push function is
called, the window is invisibly divided into the number 
of parts you entered with the push variable, and the window 
is moved one part.  
.IP "\fBresetbindings\fP, \fBresetmenus\fP, and \fBresetvariables\fP"
resets all previous function bindings, menus, and
variables entries, specified in any startup file in the
\fIuwm\fP search path, including those in the default environment.
By convention, these variables are entered first in the startup
file.
.IP \fBresizefont\fP=\fIfontname\fP
identifies the font of the indicator that displays in the 
corner of the window as you resize windows.
See the \fI/usr/new/lib/X/font\fP directory 
for a list of fonts.
.IP \fBreverse\fP/\fBnoreverse\fP
defines the display as black characters on a white
background for the window manager windows and icons.
.IP "\fBviconpad\fP=\fIn\fP"
indicates the number of pixels to pad an icon vertically.  
Default is five pixels.
.IP "\fBvmenupad\fP=\fIn\fP"
indicates the amount of space in pixels that the menu is
padded on the right and left of the text.
.IP \fBvolume\fP=\fIn\fP
increases or decreases 
the base level volume set by the 
\fIxset(1)\fP command.  Enter an integer from 
0 to 7, 7 being the loudest.
.IP \fBzap\fP/\fBnozap\fP
causes ghost lines to follow the window or icon from 
its previous default location to its new location during 
a move or resize operation.  
.PP
.SH BINDING SYNTAX
.PP
"\fIfunction\fP=[\fIcontrol key(s)\fP]:[\fIcontext\fP]:\fImouse events\fP:\fI" menu name "\fP
.PP
Function and mouse events are required input.  Menu name is
required with the \fIf.menu\fP function definition only.  
.PP
.SH Function
.IP "\fBf.beep\fP" 15
emits a beep from the keyboard.  Loudness is determined by 
the volume variable.
.IP \fBf.circledown\fP
causes the top window that is obscuring another 
window to drop to the bottom of the stack of windows.  
.IP \fBf.circleup\fP
exposes the lowest window that is obscured by other
windows. 
.IP \fBf.continue\fP
releases the window server display action after you 
stop action with the \fBf.pause\fP function.  
.IP \fBf.focus\fP
directs all keyboard input to the selected window.
To reset the focus to all windows, invoke \fIf.focus\fP from the root
window.
.IP \fBf.iconify\fP
when implemented from a window, this function converts the window 
to its respective icon.  When implemented from an icon, 
f.iconify converts the icon to its respective window.  
.IP \fBf.lower\fP
lowers a window that is obstructing a window below it.
.IP \fBf.menu\fP
invokes a menu.  Enclose `menu name' in quotes if it
contains blank characters or parentheses.  
.EX 0
.B
f.menu=[\fIcontrol key(s)\fP]:[\fIcontext \fP]:\fImouse events\fP:\fI" menu name "\fP
.EE
.IP \fBf.move\fP
moves a window or icon to a new location, which becomes the
default location.
.IP \fBf.moveopaque\fP
moves a window or icon to a new screen location.  When using this
function, the entire window or icon is moved to the new screen
location.  The grid effect is not used with this function.
.IP \fBf.newiconify\fP
allows you to create a window or icon and then position the window or
icon in a new default location on the screen.
.IP \fBf.pause\fP
temporarily stops all display action.  To release the screen and
immediately update all windows, use the \fBf.continue\fP function.
.IP \fBf.pushdown\fP
moves a window down.  
The distance of the push is determined by the push variables.
.IP \fBf.pushleft\fP
moves a window to the left.  
The distance of the push is determined by the push variables.
.IP \fBf.pushright\fP
moves a window to the right.  
The distance of the push is determined by the push variables.
.IP \fBf.pushup\fP
moves a window up.  
The distance of the push is determined by the push variables.
.IP \fBf.raise\fP
raises a window that is being obstructed by a window
above it.
.IP \fBf.refresh\fP
results in exposure events being sent to the window server clients 
for all unobscured or partially obscured windows.
The windows will not refresh correctly if the exposure events 
are not handled properly. 
.IP \fBf.resize\fP
resizes an existing window.  Note that some clients, notably
editors, react unpredictably if you resize the window while the
client is running.
.IP \fBf.restart\fPn
causes the window manager application to restart,
retracing the \fIuwm\fP search path and initializing the variables it
finds.
.PP
.SH Control Keys
.PP
By default, the window manager uses meta as its control
key. It can also use ctrl, shift, lock, or null (no control key).  
Control keys must be entered in lower case, and can be
abbreviated as: c, l, m, s  for ctrl, lock, meta, and shift,
respectively.
.PP
You can bind one, two, or no control keys to a function.  
Use the bar (|) character to combine control keys.
.PP
Note that client applications other than the window manager 
use the shift as a control key.  If you bind the shift key to a
window manager function, you can not use other client
applications that require this key.
.PP
.SH Context
.PP
The context refers to the screen location of the cursor when a 
command is initiated.  When you include a context entry in a 
binding, the
cursor must be in that context or the function will not be
activated.
The window manager recognizes the following four contexts: 
icon, window, root, (null).
.PP
The root context refers to the root, or background window,
A (null) context is indicated when the context field is left blank,
and allows a function to be invoked from any screen location.
Combine contexts using the bar (|) character.
.PP
.SH Mouse Buttons
.PP
Any of the following mouse buttons are accepted in 
lower case and can be abbreviated as l, m, or r, respectively:  left, 
middle, right.
.PP
With the specific button, you must identify 
the action of that button.  Mouse actions 
can be: 
.IP "\fBdown\fP" 10 
function occurs when the specified button is pressed down.
.IP \fBup\fP
function occurs when the specified button is released.
.IP "\fBdelta\fP" 10
indicates that the mouse must be moved the number of pixels specified 
with the delta variable before the specified function is invoked.
The mouse can be moved in any direction 
to satisfy the delta requirement.
.PP
.SH MENU DEFINITION 
.PP
After binding a set of function keys and a menu name to
\fBf.menu\fP, you must define the menu to be invoked, using the
following syntax:
.EX
.B
\fBmenu \fP= " \fImenu name\fP " {
"\fIitem name\fP" : "\fIaction\fP"
       . 
       .
       .
}
.EE
.PP
Enter the menu name exactly the way it is entered with the 
\fBf.menu\fP function or the window manager
will not recognize the link.  If the menu name contains blank
strings, tabs or parentheses, it must be quoted here and in the 
f.menu function entry.  
You can enter as many menu items as your screen is long.  You  
cannot scroll within menus.  
.PP
Any menu entry that contains quotes, special characters,
parentheses, tabs, or strings of blanks must be enclosed 
in double quotes.  Follow the item name by a colon (:).
.PP
.SH Menu Action
.IP "Window manager functions" 10
Any function previously described.  E.g., \fBf.move\fP or \fBf.iconify\fP.
.IP "Shell commands"
Begin with an exclamation point (!) and set to run in
background.  You cannot include a new line character within a shell
command. 
.IP "Text strings"
Text strings are placed in the window server's cut buffer.
.IP
Strings with a new line character must begin with an 
up arrow (^), which is stripped during the copy operation.  
.IP
Strings without a new line must begin with the bar character (|), 
which is stripped during the copy operation.  
.PP
.SH Color Menus
.PP
Use the following syntax to add color to menus:
.EX
.B
\fBmenu \fP= "\fImenu name\fP" (\fIcolor1:color2:color3:color4\fP) {
"\fIitem name\fP"  : (\fIcolor5 :color6\fP)  : "\fI action \fP"
       .             
       .
       .
}
.EE
.IP "color1" 10
Foreground color of the header.
.IP color2
Background color of the header.
.IP color3
Foreground color of the highlighter, the horizontal band
of color that moves with the cursor within the menu.
.IP color4
Background color of the highlighter.
.IP "color5" 10
Foreground color for the individual menu item.
.IP color6 
Background color for the individual menu item.
.PP
.SH Color Defaults
.PP
Colors default to the colors of the root window 
under any of the following conditions:
.sp
1)  If you run out of color map entries, either before or during an
invocation of \fIuwm\fP.
.sp
2)  If you specify a foreground or background color that does 
not exist in the RGB color database (\fI/usr/lib/rgb.txt\fP) both 
the foreground and background colors default to the root window colors.
.sp
3)  If you omit a foreground or background color, 
both the foreground and background colors default to the root 
window colors.
.sp
4)  If the total number of colors specified in the startup file
exceeds the number specified in the \fImaxcolors\fP variable.
.sp
5)  If you specify no colors in the startup file.
.PP
.bp
.SH EXAMPLES
.PP
The following sample startup file shows the default window
manager options:
.EX
# Global variables
#
resetbindings;resetvariables;resetmenus
autoselect
delta=25
freeze
grid
hiconpad=5
hmenupad=6
iconfont=oldeng
menufont=timrom12b
resizefont=9x15
viconpad=5
vmenupad=3
volume=7
#
# Mouse button/key maps
#
# FUNCTION    KEYS  CONTEXT  BUTTON    MENU(if any)
# ========    ====  =======  ======    ============
f.menu =      meta  :     :left down   :"WINDOW OPS"
f.menu =      meta  :     :middle down :"EXTENDED WINDOW OPS"
f.move =      meta  :w|i  :right down
f.circleup =  meta  :root :right down
#
# Menu specifications
#
menu = "WINDOW OPS" {
"(De)Iconify":	f.iconify
Move:		f.move
Resize:		f.resize
Lower:		f.lower
Raise:		f.raise
}

menu = "EXTENDED WINDOW OPS" {
Create Window:			!"xterm &"
Iconify at New Position:	f.lowericonify
Focus Keyboard on Window:	f.focus
Freeze All Windows:		f.pause
Unfreeze All Windows:		f.continue
Circulate Windows Up:		f.circleup
Circulate Windows Down:		f.circledown
}
.EE
.PP
.SH RESTRICTIONS
.PP
The color specifications have no effect on a monochrome system.
.PP
.SH FILES
.PP
 /usr/lib/rgb.txt 
 /usr/new/lib/X/font 
 /usr/skel/.uwmrc
 /usr/new/lib/X/uwm/system.uwmrc
 $HOME/.uwmrc
.PP 
.SH SEE ALSO
.PP
X(1), X(8C)
.SH AUTHOR
.PP
.ce 3
Copyright(c) 1986 by
Digital Equipment Corporation, Maynard, MA.
All Rights Reserved.
.PP
Permission to use, copy, modify, and distribute this software
and its documentation is hereby granted only to licensees of
The Regents of the University of California pursuant to their
license agreement for the Berkeley Software Distribution
provided that the following appears on all copies.
.sp
.ce 5
``LICENSED FROM DIGITAL EQUIPMENT CORPORATION
COPYRIGHT (C) 1986
DIGITAL EQUIPMENT CORPORATION
MAYNARD, MA
ALL RIGHTS RESERVED.
.sp
THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT
NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL
EQUIPMENT CORPORATION.  DIGITAL MAKES NO REPRESENTATIONS
ABOUT SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS
SUPPLIED ``AS IS'' WITHOUT EXPRESS OR IMPLIED WARRANTY.
IF THE UNIVERSITY OF CALIFORNIA OR ITS LICENSEES MODIFY
THE SOFTWARE IN A MANNER CREATING DERIVATIVE COPYRIGHT
RIGHTS APPROPRIATE COPYRIGHT LEGENDS MAY BE PLACED ON THE
DERIVATIVE WORK IN ADDITION TO THAT SET FORTH ABOVE.''
.PP
M. Gancarz,
DEC Ultrix Engineering Group, Merrimack, New Hampshire, using some algorithms
originally by Bob Scheifler, MIT Laboratory for Computer Science

