/*
 * Copyright (c) 1992 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Sony Corp. and Kazumasa Utashiro of Software Research Associates, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * from: $Hdr: scu.h,v 4.300 91/07/02 16:38:38 root Rel41 $ SONY
 *
 *	@(#)scu.h	7.1 (Berkeley) 6/4/92
 */

/*
 * screg.h
 */

#ifndef __SCU__
#define __SCU__ 1

#ifdef KERNEL
#include "ioctl.h"
#else
#include <sys/ioctl.h>
#endif

#define	RAWSCSI_USE_PIO		0
#define	RAWSCSI_USE_DMA		1

#define	SCSIIOCCMD		_IOWR('S', 0, struct sc_ureq)
#define	SCSIIOCGTIMEO		_IOR('S', 1, int)
#define	SCSIIOCSTIMEO		_IOW('S', 2, int)

/*
 *	scsi user request parameter block
 */
struct sc_ureq {
/*00*/	u_int	scu_istatus;
/*04*/	u_int	scu_tstatus;
/*08*/	u_int	scu_identify;
/*0c*/	u_int	scu_message;
/*10*/	u_int	scu_bytesec;
/*14*/	u_char	scu_cdb[12];
/*20*/	u_char	scu_param[20];
/*34*/	u_char	*scu_addr;
/*38*/	u_int	scu_count;
/*3c*/
};

#endif /* !__SCU__ */
