/*	@(#)test5a.c	1.2 89/01/10 NFS Rev 2 Testsuite	*/
/*
 * Test write - DOES NOT VERIFY WRITE CONTENTS
 *
 * Uses the following important system calls against the server:
 *
 *	chdir()
 *	mkdir()		(for initial directory creation if not -m)
 *	creat()
 *	write()
 *	stat()
 *	fstat()
 */

#include "tests.h"

#define	BUFSZ	8192
#define	DSIZE	1048576L

int Tflag = 0;		/* print timing */
int Hflag = 0;		/* print help message */
int Fflag = 0;		/* test function only;  set count to 1, negate -t */
int Nflag = 0;		/* Suppress directory operations */

void usage(void);

void
usage()
{
	fprintf(stdout, "usage: %s [-htfn] [size count fname]\n", Myname);
	fprintf(stdout, "  Flags:  h    Help - print this usage info\n");
	fprintf(stdout, "          t    Print execution time statistics\n");
	fprintf(stdout, "          f    Test function only (negate -t)\n");
	fprintf(stdout, "          n    Suppress test directory create operations\n");
}

void main(int argc,char *argv[]);

void
main(argc, argv)
	int argc;
	char *argv[];
{
	int count = DCOUNT;	/* times to do each file */
	int ct;
	long size = DSIZE;
	long si;
	long i;
	int fd;
	int bytes;
	char *bigfile = "bigfile";
	struct timeval time;
	struct stat statb;
	char *opts;
	char buf[BUFSZ];

	umask(0);
	setbuf(stdout, NULL);
	Myname = *argv++;
	argc--;
	while (argc && **argv == '-') {
		for (opts = &argv[0][1]; *opts; opts++) {
			switch (*opts) {
				case 'h':	/* help */
					usage();
					exit(1);

				case 't':	/* time */
					Tflag++;
					break;
				
				case 'f':	/* funtionality */
					Fflag++;
					break;
				
				case 'n':	/* No Test Directory create */
					Nflag++;
					break;

				default:
					error("unknown option '%c'", *opts);
					usage();
					exit(1);
			}
		}
		argc--;
		argv++;
	}

	if (argc) {
                size = getparm(*argv, 1L, "size");
		argv++;
		argc--;
	}
	if (argc) {
                count = (int) getparm(*argv, 1L, "count");
		argv++;
		argc--;
	}
	if (argc) {
                bigfile = *argv;
		argv++;
		argc--;
	}
	if (argc) {
		usage();
		exit(1);
	}
	
	if (Fflag) {
		Tflag = 0;
		count = 1;
	}

	fprintf(stdout, "%s: write\n", Myname);

	if (!Nflag)
		testdir(NULL);
	else
		mtestdir(NULL);

	/* Set up contents, however we won't verify. */
	for (i=0; i < BUFSZ / sizeof(long); i++) {
		((long *)buf)[i] = i;
	}

	if (Tflag) {
		starttime();
	}

	for (ct = 0; ct < count; ct++) {
		if ((fd = creat(bigfile, CHMOD_YES)) < 0) {
			error("can't create '%s'", bigfile);
			exit(1);
		}
		if (fstat(fd, &statb) < 0) {
			error("can't stat '%s'", bigfile);
			exit(1);
		}
		if (statb.st_size != 0) {
			error("'%s' has size %ld, should be 0",
			    bigfile, statb.st_size);
			exit(1);
		}
                for (si = size; si > 0; si -= BUFSZ) {
			bytes = (int) MIN((long) BUFSZ, si);
			if (write(fd, buf, bytes) != bytes) {
				error("'%s' write failed", bigfile);
				exit(1);
			}
		}
		close(fd);
		if (stat(bigfile, &statb) < 0) {
			error("can't stat '%s'", bigfile);
			exit(1);
		}
		if (statb.st_size != size) {
			error("'%s' has size %ld, should be %ld",
			    bigfile, statb.st_size, size);
			exit(1);
		}
	}

	if (Tflag) {
		endtime(&time);
	}

	fprintf(stdout, "\twrote %ld byte file %d times", size, count);
	if (Tflag) {
		printtimes(&time, size * (long) count);
	}
	fprintf(stdout, "\n");

	complete();
}
