/*
	Routines for LightspeedC

	(C) Copyright 1985, 1986. THINK Technologies, Inc.  All rights reserved.
*/
 
#ifndef _stdioh_
#include "stdio.h"
#endif

#ifndef _FileMgr_
#include "FileMgr.h"
#endif

#ifndef	_SerialDvr_
#include "SerialDvr.h"
#endif

void _exit_closeall();

/*	This file contains the code for fopen, fclose, _closeall, freopen.	*/

#line 0 xfopen
static FILE	*unix_xfopen(nameptr,type,who)
char	*nameptr;
register char	*type;
register FILE	*who;

{
register int		new;
static	Boolean		_init_onexit = false;	/* flag to signal onexit was initalized */

	ioParam	pb;			/* my parameter block for PB's	*/
	fileParam pb2;
	register int err;
	int	refnum;
	Boolean	create;
	Boolean	add;
	register Boolean	delete;
	register Boolean bin_file;
	register Ptr	p;

	if(!who)
		{
		register int		free_slot;
		/* look thru FILE array for an open slot	*/
		for (free_slot=STDERRNO+1;
			((free_slot<_NFILE)&&(_file[free_slot].InUse));
			free_slot++)
			;

		if (free_slot >= _NFILE) {
			errno = tmfoErr;	/* too many files open	*/
			return (NULL);
		}

		who = &_file[free_slot];
	}

{
	register int		permission;

	permission = fsWrPerm;		/* default = write	*/
	create = delete = true;		/* default is true	*/
	bin_file = add = false;
	refnum = 0;

	if (type[1]=='\0')
	{
		if (type[0] == 'r') permission = fsRdPerm;
	}
	else
		if (type[1] == '+')
		{
			permission = fsRdWrPerm;
			if (type[2] == 'b') bin_file = true;
		}
		else
		{
			if (type[1] == 'b') bin_file = true;
		
			if (type[0] == 'r') permission = fsRdPerm;
			
		}

/* force these files to be binary */
bin_file = true;	

	switch (type[0])
	{
		case 'r':
					create = false;
					break;
		case 'w':
					delete = true;
					break;
		case 'a':
					add = true;
					break;
		default:
					return(NULL);
	}


	CtoPstr(nameptr);

	p = NewPtr((long)BUFSIZ);

	do	{
	
		/* pdg 7/29/86 - look only via default path */

		pb.ioNamePtr	= 0;
/*		if (PBGetVol(&pb, false)) */ pb.ioVRefNum	= 0;


		pb.ioNamePtr	= (StringPtr)nameptr;
		pb.ioVersNum	= 0;
		pb.ioPermssn	= permission;
		pb.ioMisc		= 0L;

		new = PBOpen(&pb,false);
		
		if ((new == fnfErr) && (create))
			{
			if (err = (PBCreate(&pb,false))) goto err_exit;

			pb2.ioFDirIndex = 0;
			pb2.ioNamePtr	= pb.ioNamePtr;
			pb2.ioVRefNum	= pb.ioVRefNum;
			pb2.ioFVersNum	= pb.ioVersNum;
			if (err = (PBGetFInfo(&pb2,false))) goto err_exit;

			pb2.ioFlFndrInfo.fdType		= 'TEXT';
			pb2.ioFlFndrInfo.fdCreator	= '????';
			if (err = (PBSetFInfo(&pb2,false))) goto err_exit;

			delete = false;	/* don't delete this file	*/
		}

		if (!new)
		{	/* no errors on open  */
			if (pb.ioRefNum > 0)
			{	/* don't do this stuff if a device driver */
			
				if (type[0]=='a')
				{
					if(err = (PBGetEOF(&pb,false))) goto err_exit;
	
					pb.ioPosOffset = (long)pb.ioMisc;
					pb.ioPosMode = fsFromStart;
					err = PBSetFPos(&pb,false);
					if ((err!=noErr) && (err!=eofErr)) goto err_exit;
				}
				
				if ((type[0]=='w') && (delete))
				{
					pb2.ioFDirIndex = 0;
					pb2.ioNamePtr	= pb.ioNamePtr;
					pb2.ioVRefNum	= pb.ioVRefNum;
					pb2.ioFVersNum	= pb.ioVersNum;
					if (err = (PBGetFInfo(&pb2,false))) goto err_exit;
	
					if (err = (PBClose(&pb,false))) goto err_exit;
	
					if (err = (PBDelete(&pb,false))) goto err_exit;
	
					if (err = (PBCreate(&pb,false))) goto err_exit;
	
					if (err = (PBSetFInfo(&pb2,false))) goto err_exit;
	
					new = PBOpen(&pb,false);
					create = false;
				}
			}
			
			if (!new)
			{
				refnum = pb.ioRefNum;
				who->refnum		= refnum;
				who->last_error	= noErr;
				who->user_buf	= false;
				who->StdStream	= false;
				who->filebuf	= p;
				who->InUse		= true;
				who->mod		= false;
				who->look_full	= false;
				who->rd			= false;
				who->wr			= false;
				who->window		= false;
				if((permission==fsRdWrPerm)||(permission==fsRdPerm))
					who->rd		= true;
				if((permission==fsRdWrPerm)||(permission==fsWrPerm))
					who->wr		= true;
				who->binary		= bin_file;
				who->fpos		= BUFSIZ+10;	/* force fread/fwrite to go to disk */
				who->inbuf		= 0;
				PtoCstr(nameptr);
				if (_init_onexit == false)
				{
					_init_onexit = true;
					onexit(_exit_closeall);
				}

				if ((who->rd)&&(who->wr))
					{
					if(err = read_into_buffer(who))
						if (err != eofErr)
							{
							who->last_error = errno = err;
							return(who);
						}
				}
				return(who);
			}
		}
	}
	while ((new == fnfErr) && (create));
	
	if (new) errno = new;
	
	goto exit_noset;
	
err_exit:
	errno = err;
	
exit_noset:

	DisposPtr(p);
	PtoCstr(nameptr);
	return(NULL);
} /* end of scope of permission */

}




#line 0 fopen
FILE	*unix_fopen(nameptr,type)
	char	*nameptr,*type;
{
	return(unix_xfopen(nameptr,type,NULL));
	
	(void) std_ver();

}



#line 0 freopen
FILE	*unix_freopen(nameptr,type,who)
	char	*nameptr,*type;
	FILE	*who;

{
	if(fclose(who)) return(NULL);
	return(unix_xfopen(nameptr,type,who));
}

static
void _exit_closeall()
{
	_closeall();
}