.TH INC 1 "3 August 1983"
.UC 4
.SH NAME
inc \- incorporate new mail
.SH SYNOPSIS
.B inc
[ +folder ] [ \-audit audit-file ] [ \-help ]
.SH DESCRIPTION
\fIInc\fR incorporates mail from the user's incoming mail drop
(\*.mail) into an MH folder.
If `+folder' isn't specified,
the folder named \*(lqinbox\*(rq in the user's MH directory will be used.
The
new messages being incorporated are assigned numbers starting
with the next highest number in the folder.
If the specified (or
default) folder doesn't exist, the user will be queried prior to
its creation.
As the messages are processed, a \fIscan\fR  listing
of the new mail is produced.
.PP
If the user's profile contains a \*(lqMsg\-Protect: nnn\*(rq entry, it
will be used as the protection on the newly created messages,
otherwise the MH default of 664 will be used.
During all
operations on messages, this initially assigned protection will
be preserved for each message, so \fIchmod\fR(I) may be used to set a
protection on an individual message, and its protection will be
preserved thereafter.
.PP
If the switch `\-audit audit-file' is specified (usually as a
default switch in the profile), then \fIinc\fR will append a header
line and a line per message to the end of the specified
audit-file with the format:
.nf

.ti 1i
\*(<<inc\*(>> date
.ti 1.5i
<scan line for first message>
.ti 1.5i
<scan line for second message>
.ti 2.5i
<etc.>

.fi
This is useful for keeping track of volume and source of incoming
mail.
Eventually, \fIrepl\fR, \fIforw\fR, \fIcomp\fR, and \fIdist\fR may also
produce audits to this (or another) file, perhaps with
\*(lqMessage-Id:\*(rq information to keep an exact correspondence history.
\*(lqAudit-file\*(rq will be in the user's MH directory unless a full
path is specified.
.PP
\fIInc\fR will incorporate even illegally formatted messages into the
user's MH folder, inserting a blank line prior to the offending
component and printing a comment identifying the bad message.
.PP
In all cases, the \*.mail file will be zeroed.
.SH FILES
.nf
.ta \w'<mh-dir>/audit-file    'u
$HOME/\*.mh\(ruprofile	The user profile
$HOME/\*.mail	The user's mail drop
<mh-dir>/audit-file	Audit trace file (optional)
.fi
.SH "PROFILE COMPONENTS"
.nf
.ta \w'Folder\-Protect:	   'u
Path:	To determine the user's MH directory
Folder\-Protect:	For protection on new folders
Msg\-Protect:	For protection on new messages
.fi
.SH DEFAULTS
.nf
`+folder' defaults to \*(lqinbox\*(rq
.fi
.SH CONTEXT
The folder into which the message is
being incorporated will become the
current folder, and the first message incorporated will be the
current message.
This leaves the context ready for a \fIshow\fR
of the first new message.
