.TH FOLDER 1 "3 August 1983"
.UC 4
.SH NAME
folder \- set/list current folder/message
.SH SYNOPSIS
.B folder
[ +folder ] [ msg ] [ \-all ] [ \-fast ] [ \-nofast ] [ \-up ] [ \-down ]
[ \-header ] [ \-noheader ] [ \-total ] [ \-nototal ] [ \-pack ] [ \-nopack ]
[ \-help ]
.PP
folders  <equivalent to 'folder \-all'>
.SH DESCRIPTION
Since the MH environment is the shell, it is easy to lose
track of the current folder from day to day.
\fIFolder\fR will
list the current folder, the number of messages in it, the
range of the messages (low-high), and the current message within
the folder, and will flag a selection list or extra files if they
exist.
An example of the output is:
.nf

      inbox+ has 16 messages ( 3\- 22); cur= 5.

.fi
If a `+folder' and/or `msg' are specified, they will
become the current folder and/or message.
An `\-all' switch
will produce a line for each folder in the user's MH directory,
sorted alphabetically.
These folders are preceded by the read-only
folders, which occur as \*.mh\(ruprofile \*(lqcur\-\*(rq entries.
For example,
.nf

.fc ^ ~
.ta 1.5i 2.1i 2.7i 3.5i
^~Folder\ \ ^^~#\ of\ ^^messages~^^(~\ range\~ );\ ^cur msg (other files)
^~/fsd/rs/m/tacc\ \ ^^has~35\ ^^messages~^^(~1\-\035);\ ^cur=\ 23.
^~/rnd/phyl/Mail/EP\ \ ^^has~82\ ^^messages~^^(~1\-108);\ ^cur=\ 82.
^~f\&f\ \ ^^has~4\ ^^messages~^^(~1\-\0\04);\ ^cur=\ \01.
^~inbox+\ ^^has~16\ ^^messages~^^(~3\-\022);\ ^cur=\ \05.
^~mh\ \ ^^has~76\ ^^messages~^^(~1\-\076);\ ^cur=\ 70.
^~notes\ \ ^^has~2\ ^^messages~^^(~1\-\0\02);\ ^cur=\ \01.
^~ucom\ \ ^^has~124\ ^^messages~^^(~1\-124);\ ^cur=\ \06; (select).

^^^~TOTAL=\0339\ ^messages\0in\0\07\0Folders.
.re
.fi
.PP
The \*(lq+\*(rq after inbox indicates that it is the current folder.
The \*(lq(select)\*(rq indicates that the folder ucom has a selection
list produced by \fIpick\fR.
If \*(lqothers\*(rq had appeared in parentheses at
the right of a line, it would indicate that there are files in
the folder directory that don't belong under the MH file naming
scheme.
.PP
The header is output if either an `\-all' or a `\-header' switch
is specified; it is suppressed by `\-noheader'.
Also, if \fIfolder\fR
is invoked by a name ending with \*(lqs\*(rq (e.g., \fIfolders\fR),
`\-all' is assumed.
A `\-total' switch will produce only the
summary line.
.PP
If `\-fast' is given, only the folder name (or names in the
case of `\-all') will be listed.
(This is faster because the
folders need not be read.)
.PP
The switches `\-up' and `\-down' change the folder to be the
one above or below the current folder.
That is, \*(lqfolder \-down\*(rq
will set the folder to \*(lq<current\-folder>/select\*(rq, and if the
current folder is a selection-list folder, \*(lqfolder \-up\*(rq will
set the current folder to the parent of the selection-list.
(See \fIpick\fR for details on selection-lists.)
.PP
The `\-pack' switch will compress the message names in a folder, removing
holes in message numbering.
.SH FILES
.nf
.ta \w'$HOME/\*.mh\(ruprofile    'u
$HOME/\*.mh\(ruprofile	The user profile
/bin/ls	To fast-list the folders
.fi
.SH "PROFILE COMPONENTS"
.nf
.ta \w'Current-Folder:    'u
Path:	To determine the user's MH directory
Current-Folder:	To find the default current folder
.fi
.SH DEFAULTS
.nf
`+folder' defaults to the current folder
`msg' defaults to none
`\-nofast'
`\-noheader'
`\-nototal'
`\-nopack'
.fi
.SH CONTEXT
If `+folder' and/or `msg' are given, they will become the
current folder and/or message.
