/ C register save and restore -- version 7/75
/ modified by wnj && cbh 6/79 for overlaid text registers
/ modified by wf jolitz 2/80 to work and use emt syscall
/ modified for 8-byte thunk, mjk 10/81

.globl	csv
.globl	cret
.globl  __ovno
.globl  _etext
.data
__ovno:	0
.text

emt= 0104000		/ overlays switched by emulator trap. ovno in r0.

/ ovhndlr(1-9,a-f) are called from the thunks after r1 is set to the location
/ of the first instruction in the subroutine after the call to csv (~foo+4).
/ They in turn branch to ovhndlr which sets the overlay and simulates a csv.
/ Thus, the subroutine's call to csv is bypassed.

.globl	ovhndlr1, ovhndlr2, ovhndlr3, ovhndlr4, ovhndlr5, ovhndlr6, ovhndlr7
.globl	ovhndlr8, ovhndlr9, ovhndlra, ovhndlrb, ovhndlrc, ovhndlrd, ovhndlre
.globl	ovhndlrf

ovhndlr1:
	mov	$1,r0
	br	ovhndlr

ovhndlr2:
	mov	$2,r0
	br	ovhndlr

ovhndlr3:
	mov	$3,r0
	br	ovhndlr

ovhndlr4:
	mov	$4,r0
	br	ovhndlr

ovhndlr5:
	mov	$5,r0
	br	ovhndlr

ovhndlr6:
	mov	$6,r0
	br	ovhndlr

ovhndlr7:
	mov	$7,r0
	br	ovhndlr

ovhndlr8:
	mov	$8.,r0
	br	ovhndlr

ovhndlr9:
	mov	$9.,r0
	br	ovhndlr

ovhndlra:
	mov	$10.,r0
	br	ovhndlr

ovhndlrb:
	mov	$11.,r0
	br	ovhndlr

ovhndlrc:
	mov	$12.,r0
	br	ovhndlr

ovhndlrd:
	mov	$13.,r0
	br	ovhndlr

ovhndlre:
	mov	$14.,r0
	br	ovhndlr

ovhndlrf:
	mov	$15.,r0
/	br	ovhndlr		/ fall through (least used overlay)

ovhndlr:
	cmp	r0,__ovno
	beq	1f
	emt
1:	mov	sp,r5
	mov	__ovno,-(sp)
	mov	r0,__ovno
	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
	jsr	pc,(r1)		/ jsr part is sub $2,sp

/ csv for routines called directly (in base or intra-overlay calls).
/ no overlays have been changed, so we just save the previous overlay
/ number on the stack. note that r0 isn't set to the current overlay
/ because we weren't called through a thunk.
csv:
	mov	r5,r1
	mov	sp,r5
	mov	__ovno,-(sp)	/ overlay is extra (first) word in mark
/ rest is old code common with csv
	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
	jsr	pc,(r1)		/ jsr part is sub $2,sp
/
/ at this point, the stack frame looks like this:
/
/	_________________________
/	|  return addr to callee|
/	|_______________________|
/ r5->	| old r5	        |
/	|_______________________|
/	| previous ovnumber     |
/	|_______________________|
/	| old r4		|
/	|_______________________|
/	| old r3		|
/	|_______________________|
/ sp->	| old r2		|
/	|_______________________|
/


cret:
	mov	r5,r2
/ get the overlay out of the mark, and if it is non-zero
/ make sure it is the currently loaded one
	mov	-(r2),r4
	bne	1f		/ zero is easy
2:
	mov	-(r2),r4
	mov	-(r2),r3
	mov	-(r2),r2
	mov	r5,sp
	mov	(sp)+,r5
	rts	pc
/ not returning to root segment, so check that the right
/ overlay is loaded, and if not ask UNIX for help
1:
	cmp	r4,__ovno
	beq	2b		/ lucked out!
/ if return address is in root segment, then nothing to do
	cmp	2(r5),$_etext
	blos	2b
/ returning to wrong overlay --- do something!
	mov	r0,r3
	mov	r4,r0
	emt
	mov	r4,__ovno
	mov	r3,r0
/ intr. routines may run between these, so should force segment __ovno
	br	2b
