/*
   Jonathan Payne at Lincoln-Sudbury Regional High School 5-25-83
  
   C tags package.  */

#include "jove.h"

extern char searchbuf[];

/* Find the line with the correct tagname at the beginning of the line.
 * then put the data into the struct, and then return a pointer to
 * the struct.  0 if an error.
 */

look_up(sstr, filebuf, name)
register char	*name;
char	*sstr,
	*filebuf;
{
	register int	namlen = strlen(name);
	char	line[LBSIZE];
	register char	*cp;

	if ((io = open("tags", 0)) == -1) {
		message(IOerr("open", "tags"));
		return 0;
	}
	while (getfline(line) != EOF) {
		if (line[0] != *name || strncmp(name, line, namlen) != 0)
			continue;
		if (line[namlen] != '\t')
			continue;
		else {
			char	*endp,
				*newp;

			if (cp = index(line, '\t'))
				cp++;
			else
tagerr:				complain("Bad tag file format");
			if (endp = index(cp, '\t'))
				*endp = 0;
			else
				goto tagerr;
			strcpy(filebuf, cp);
			if ((newp = index(endp + 1, '/')) ||
					(newp = index(endp + 1, '?')))
				newp++;
			else
				goto tagerr;
			strcpy(sstr, newp);
			sstr[strlen(sstr) - 1] = 0;
			IOclose();
			return 1;
		}
	}
	IOclose();
	return 0;
}

TagError(tag)
char	*tag;
{
	s_mess("tag: %s not found", tag);
}

/*
 * Find_tag searches for the 'tagname' in the file "tags".
 * The "tags" file is in the format generated by "/usr/bin/ctags".
 */

find_tag(tagname)
char	*tagname;
{
	char	filebuf[50],
		sstr[100];
	BUFLOC	*bp;

	if (look_up(sstr, filebuf, tagname) == 0) {
		TagError(tagname);
		return;
	}

	SetBuf(do_find(curwind, filebuf));
	Bof();

	if ((bp = dosearch(sprint(sstr, tagname), 1, 1)) == 0)
		TagError(tagname);
	else
		SetDot(bp);
}

/* Called from user typing ^X t */

FindTag()
{
	char	*tagname;

	tagname = ask((char *) 0, FuncName());
	find_tag(tagname);
}
