/*
 *   This program will read its standard input (a C program) and write it
 * back out to the standard output translating words found in C strings in
 * that input via the following translation table (trans).  If a word is not
 * found in the translation table, it will be passed on unchanged.
 *
 *  Note that `words' are considered to be delimited by any non-alphabetic
 * character or the beginning or end of the string in which it resides.
 *
 *   Example:  "aid" is matched in the string "Do you need aid?" but not in
 * the string "I'll send in the maid".
 *
 *   Example:  "are not" is found in the string "You are not right!"
 */

#include  <stdio.h>
#include  <ctype.h>

typedef  struct  { char  *word, *crypt;
                 }
  trans;


trans  trtab[] =
  {	"You can't reach the floor!",
	"You can't reach the floor.",	/* xstr */

	"You turn to stone ...",
	"You turn to stone.",		/* xstr */

	"fatal mistake ...",
	"fatal mistake.",		/* xstr */

	"Cannot open %s .",
	"Cannot open %s.",		/* xstr */

	"A mysterious force prevents you from going %s.",	"%s?",
	"Probably someone removed it.",			"rmvd?",
	"Strange... I didnt know you had that ring.",	"rng?",
	"Something is written in a very strange way.",	"bd eng?",
	"No used-up objects on the shopping bill.",	"invnt?",
	"Strange, this map is not as I remember it.",	"map?",
	"Somebody is trying some trickery here ...",	"tilt!",
	"This game is void ...",			"barf!",
	"What a funny potion! (%u)",			"potion(%u)?",
	"onbill: paid obj on bill?",			"bill?",
	"onbill: unpaid obj not on bill?",		"bill?",
	"obfree: not on bill??",			"bill?",
	"splitbill: not on bill?",			"bill?",
	"Negative quantity on bill??",			"bill?",
	"Zero quantity on bill??",			"bill?",
	"doinvbill: no shopkeeper?",			"bill?",
	"Unknown direction",				"dir",
	"Steal fails!",					"steal?",
	"Tried to steal a strange worn thing.",		"steal?",
	"How come you are carrying that chain?",	"steal?",
	"You hit a trap of type %u",			"trap(%u)?",
	"Some monster encountered a strange trap.",	"trap?",
	"Where are your chain and ball??",		"trap?",
	"Not a single corridor on this level??",	"vault?",
	"Where is the guard?",				"vault?",
	"fakecorr overflow",				"vault?",
	"Do_oname: cannot find obj.",			"Do_name?",
	"Perhaps there is an old record_lock around",	"ld rclk",
	"Waiting for access to record file",		"Wtng",
	"Cannot open record file!",			"opn?",
	"Cannot write record file",			"wrt?",
	"Cannot find any entries for",			"Ct fnd",
	"Error in del_engr",				"del_engr",
	"error in freeobj",				"freeobj?",
	"error in freegold",				"freegold?",
	"Read %d instead of %u bytes",			"rd %d != %u",
	"Error restoring old game.",			"rstr gm?",
	"Error reading level file.",			"lvl fl?",
	"DOORMAX exceeded",				"D*MAX",
	"rooms not closed by -1",			"cls rms",
	"Not enough gems",				"Gms",
	"WARNING: prefix too short.",			"prfx?",
	"Cannot open data file!",			"data?",
	"sh: cannot execute.",				"sh?",
	"Fork failed. Try again.",			"Fork!",
	"Cannot open %s.",				"%s?",
	"Cannot open save file. (Continue or Quit)",	"bd fl",
	"Error while saving: cannot read %s.",		"%s?",
	"Saved game was not yours.",			"Nt urs",
	"Cannot open temp file %s!",			"%s?",
	"Cannot find the iron chain?",			"chain?",
	"Cannot find the iron ball?",			"ball?",
	"Cannot find the monster ustuck.",		"ustuck?",
	"Restobjchn: error reading objchn.",		"objchn?",
	"Restmonchn: error reading monchn.",		"monchn?",
	"Shopkeeper administration out of order.",	"Shpkpr?",
	"Error in shopkeeper administration.",		"Shpkpr?",
	"Bad shopkeeper administration.",		"Shpkpr?",
	"Can't get TERM.",				"TERM?",
	"Unknown terminal type: %s.",			"%s?",
	"Hack needs a screen of size at least %d by %d.",	"bad term!",
	"Terminal must backspace.",			"bad term!",
	"Hack needs CL.",				"bad term!",
	"Hack can't have OS.",				"bad term!",
	"Hack needs CM or UP or HO.",			"bad term!",
	"Playing hack on terminals without cm is suspect...",	"bad term!",
	"TERMCAP entry too big...",			"bad term!",
	"Cannot get status of %s.",			"%s?",
	"Cannot get status of saved level?",		"lvl fl?",
	"Saved levels out of date.",			"lvl fl?",
	"Cannot link %s to %s",				"%s-%s?",
	"Perhaps there is no (empty) file %s ?",	"%s?",
	"It seems you don't have write permission here.",	"wrt?",
	"(Try again or remove %s.)",			"%s?",
	"I don't know what is wrong.",			"?",
	"Cannot open %s",				"%s?",
	"Too many hacks running now.",			"#?",
	"There is a game in progress under your name.",	"In progress!",
	"Cannot unlink %s.",				"%s?",
	"cannot creat lock file.",			"lock?",
	"cannot write lock",				"lock?",
	"cannot close lock",				"lock?",
	"Not a single corridor on this level??",	"corr?",
	"Cannot find worm segment",			"worm?",
	"Cannot reallocate %d bytes",			"realloc %d?",

	"a funny",					"an odd",
	"a peculiar",					"an odd",
	"a strange",					"an odd",

	"Be seeing you",				"Bcnu",
	"Restoring old save file",			"uncB",
	"Worthless piece of",				"Worthless",

	"Are",			"R",
	"are",			"r",
	"Can",			"Cn",
	"can",			"cn",
	"Not",			"Nt",
	"not",			"nt",
	"You",			"U",
	"you",			"u",

	"Aren't",		"Nt",
	"aren't",		"rnt",
	"R nt",			"Rnt",
	"r nt",			"rnt",
	"Cannot",		"Ct",
	"cannot",		"ct",
	"Cn nt",		"Ct",
	"cn nt",		"ct",
	"Cn't",			"Ct",
	"cn't",			"ct",

	"U r",			"U'r",
	"u r",			"u'r",
	"U're",			"U'r",
	"u're",			"u'r",
	"U rnt",		"U'rnt",
	"u rnt",		"u'rnt",
	"U'r nt",		"U'rnt",
	"u'r nt",		"u'rnt",
	"have",			"hv",
	"having",		"hvng",
	"hv nt",		"hvnt",
	"haven't",		"hvnt",
	"I hv",			"Iv",
	"I've",			"Iv",
	"U hv",			"Uv",
	"u hv",			"uv",
	"U've",			"Uv",
	"u've",			"uv",
	"Your",			"Ur",
	"your",			"ur",
	"yourself",		"urslf",

	"Did nt",		"Dt",
	"did nt",		"dt",
	"Didn't",		"Dt",
	"didn't",		"dt",
	"didnt",		"dt",
	"Do",			"D",
	"do",			"d",
	"D nt",			"Dt",
	"d nt",			"dt",
	"Don't",		"Dt",
	"don't",		"dt",
	"Does nt",		"Dsnt",
	"does nt",		"dsnt",
	"Doesn't",		"Dsnt",
	"doesn't",		"dsnt",

	"I am",			"Im",
	"It is",		"Ts",
	"it is",		"ts",
	"There is",		"Trs",
	"there is",		"trs",
	"Will nt",		"Wnt",
	"will nt",		"wnt",
	"Won't",		"Wnt",
	"won't",		"wnt",

	"U'rnt",		"Nt",
	"U cnt",		"Ct",
	"U dnt",		"Dt",
	"Uv nt",		"Uvnt",
	"uv nt",		"uvnt",
	"U hvnt",		"Uvnt",
	"u hvnt",		"uvnt",
	"U dropped",		"Dropped",
	"U finished ur",	"Finished",
	"U finished",		"Finished",
	"U'r already",		"Already",
	"U'r carrying",		"Carrying",

	"able",			"abl",
	"aborted",		"abrtd",
	"about",		"abt",
	"above",		"abv",
	"accepts",		"acpts",
	"administration",	"admn",
	"affect",		"fct",
	"affected",		"fctd",
	"against",		"gnst",
	"again",		"gn",
	"allowed",		"llwd",
	"almost",		"lmst",
	"Already",		"Lrdy",
	"already",		"lrdy",
	"And",			"N",
	"and",			"n",
	"anymore",		"ymr",
	"any",			"y",
	"Anything",		"Yth",
	"anything",		"yth",
	"appears",		"sms",
	"armor",		"rmr",
	"around",		"rnd",
	"assorted",		"ass",
	"At",			"@",
	"at",			"@",
	"ate",			"8",
	"awake",		"wk",
	"awakens",		"wkns",
	"away",			"awy",
	"Bad",			"Bd",
	"bad",			"bd",
	"back",			"bk",
	"backpack",		"bkpk",
	"backspace",		"bksp",
	"ball",			"bl",
	"be",			"b",
	"because",		"bcs",
	"becomes",		"bcms",
	"been",			"bn",
	"before",		"bfr",
	"begin",		"bgn",
	"beginning",		"bgng",
	"behind",		"bhnd",
	"Being",		"Bng",
	"being",		"bng",
	"better",		"btr",
	"between",		"btwn",
	"beautiful",		"cute",
	"befalls",		"bfls",
	"blast",		"blst",
	"blinded",		"blndd",
	"blind",		"blnd",
	"blob",			"blb",
	"blown",		"blwn",
	"bolt",			"blt",
	"boolean",		"bool",
	"bottle",		"btl",
	"breaks",		"brks",
	"burn",			"brn",
	"burned",		"brnd",
	"burning",		"brng",
	"But",			"Bt",
	"but",			"bt",
	"cadaver",		"bdy",
	"Carrying",		"Crryng",
	"carrying",		"crryng",
	"carry",		"crry",
	"ceiling",		"clng",
	"chain",		"chn",
	"choose",		"pck",
	"climb",		"clmb",
	"closed",		"clsd",
	"closes",		"clses",
	"close",		"cls",
	"cold",			"cld",
	"coloured",		"clrd",
	"command",		"cmd",
	"confused",		"cnfsd",
	"confuse",		"cnfs",
	"confusion",		"cnfsn",
	"contains",		"hlds",
	"Continue",		"Cont",
	"continue",		"cont",
	"contribution",		"gft",
	"control",		"ctl",
	"corridor",		"corr",
	"course",		"crse",
	"crashes",		"crshs",
	"darker",		"drkr",
	"darkness",		"drknss",
	"dark",			"drk",
	"dead",			"dd",
	"defend",		"dfnd",
	"delicatessen",		"deli",
	"description",		"dscr",
	"detection",		"dt",
	"device",		"dv",
	"digging",		"dgng",
	"dig",			"dg",
	"direction",		"dir",
	"directory",		"drctry",
	"disappears",		"dsprs",
	"discovered",		"dscvrd",
	"distance",		"dist",
	"disturbed",		"dstrbd",
	"door",			"dr",
	"downward",		"dnwrd",
	"down",			"dn",
	"drop",			"drp",
	"Dropped",		"Drpd",
	"dropped",		"drpd",
	"dungeon",		"dngn",
	"effort",		"eff",
	"else",			"els",
	"empty",		"mt",
	"enchant",		"ncht",
	"enormous",		"bg",
	"enough",		"nf",
	"enters",		"ntrs",
	"Error",		"Er",
	"error",		"er",
	"escaped",		"escpd",
	"escape",		"escp",
	"evaporate",		"dry",
	"evaporates",		"drys",
	"Everything",		"Evrth",
	"everything",		"evrth",
	"example",		"xmpl",
	"exist",		"xst",
	"expences",		"xpncs",
	"experienced",		"xprncd",
	"experience",		"xprnc",
	"Falling",		"Fllng",
	"falling",		"fllng",
	"falls",		"flls",
	"fall",			"fll",
	"feeling",		"flng",
	"feels",		"fls",
	"feel",			"fl",
	"feet",			"ft",
	"File",			"Fl",
	"file",			"fl",
	"finds",		"fnds",
	"find",			"fnd",
	"fingers",		"fngrs",
	"fingertips",		"fngrtps",
	"finger",		"fngr",
	"Finished",		"Fnshd",
	"finished",		"fnshd",
	"first",		"1st",
	"flash",		"flsh",
	"flask",		"flsk",
	"float",		"flt",
	"floating",		"fltng",
	"floor",		"flr",
	"followed",		"fllwd",
	"follow",		"fllw",
	"food",			"fd",
	"Fortunately",		"4tntly",
	"For",			"4",
	"for",			"4",
	"from",			"fr",
	"frozen",		"frzn",
	"funny",		"odd",
	"gets",			"gts",
	"get",			"gt",
	"gift",			"gft",
	"give",			"gv",
	"gladly",		"gldly",
	"glass",		"glss",
	"gloves",		"glvs",
	"glowing",		"glwng",
	"glows",		"glws",
	"glow",			"glw",
	"gold",			"gld",
	"great",		"grt",
	"greedy",		"grdy",
	"guards",		"grds",
	"guard",		"grd",
	"had",			"hd",
	"half",			"hlf",
	"handed",		"hndd",
	"hands",		"hnds",
	"hand",			"hnd",
	"Happens",		"Hpns",
	"happens",		"hpns",
	"hard",			"hrd",
	"has",			"hs",
	"head",			"hd",
	"heavier",		"hvyr",
	"heavy",		"hvy",
	"%sheavy",		"%shvy",
	"held",			"hld",
	"Hello",		"Hi",
	"helmet",		"hlmt",
	"helping",		"hlpng",
	"helps",		"hlps",
	"Here",			"Hr",
	"here",			"hr",
	"hidden",		"hddn",
	"Hit",			"Ht",
	"hit",			"ht",
	"hits",			"hts",
	"holding",		"hldng",
	"However",		"Hwvr",
	"How",			"Hw",
	"how",			"hw",
	"In",			"N",
	"in",			"n",
	"incantation",		"spl",
	"individual",		"indiv",
	"initialization",	"ini",
	"inside",		"nsd",
	"instructions",		"instrs",
	"interested",		"hep",
	"Interesting...",	"Hmm...",
	"interesting",		"fun",
	"into",			"n2",
	"inventory",		"nvnt",
	"Is",			"S",
	"is",			"s",
	"items",		"itms",
	"itself",		"itslf",
	"kind",			"knd",
	"know",			"kn",
	"labeled",		"lbld",
	"label",		"lbl",
	"language",		"lang",
	"large",		"lrg",
	"leave",		"lv",
	"leaving",		"lvng",
	"Left",			"Lft",
	"left",			"lft",
	"leg",			"lg",
	"legs",			"lgs",
	"Level",		"Lvl",
	"level",		"lvl",
	"lift",			"lft",
	"lifting",		"lftng",
	"likely",		"lkly",
	"like",			"lk",
	"list",			"lst",
	"little",		"ltl",
	"liquid",		"lqd",
	"liquor",		"lqr",
	"load",			"ld",
	"look",			"lk",
	"looking",		"lkng",
	"looks",		"lks",
	"longer",		"lngr",
	"Long",			"Lng",
	"long",			"lng",
	"made",			"md",
	"make",			"mk",
	"makes",		"mks",
	"many",			"mny",
	"message",		"msg",
	"missed",		"msd",
	"misses",		"mses",
	"miss",			"ms",
	"mistake",		"mstk",
	"moment",		"mmnt",
	"money",		"bux",
	"monsters",		"mons",
	"monster",		"mon",
	"Moreover",		"Mrvr",
	"Most",			"Mst",
	"moving",		"mvng",
	"move",			"mv",
	"much",			"mch",
	"must",			"mst",
	"Name",			"Nm",
	"named",		"nmd",
	"nearby",		"nrby",
	"needs",		"nds",
	"Negative",		"Ng",
	"never",		"nvr",
	"nobody",		"nbdy",
	"Nothing",		"Nth",
	"nothing",		"nth",
	"Not",			"Nt",
	"not",			"nt",
	"notice",		"c",
	"Now",			"Nw",
	"now",			"nw",
	"Number",		"#",
	"number",		"#",
	"objects",		"objs",
	"object",		"obj",
	"of",			"f",
	"off",			"ff",
	"one",			"1",
	"only",			"nly",
	"open",			"opn",
	"opener",		"opnr",
	"Opening",		"Opng",
	"opening",		"opng",
	"opens",		"opns",
	"options",		"opts",
	"option",		"opt",
	"order",		"ordr",
	"Outside",		"Otsd",
	"outside",		"otsd",
	"out",			"ot",
	"overflow",		"vrfl",
	"over",			"ovr",
	"Paid",			"Pd",
	"paid",			"pd",
	"pair",			"pr",
	"partially",		"prtly",
	"parts",		"prts",
	"part",			"prt",
	"patterns",		"ptrns",
	"pay",			"py",
	"paying",		"pyng",
	"payment",		"pymnt",
	"peculiarly",		"odly",
	"peculiar",		"od",
	"Perhaps",		"Prhps",
	"perhaps",		"prhps",
	"Pick",			"Pk",
	"pick",			"pk",
	"picture",		"pc",
	"pieces",		"pcs",
	"piece",		"pc",
	"place",		"plc",
	"Please",		"Pls",
	"please",		"pls",
	"plundered",		"plndrd",
	"points",		"pnts",
	"poison",		"poisn",
	"poisoned",		"poisnd",
	"poisoning",		"poisng",
	"poisonous",		"poisns",
	"presence",		"prsnc",
	"present",		"prsnt",
	"Probably",		"Prb",
	"probably",		"prb",
	"pulls",		"pls",
	"pull",			"pl",
	"punished",		"pnshd",
	"purse",		"prs",
	"push",			"psh",
	"put",			"pt",
	"quantity",		"qan",
	"quickly",		"qckly",
	"Readonly",		"Rdnly",
	"Read",			"Rd",
	"reading",		"rdng",
	"reads",		"rds",
	"read",			"rd",
	"really",		"rly",
	"recently",		"rcntly",
	"record_lock",		"rclk",
	"refrigerate",		"frig",
	"remove",		"rmv",
	"removed",		"rmvd",
	"renamed",		"rnmd",
	"Right",		"Rt",
	"right",		"rt",
	"rings",		"rngs",
	"ring",			"rng",
	"rock",			"rk",
	"rooms",		"rms",
	"room",			"rm",
	"safelock",		"sflk",
	"satisfied",		"satsfied",
	"scroll",		"scrl",
	"scrolls",		"scrls",
	"seems",		"sms",
	"seem",			"sm",
	"see",			"c",
	"sense",		"sns",
	"several",		"svrl",
	"Shopkeeper",		"Shpkpr",
	"shopkeeper",		"shpkpr",
	"shopping",		"shpng",
	"shop",			"shp",
	"short",		"shrt",
	"snatches",		"sntchs",
	"Somebody",		"Smbdy",
	"somebody",		"smbdy",
	"Somehow",		"Smhw",
	"Someone",		"Sm1",
	"someone",		"sm1",
	"Something",		"Sth",
	"something",		"sth",
	"somewhat",		"smwt",
	"Some",			"Sm",
	"some",			"sm",
	"sound",		"snd",
	"spins",		"spns",
	"splashed",		"splshd",
	"squeeze",		"sqz",
	"start",		"strt",
	"still",		"stl",
	"stomach",		"gut",
	"stone",		"stn",
	"stranger",		"strgr",
	"Strange",		"Od",
	"strange",		"od",
	"stuff",		"stf",
	"Suddenly",		"Sdnly",
	"suddenly",		"sdnly",
	"sudden",		"sdn",
	"sword",		"swd",
	"takes",		"tks",
	"take",			"tk",
	"taking",		"tkng",
	"teleported",		"tprtd",
	"teleportation",	"tprtn",
	"teleport",		"tprt",
	"terminal",		"term",
	"terminals",		"terms",
	"Thank",		"Thnk",
	"That",			"Th",
	"that",			"th",
	"them",			"tm",
	"themselves",		"tmslvs",
	"then",			"tn",
	"There",		"Tr",
	"there",		"tr",
	"These",		"Tse",
	"these",		"tse",
	"The",			"T",
	"the",			"t",
	"Things",		"Tgs",
	"things",		"tgs",
	"thing",		"tg",
	"Thinking",		"Thnkng",
	"think",		"thnk",
	"thin",			"thn",
	"This",			"Ths",
	"this",			"ths",
	"thousand",		"1k",
	"To",			"2",
	"to",			"2",
	"top",			"tp",
	"Too",			"2",
	"too",			"2",
	"trap",			"trp",
	"turned",		"trnd",
	"turns",		"trns",
	"turn",			"trn",
	"two",			"2",
	"Type",			"Typ",
	"type",			"typ",
	"under",		"ndr",
	"Unfortunately",	"N4tntly",
	"Unknown",		"Nkn",
	"unknown",		"nkn",
	"Unpaid",		"Npd",
	"unpaid",		"npd",
	"very",			"vry",
	"wall",			"wl",
	"want",			"wnt",
	"Was",			"Ws",
	"was",			"ws",
	"water",		"h2o",
	"way",			"wy",
	"weapon",		"wpn",
	"wear",			"wr",
	"wearing",		"wrng",
	"Welcome",		"Wlcm",
	"welcome",		"wlcm",
	"were",			"wr",
	"What",			"Wt",
	"what",			"wt",
	"when",			"wn",
	"Where",		"Wr",
	"where",		"wr",
	"while",		"wl",
	"whistle",		"wstl",
	"whistling",		"wstlng",
	"why",			"y",
	"Will",			"Wll",
	"Will",			"Wll",
	"will",			"wll",
	"wipe",			"wp",
	"wiped",		"wpd",
	"without",		"w/o",
	"With",			"Wth",
	"with",			"/w",
	"words",		"wrds",
	"world",		"wrld",
	"worth",		"wrth",
	"worthless",		"wrthlss",
	"write",		"wrt",
	"writing",		"wrtng",
	"written",		"wrtn",
	"Zorkmids",		"Bux",
	"zorkmids",		"bux",
	0,			0
  };


main ()

  { register int   incomment   = 0,
                   incharacter = 0;
    register char  lastc       = '\0',
                   c;

    while  ((c = getchar ()) != EOF)
    {  putchar (c);

      if  (incomment)
        incomment = !(lastc == '*'  &&  c == '/');
      else
      if  (incharacter)
        if  (lastc == '\\'  &&  c == '\\')
          c = '\0';    /* don't let '\\' fool us ... */
        else
          incharacter = !(lastc != '\\' &&  c == '\'');
      else
      if  (lastc == '/'  &&  c == '*')
      { incomment = 1;
        c         = '\0';    /* don't let `/ * / ...' fool us */
      }
      else if  (c == '\'')
        incharacter = 1;
      else
        if  (c == '"')
          dostring ();

      lastc = c;
    }

    exit (0);
}


dostring ()

  { char            string[BUFSIZ];
    register char   *cp;
    register trans  *tp;

    getstring (string);
    for  (tp = trtab;  tp->word;  tp++)
      scanstring (string, tp->word, tp->crypt);
    fputs (string, stdout);
    putchar ('"');
  }


getstring (string)
  register char  *string;

  { register char  lastc = '"',
                   c;

    while  ((c = getchar ()) != EOF  &&  !(lastc != '\\'  &&  c == '"'))
    { if  (lastc == '\\'  &&  c == '\n')
        c     = getchar ();
      *string++ = c;
      if  (lastc == '\\'  &&  c == '\\')
        c = '\0';    /* don't let `"...\\"' fool us */
      lastc     = c;
    }
    *string = '\0';
  }


scanstring (string, word, crypt)
  char  *string, *word, *crypt;

  { register int   wlen = strlen (word),
                   clen = strlen (crypt);
    register char  *cp  = string,
                   *end;

    end = string + strlen (string) - wlen;
    while  (cp <= end)
      if  (    strncmp (cp, word, wlen) == 0
           &&  (cp == string  ||  !isalpha (cp[-1]))
           &&  (cp == end     ||  !isalpha (cp[wlen])))
      { strncpy (cp, crypt, clen);
        strcpy  (cp + clen, cp + wlen);
        cp  += clen;
        end -= wlen-clen;
      }
      else
        cp++;
  }
