# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
static char ID[] = "@(#) ld.lex: 1.10 12/1/83";
#include "system.h"
#include <stdio.h>
#include <signal.h>
#include "bool.h"
#include "paths.h"
#include "sgs.h"
#include "structs.h"		/* global structure definitions  */
#include "extrns.h"		/* external function definitions */
#include "y.tab.h"		/* tokens generated by yacc      */

#if !ONEPROC || TRVEC
#include "tv.h"
#include "ldtv.h"
#endif

#include "aouthdr.h"
#if ONEPROC
#include "instr.h"
#endif

extern char version[];		/* ld version information */

/*
 *	There are four start states for the lex parse:
 *
 *	A	: look for initial keyword of a ld directive
 *	MEMoREG	: scan a ld directive
 *	COMA	: skip a stand-alone comment
 *	COMoMR	: skip a comment at the end of a directive
 */

#define RET1(a)   {yylval.ivalue=a;moveit(1,a);return(a);}
#define RET2(a,b) {yylval.sptr=a;moveit(2,yylval.sptr);return(b);}
#define RET3(a,b) {yylval.lptr=a;moveit(3,yylval.lptr);return(b);}



#define LSAVSIZE 6
static long lsavarea[LSAVSIZE];	/* local save area for integer tokens */
static int lsavndx = 0;
extern long *savelng();

#define CSAVSIZE 1024
static char csavarea[CSAVSIZE];	/* local save area for string tokens */
static char *csavptr = &csavarea[0];
extern char *savestr();

char inline[256];		/* global save area for the current input line */
char *inptr = &inline[0];

char **argptr;		/* main procedure argument list */
int argcnt;		/*	and count		*/


extern int in_y_exp;	/*	in_y_exp :
			 *		TRUE  : yacc is parsing assignment
			 *		FALSE : yacc is not in assignment
			 *
			 *	See explanation is ld.yac.
			 */

int	assigncnt;	/* number of assignment slots		*/


#if FLEXNAMES
#	define STRBASE 6144
#else
#	define STRBASE 3072
#endif
/*eject*/
# define A 2
# define MEMoREG 4
# define COMA 6
# define COMoMR 8
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
		long longint;	/* local variables used in processing */
		char *p;	/* numbers and strings		      */
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	BEGIN COMA;
break;
case 2:
BEGIN COMoMR;
break;
case 3:
BEGIN A;
break;
case 4:
BEGIN MEMoREG;
break;
case 5:
;
break;
case 6:
{ BEGIN MEMoREG; RET1(MEMORY); }
break;
case 7:
{ BEGIN MEMoREG; RET1(REGIONS); }
break;
case 8:
	{ BEGIN MEMoREG; RET1(TV); }
break;
case 9:
RET1(SECTIONS);
break;
case 10:
RET1(DSECT);
break;
case 11:
RET1(NOLOAD);
break;
case 12:
	RET1(COPY);
break;
case 13:
	RET1(INFO);
break;
case 14:
	{ BEGIN A; RET1(RBRACE); }
break;
case 15:
  RET1(ORG);
break;
case 16:
  RET1(LEN);
break;
case 17:
RET1(SPARE);
break;
case 18:
RET1(RANGE);
break;
case 19:
RET1(ASSIGN);
break;
case 20:
	RET1(DOT);
break;
case 21:
	RET1(RBRACE);
break;
case 22:
	RET1(LBRACE);
break;
case 23:
	RET1(RPAREN);
break;
case 24:
	RET1(LPAREN);
break;
case 25:
	RET1(COLON);
break;
case 26:
	RET1(SEMICOL);
break;
case 27:
	RET1(MINUS);
break;
case 28:
	RET1(EQ);
break;
case 29:
	RET1(GT);
break;
case 30:
	RET1(COMMA);
break;
case 31:
	RET1(AND);
break;
case 32:
	RET1(ANDAND);
break;
case 33:
	RET1(OR);
break;
case 34:
	RET1(OROR);
break;
case 35:
	RET1(EQEQ);
break;
case 36:
	RET1(NE);
break;
case 37:
	RET1(BNOT);
break;
case 38:
	RET1(NOT);
break;
case 39:
	RET1(DIV);
break;
case 40:
	RET1(MULT);
break;
case 41:
	RET1(PC);
break;
case 42:
	RET1(LT);
break;
case 43:
	RET1(GE);
break;
case 44:
	RET1(LE);
break;
case 45:
	RET1(LSHIFT);
break;
case 46:
	RET1(RSHIFT);
break;
case 47:
	RET1(PLUS);
break;
case 48:
	RET1(PLUSEQ);
break;
case 49:
	RET1(MINUSEQ);
break;
case 50:
	RET1(MULTEQ);
break;
case 51:
	RET1(DIVEQ);
break;
case 52:
RET1(ALIGN);
break;
case 53:
RET1(BLOCK);
break;
case 54:
RET1(GROUP);
break;
case 55:
RET1(PHY);
break;
case 56:
{
	lineno++;
	inptr = &inline[0];
	}
break;
case 57:
{
	*inptr++ = ' ';
	*inptr   = '\0';
	}
break;
case 58:
{
		longint = 0L;
		for(p=yytext+1; *p != '\0'; p++)  {
			longint = longint * 8 + (*p-'0');
			}
		RET3(savelng(longint), LONGINT);
		}
break;
case 59:
{
		longint = 0L;
		for(p=yytext; *p != '\0'; p++)  {
			longint = longint * 10 + (*p-'0');
			}
		RET3(savelng(longint), LONGINT);
		}
break;
case 60:
 {
		longint = 0L;
		for(p=yytext+2; *p != '\0'; p++)  {
			longint = longint << 4;
			if (*p >= '0' && *p <= '9')
				longint += *p-'0';
			else if (*p >= 'a' && *p <= 'f')
				longint += *p-'a'+10;
			else longint += *p-'A'+10;
			}
		RET3(savelng(longint), LONGINT);
		}
break;
case 61:
{
			yyless(yyleng-2);
			RET2(savestr(yytext), NAME);
		}
break;
case 62:
{
			if ( in_y_exp )
				REJECT;
			yyless(yyleng-2);
			RET2(savestr(yytext), FILENAME);
		}
break;
case 63:
	{
			RET2(savestr(yytext), NAME);
		}
break;
case 64:
	{
			if ( in_y_exp )
				REJECT;
			RET2(savestr(yytext), FILENAME);
		}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
/*eject*/
main(argc,argv)
int argc;
char *argv[];
{

/*
 * This is the MAIN procdure for PASS 1 of ld
 *
 * PASS 1 is the parsing pass:
 *	1. The ld command line, and any specified ifiles, are
 *		scanned for good syntax.
 *	2. Control blocks are constructed, containing the information
 *		extracted from the input.
 *	3. If there are no errors, the control blocks are written out
 *		to a "transfer file", for reading by PASS 2.
 *	4. If there are no errors, PASS 2 is called via a system 
 *		"execl" call.
 */

/*
 * Initialize PASS 1
 */

	initpass1();
	argptr = argv;
	argcnt = argc;
	if ( argcnt <= 1 )
	{
		fprintf( stderr, "Usage: %sld [ options ] file ...\n", SGS );
		exit(1);
	}

/*
 * Process the command-line arguments to ld
 */

	lineno = 0;
	curfilnm = savefn("*command line*");

	while( --argcnt )
		if( **++argptr == '-' )
			/*
			 * The argument is a flag
			 */
			pflags( ++(*argptr), FALSE );
		else {
			/*
			 * The argument is a file name
			 */
			BEGIN A;
			filespec(*argptr);
			}

/*
 * Perform a consistency check among the ld flags:
 *	1. "-h" and "-X" flags
 *	2. "-ild", "-r", and "-a" flags
 *	3. "-r" and "-s" flags
 *	4. "-p" and "-B" flags
 *
 * Assign default values to the ld flags
 *	1. "-h" flag
 *	2. "-a" flag
 *	3. "-p" flag
 */

	if( Xflag )
		if( hflag > 0 ) {
			if( hflag < sizeof(AOUTHDR) )
				lderror(1, 0,NULL, "optional header size (%d bytes) is too small to contain the UNIX a.out header (%d bytes)",
					hflag, sizeof(AOUTHDR) );
			}
		else
			hflag = sizeof(AOUTHDR);
#if ILDOPT
	if (ildflag) {
		rflag = 1;
		if (sflag) {
			lderror (0, 0, NULL, "both -ild and -s flags are set. -s flag turned off");
			sflag = 0;
		}
	}
#endif
	if( rflag  &&  sflag ) {
		lderror(0, 0,NULL, "both -r and -s flags are set. -s flag turned off" );
		sflag = 0;
		}
	if ( Bflag && (pflag > 0) && (pflag < Bflag)) {
		lderror(0, 0, NULL, "pflag(%d) less than Bflag, set to value of Bflag(%d)\n",
			pflag, Bflag);
		pflag = Bflag;
		}
	if( ! rflag )
		aflag = 1;

/*
 * Supply version information
 */

	if( Vflag ) {
		fprintf( stderr, "\n%sld : %s : Version %s",
			SGSNAME, RELEASE, version );
		if( Vflag == 2 ) {
#if AR16WR
 			fprintf( stderr, " : PDP 11/70-45 : " );
#endif
#if AR32WR
			fprintf( stderr, " : VAX 11/780 : " );
#endif
#if ! AR16WR && ! AR32WR
#ifdef u3b
 			fprintf( stderr, " : 3B-20 : " );
#else
			fprintf( stderr, " : non-DEC : ");
#endif
#endif
#if TS
 			fprintf( stderr, "UN*X TS" );
#else
 			fprintf( stderr, "UN*X" );
#endif
			}
		fprintf( stderr, "\n" );
		}

/*
 * Exit if any errors were found, or if this is a "parse only"
 * run
 */

	if( (errlev != 0)  ||  (cflag == 1) ) {
#if !ONEPROC
		unlink( trnname );
#endif
		exit(errlev);
		}

/*
 * Call PASS 2
 */

#if ONEPROC
	pass2();
}
#else
	callpass2();

	unlink( trnname );
	lderror(2, 0,NULL, "failure to load pass 2 of %sld", SGS);
}
/*eject*/
ldexit()
{

/*
  * PASS 1: clean up and exit after a fatal error
 */

	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_DFL);
	signal(SIGTERM, SIG_IGN);
	signal(SIGHUP, SIG_DFL);

	exit(13);  /* unlucky break */
}
/*eject*/
#endif
long *
savelng(l)
long l;
{

/*
 * Copy a long token into local save area and return a pointer to it.
 *
 * The save area is used as a circular buffer
 */

	lsavndx++;
	lsavndx %= LSAVSIZE;
	lsavarea[lsavndx] = l;

	return( &lsavarea[lsavndx] );
}




char *
savestr(p) 
char *p;
{

/*
 * Copy a string into local save area and return a pointer to it
 *
 * The save area is used as a circular buffer
 */

	register char *saveptr;

	if( csavptr > (csavarea + CSAVSIZE - 256) )
		csavptr = csavarea;
	saveptr = csavptr;

	while( *csavptr++ = *p++ );

	return( saveptr );
}




moveit(type, value)
int type, value;
{
	register char *p;

	p = &yytext[0];

	while( *inptr++ = *p++ );
	inptr--;

#if DEBUG
	if( dflag > 3 ) {
		fprintf(stderr, "line: <%s> return: <", inline);
		switch( type ) {
		case 1:
			fprintf(stderr, "%d>\n", value);
			break;
		case 2:
			fprintf(stderr, "%s>\n", (char *) value);
			break;
		case 3:
			fprintf(stderr, "%08lx>\n", * (long *) value);
			break;
		}
		}
#endif
}
/*eject*/
initpass1()
{
	register int oldmode;
	int ldexit();
#if ONEPROC
	long times();
#endif

/*
 * Set the following signals to be caught, unless ld is running in the
 * background. In this case, leave them set at "ignore"
 */

	if( signal(SIGINT, ldexit)  ==  SIG_IGN )
		signal(SIGINT, SIG_IGN);
	if( signal(SIGHUP, ldexit)  ==  SIG_IGN )
		signal(SIGHUP, SIG_IGN);
	if( signal(SIGQUIT, ldexit)  ==  SIG_IGN )
		signal(SIGQUIT, SIG_IGN);


#if ONEPROC
	ttime = times(&ptimes);
#else
/*
 * Create the "transfer file" used to pass information to PASS 2
 */

	sprintf(trnname, "%s/%s", TMPDIR, "ldXXXXX");
	mktemp(trnname);

	oldmode = umask( 0 );
	if( close( creat(trnname,0644) ) == -1 ) {
		umask( oldmode );
		lderror(2, 0,NULL, "can't create intermediate %sld file %s",
			SGS, trnname);
		}
	umask( oldmode );
#endif

/*
 * Allocate the global file name save area
 */

	strbase = myalloc(STRBASE);
	strnext = strbase;
	strlimit = strbase + STRBASE;

#if ONEPROC && (!NOSDP)
	/*
	 * Initialize the Software Demand Paging System
	 */
	syminit();
#endif
}
/*eject*/
#if !ONEPROC
callpass2()
{

/*
 * Output PASS 1 information to the "transfer file"
 *
 *	1. reserve space for flags and list headers
 *	2. output lists
 *	3. output flags and list headers
 */

	trnfdes = fopen(trnname, "w");
	skp_tf_hdr();
	wrt_tf();
	wrt_tf_hdr();
	fclose( trnfdes );

/*
 * Exit, if this is a "generate transfer file run" only
 */

	if( cflag == 2 ) {
		fprintf( stderr, "ld transfer file name: %s\n", trnname );
		exit(0);
		}
#if DEBUG
	if( dflag > 2 )
		fprintf( stderr, "ld transfer file name: %s\n", trnname );
#endif

/*
 * Execute PASS 2
 */

	execl(LD2, LD2, trnname, 0);

}
/*eject*/
skp_tf_hdr()
{

/*
 * Reserve space for control and descriptor information collected during
 * PASS 1
 *
 * This information is of fixed length, and comes at the very beginning
 * of the transfer file
 */

	register long length;

	length = 
		7 * sizeof(int)		    +	/* list sizes	    */
		13 * sizeof(char)	    +	/* flags	    */
#if UNIX || XL
		1 * sizeof(char)	    +	/* xflag	    */
#endif
#if ILDOPT
		1 * sizeof(char)	    +	/* ildflag	    */
#endif
#if PAGING
		1 * sizeof(char)	    +	/* Fflag	    */
#endif
#if PAGING
		1 * sizeof(char)	    +	/* zflag	    */
#endif
#if COMMON
		2 * sizeof(char)	    +	/* tflag and Mflag  */
#endif
		3 * sizeof(int)		    +	/* control values   */
		3 * sizeof(short)	    +	/* VStamp, fill and magic   */
		128			    +	/* output file name */
		8			    +	/* program entry pt */
		sizeof(TVINFO)		    +   /* tv information   */
		1 * sizeof(int);		/* flags + counts   */

	fseek( trnfdes, length, 0 );
}
/*eject*/
wrt_tf()
{

/*
 * Output the bulk of the information extracted from PASS 1:
 *
 *	1. The names of input ifiles, input *.o and archive files, and
 *		output sections
 *	2. The data structures describing the ld directives
 */

	MEMTYPE *outds1();
	REGION *outds2();
	ACTITEM *outds3(), *outds4(), *outds6();
	TVASSIGN *outds8();

/*
 * 1. Output saved strings
 */

	fwrite( strbase, 1, (strnext - strbase), trnfdes );


/*
 * 2a. Output DEFSYM data structures
 */

	symcnt = 0;
	if( symlist.head ) {
		register ACTITEM *a;
		a = (ACTITEM *) symlist.head;
		while( a ) {
			a = outds3(a);
			symcnt++;
			}
		}

/*
 * 2b. Output MEMTYPE data structures
 */

	memcnt = 0;
	if( memlist.head ) {
		register MEMTYPE *m;
		m = (MEMTYPE *) memlist.head;
		while( m ) {
			m = outds1(m);
			memcnt++;
			}
		}

/*
 * 2c. Output REGION data structures
 */

	regcnt = 0;
	if( reglist.head ) {
		register REGION *r;
		r = (REGION *) reglist.head;
		while( r ) {
			r = outds2(r);
			regcnt++;
			}
		}

/*
 * 2d. Output information on input *.o and archive library files
 */

	ldfcnt = 0;
	if( ldfilist.head ) {
		register ACTITEM *a;
		a = (ACTITEM *) ldfilist.head;
		while( a ) {
			a = outds3(a);
			ldfcnt++;
			}
		}
	

/*
 * 2e. Output information on output sections
 */

	bldcnt = 0;
	if( bldoutsc.head ) {
		register ACTITEM *a;
		a = (ACTITEM *) bldoutsc.head;
		while( a ) {
			a = outds4(a);
			bldcnt++;
			}
		}


/*
 * 2f. Output information on assignments
 */

	expcnt = 0;
	if( explist.head ) {
		register ACTITEM *a;
		a = (ACTITEM *) explist.head;
		while( a ) {
			a = outds6(a);
			expcnt++;
			}
		}

/*
 * 2g. Output information on slot assignments
 */

	tvslotcnt = 0;
	if (tvslot1 != NULL) {
		register TVASSIGN *s;
		s = tvslot1;
		while (s != NULL) {
			s = outds8(s);
			++tvslotcnt;
			}
		}
}
/*eject*/
wrt_tf_hdr()
{

/*
 * Output control and descriptor information obtained during PASS 1
 *
 * This information is of fixed length, and comes at the very beginning
 * of the transfer file
 */

	int length;

	fseek( trnfdes, 0L, 0 );

/*
 * Output the sizes of the lists built during PASS 1
 *
 *	1. symbol definition/undefinition
 *	2. MEMORY directives
 *	3. REGIONS directives
 *	4. input *.o and archive library files
 *	5. output sections
 *	6. assignment directives
 *	7. tv slot assignment directives
 */

	fwrite( &symcnt, sizeof(int), 1, trnfdes );
	fwrite( &memcnt, sizeof(int), 1, trnfdes );
	fwrite( &regcnt, sizeof(int), 1, trnfdes );
	fwrite( &ldfcnt, sizeof(int), 1, trnfdes );
	fwrite( &bldcnt, sizeof(int), 1, trnfdes );
	fwrite( &expcnt, sizeof(int), 1, trnfdes );
	fwrite(&tvslotcnt, sizeof(int), 1, trnfdes);

/*
 * Output the ld control flags
 */

	fwrite( &aflag, sizeof(char), 1, trnfdes );
	fwrite( &cflag, sizeof(char), 1, trnfdes );
	fwrite( &dflag, sizeof(char), 1, trnfdes );
	fwrite( &iflag, sizeof(char), 1, trnfdes );
	fwrite( &mflag, sizeof(char), 1, trnfdes );
	fwrite( &rflag, sizeof(char), 1, trnfdes );
	fwrite( &sflag, sizeof(char), 1, trnfdes );
	fwrite( &tvflag, sizeof(char), 1, trnfdes );
	fwrite( &Hflag, sizeof(char), 1, trnfdes );
	fwrite( &Nflag, sizeof(char), 1, trnfdes );
	fwrite( &Sflag, sizeof(char), 1, trnfdes );
	fwrite( &Vflag, sizeof(char), 1, trnfdes );
	fwrite( &Xflag, sizeof(char), 1, trnfdes );
	fwrite( &hflag, sizeof(int), 1, trnfdes );
	fwrite( &pflag, sizeof(int), 1, trnfdes );
	fwrite( &Bflag, sizeof(int), 1, trnfdes );
	fwrite( &VSflag, sizeof(short), 1, trnfdes);
#if UNIX || XL
	fwrite( &xflag, sizeof(char), 1, trnfdes );
#endif
#if COMMON
	fwrite( &tflag, sizeof(char), 1, trnfdes );
	fwrite( &Mflag, sizeof(char), 1, trnfdes );
#endif
#if PAGING
	fwrite( &Fflag, sizeof(char), 1, trnfdes );
#endif
#if PAGING
	fwrite( &zflag, sizeof(char), 1, trnfdes );
#endif
#if ILDOPT
	fwrite( &ildflag, sizeof(char), 1, trnfdes );
#endif

/*
 * Output various values extracted from the parse
 */

	fwrite( &globfill, sizeof(short), 1, trnfdes );
	fwrite( &magic, sizeof(unsigned short), 1, trnfdes );

	fwrite( outfilnm, 128, 1, trnfdes );
	fwrite( epsymbol, 8, 1, trnfdes );

	/* convert filename from ptr to index */
	if (tvspec.tvinflnm != NULL)
		tvspec.tvinflnm = (char *) ((int) tvspec.tvinflnm - (int) strbase);
	fwrite( &tvspec, sizeof(TVINFO), 1, trnfdes );

/*
 * Output the size of the saved strings
 */

	length = strnext - strbase;
	fwrite( &length, sizeof(int), 1, trnfdes );
}
/*eject*/
MEMTYPE *
outds1(m)
MEMTYPE *m;
{

/*
 * Output one MEMTYPE data structure
 */

	fwrite( m, 1, sizeof(MEMTYPE), trnfdes );

	return( m->mtnext );
}



REGION *
outds2(r)
REGION *r;
{

/*
 * Output one REGION data structure
 */

	fwrite( r, 1, sizeof(REGION), trnfdes );

	return( r->rgnext );
}
/*eject*/
ACTITEM *
outds3(a)
ACTITEM *a;
{

/*
 * Output one AILDFILE, AILDLBRY, AIADFILE, or AIDFNSYM data structure
 *
 * Convert a "pointer to a string" to a "index to a string"
 */

	a->ldlbry.aiinflnm = (char *) ((int) a->ldlbry.aiinflnm - (int) strbase);
	a->ldlbry.aifilnam = (char *) ((int) a->ldlbry.aifilnam - (int) strbase);

	fwrite( a, 1, sizeof(ACTITEM), trnfdes );

	return( a->ldlbry.ainext );
}



ACTITEM *
outds4(a)
ACTITEM *a;
{

/*
 * Output one AIDFNSCN or AIDFNGRP data structure
 *
 * Convert a "pointer to a string" to a "index to a string"
 */

	register ACTITEM *anext, *b;
	ACTITEM *outds5();

	anext = a->dfnscn.ainext;
	a->dfnscn.aiinflnm = (char *) ((int) a->dfnscn.aiinflnm - (int) strbase);

	fwrite( a, 1, sizeof(ACTITEM), trnfdes );

	b = (ACTITEM *) a->dfnscn.sectspec.head;
	switch( a->dfnscn.aitype ) {
	case AIDFNSCN:
		while( b )
			switch( b->addscn.aitype ) {
			case AIADDSCN:
				b = outds5(b);
				break;
			case AIADFILE:
				b = outds3(b);
				break;
			case AIEVEXPR:
				b = outds6(b);
				break;
			}
		break;
	case AIDFNGRP:
		while( b )
			b = outds4(b);
		break;
	default:
		lderror(2,0,NULL,"failure dumping an AIDFNxxx data structure\n");
	}

	return( a->dfnscn.ainext );
}



ACTITEM *
outds5(a)
ACTITEM *a;
{

/*
 * Output one AIADDSCN data structure
 *
 * Convert a "pointer to a string" to a "index to a string"
 */

	a->addscn.aiinflnm = (char *) ((int) a->addscn.aiinflnm - (int) strbase);
	a->addscn.aiscfile = (char *) ((int) a->addscn.aiscfile - (int) strbase);

	fwrite( a, 1, sizeof(ACTITEM), trnfdes );

	return( a->addscn.ainext );
}



ACTITEM *
outds6(a)
ACTITEM *a;
{

/*
 * Output one AIEVEXPR data structure
 *
 * Convert a "pointer to a string" to a "index to a string"
 */

	a->evexpr.aiinflnm = (char *) ((int) a->evexpr.aiinflnm - (int) strbase);

	fwrite( a, 1, sizeof(ACTITEM), trnfdes );

	outds7( a->evexpr.aiexptr );

	return( a->evexpr.ainext );
}



outds7(e)
ENODE *e;
{

/*
 * Output one ENODE data structure
 */

	switch( (unsigned) e->gnode.exop ) {
	case INT:
	case DOT:
		fwrite( e, 1, sizeof(ENODE), trnfdes );
		break;
	case NAME:
		fwrite( e, 1, sizeof(ENODE), trnfdes );
		break;
	default:
		fwrite( e, 1, sizeof(ENODE), trnfdes );
		if( e->gnode.exleft )
			outds7(e->gnode.exleft);
		if( e->gnode.exright )
			outds7(e->gnode.exright);
	}

}



TVASSIGN *
outds8(s)
TVASSIGN *s;
{

/*
 *	Output one tv slot assignment (TVASSIGN) structure
 */

	fwrite( s, sizeof(TVASSIGN), 1, trnfdes);
	return( s->nxtslot );
}
#endif
int yyvstop[] = {
0,

57,
0,

56,
0,

38,
0,

63,
64,
0,

41,
0,

31,
0,

24,
0,

23,
0,

40,
0,

47,
0,

30,
0,

27,
0,

20,
63,
64,
0,

39,
64,
0,

58,
59,
63,
64,
0,

59,
63,
64,
0,

25,
0,

26,
0,

42,
0,

28,
0,

29,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

22,
0,

33,
0,

21,
0,

37,
0,

39,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

16,
63,
64,
0,

15,
63,
64,
0,

63,
64,
0,

17,
63,
64,
0,

14,
21,
0,

5,
0,

5,
57,
0,

5,
0,

5,
0,

36,
0,

64,
0,

32,
0,

50,
0,

48,
0,

49,
0,

64,
0,

1,
0,

64,
0,

51,
0,

58,
59,
63,
64,
0,

63,
64,
0,

45,
0,

44,
0,

35,
0,

43,
0,

46,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

8,
63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

34,
0,

2,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

3,
0,

4,
0,

61,
62,
0,

62,
0,

60,
63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

55,
63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

16,
63,
64,
0,

15,
63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

12,
63,
64,
0,

63,
64,
0,

63,
64,
0,

13,
63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

52,
63,
64,
0,

53,
63,
64,
0,

10,
63,
64,
0,

54,
63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

18,
63,
64,
0,

17,
63,
64,
0,

63,
64,
0,

63,
64,
0,

63,
64,
0,

6,
63,
64,
0,

11,
63,
64,
0,

63,
64,
0,

63,
64,
0,

19,
63,
64,
0,

16,
63,
64,
0,

7,
63,
64,
0,

63,
64,
0,

9,
63,
64,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,11,	1,12,	
3,11,	3,12,	11,11,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,11,	0,0,	3,11,	
3,13,	11,11,	0,0,	3,14,	
3,15,	3,16,	16,70,	3,17,	
3,18,	3,19,	3,20,	3,21,	
3,22,	3,23,	3,24,	3,25,	
3,26,	3,26,	3,26,	3,26,	
3,26,	3,26,	3,26,	3,26,	
3,26,	3,27,	3,28,	3,29,	
3,30,	3,31,	8,66,	9,67,	
3,32,	3,33,	3,34,	3,35,	
3,14,	3,14,	3,36,	3,14,	
3,37,	3,14,	3,14,	3,14,	
3,38,	3,39,	3,14,	3,40,	
3,14,	3,41,	3,42,	3,43,	
3,14,	3,14,	3,14,	3,14,	
3,14,	3,14,	10,67,	13,68,	
19,71,	20,72,	3,14,	22,73,	
3,44,	3,45,	3,14,	3,14,	
3,14,	3,14,	3,46,	3,14,	
3,14,	3,14,	3,14,	3,14,	
3,14,	3,14,	3,14,	3,47,	
3,14,	3,14,	3,14,	3,14,	
3,14,	3,14,	3,14,	3,14,	
3,14,	3,14,	3,48,	3,49,	
3,50,	3,51,	5,52,	25,78,	
25,78,	25,78,	25,78,	25,78,	
25,78,	25,78,	25,78,	25,26,	
25,26,	29,80,	29,81,	30,82,	
31,83,	31,84,	32,85,	33,86,	
5,53,	34,87,	5,14,	5,14,	
6,52,	35,88,	36,89,	37,90,	
5,14,	38,91,	39,92,	5,54,	
5,14,	5,14,	5,55,	40,93,	
41,94,	5,56,	5,57,	5,14,	
42,95,	43,96,	6,53,	25,79,	
6,14,	6,14,	44,97,	45,98,	
46,99,	7,64,	6,14,	47,100,	
5,58,	6,54,	6,14,	6,14,	
6,55,	7,65,	7,12,	6,56,	
6,57,	6,14,	49,101,	5,59,	
52,102,	53,85,	5,60,	54,104,	
55,105,	5,61,	5,62,	56,106,	
53,103,	57,107,	6,58,	25,79,	
58,97,	59,109,	60,110,	61,111,	
5,63,	62,112,	66,113,	58,108,	
7,64,	6,59,	67,114,	69,115,	
6,60,	85,118,	7,66,	6,61,	
6,62,	76,116,	86,119,	7,64,	
7,64,	7,64,	87,120,	88,121,	
89,122,	90,123,	6,63,	91,124,	
7,64,	92,125,	69,115,	93,126,	
14,14,	94,127,	95,128,	97,129,	
76,116,	7,64,	98,130,	99,131,	
100,126,	103,132,	14,14,	14,69,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	104,133,	105,134,	
106,135,	107,136,	108,137,	109,138,	
7,64,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	110,139,	
111,141,	110,140,	112,142,	14,14,	
118,143,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	14,14,	
14,14,	14,14,	14,14,	24,74,	
119,144,	120,145,	121,146,	122,147,	
123,148,	24,75,	124,149,	125,150,	
127,151,	24,74,	24,76,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	128,152,	129,153,	130,154,	
24,77,	131,155,	132,156,	133,157,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	134,158,	135,159,	
136,160,	137,161,	24,74,	138,162,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	24,74,	24,74,	
24,74,	24,74,	26,26,	26,26,	
26,26,	26,26,	26,26,	26,26,	
26,26,	26,26,	26,26,	26,26,	
74,74,	140,163,	141,164,	142,165,	
143,166,	144,167,	146,168,	147,169,	
149,170,	150,171,	74,74,	74,76,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	151,172,	152,173,	
153,166,	154,167,	155,169,	156,174,	
157,175,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	158,176,	
159,177,	160,178,	161,179,	74,74,	
162,180,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	74,74,	
74,74,	74,74,	74,74,	78,78,	
78,78,	78,78,	78,78,	78,78,	
78,78,	78,78,	78,78,	78,26,	
78,26,	79,117,	79,117,	79,117,	
79,117,	79,117,	79,117,	79,117,	
79,117,	79,117,	79,117,	163,181,	
164,177,	165,178,	170,182,	171,183,	
172,184,	173,185,	79,117,	79,117,	
79,117,	79,117,	79,117,	79,117,	
117,117,	117,117,	117,117,	117,117,	
117,117,	117,117,	117,117,	117,117,	
117,117,	117,117,	174,186,	175,187,	
176,139,	179,186,	180,187,	181,139,	
184,188,	117,117,	117,117,	117,117,	
117,117,	117,117,	117,117,	185,189,	
189,190,	0,0,	79,117,	79,117,	
79,117,	79,117,	79,117,	79,117,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	117,117,	117,117,	117,117,	
117,117,	117,117,	117,117,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+1,	0,		0,	
yycrank+0,	yysvec+1,	0,	
yycrank+3,	0,		0,	
yycrank+0,	yysvec+3,	0,	
yycrank+83,	yysvec+3,	0,	
yycrank+105,	yysvec+3,	0,	
yycrank+-176,	0,		0,	
yycrank+-24,	yysvec+7,	0,	
yycrank+-25,	yysvec+7,	0,	
yycrank+-52,	yysvec+7,	0,	
yycrank+5,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+34,	0,		yyvstop+5,
yycrank+200,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+10,
yycrank+4,	0,		yyvstop+12,
yycrank+0,	0,		yyvstop+14,
yycrank+0,	0,		yyvstop+16,
yycrank+35,	0,		yyvstop+18,
yycrank+36,	0,		yyvstop+20,
yycrank+0,	0,		yyvstop+22,
yycrank+38,	0,		yyvstop+24,
yycrank+0,	yysvec+14,	yyvstop+26,
yycrank+287,	0,		yyvstop+30,
yycrank+83,	yysvec+14,	yyvstop+33,
yycrank+362,	yysvec+14,	yyvstop+38,
yycrank+0,	0,		yyvstop+42,
yycrank+0,	0,		yyvstop+44,
yycrank+81,	0,		yyvstop+46,
yycrank+82,	0,		yyvstop+48,
yycrank+83,	0,		yyvstop+50,
yycrank+70,	yysvec+14,	yyvstop+52,
yycrank+71,	yysvec+14,	yyvstop+55,
yycrank+70,	yysvec+14,	yyvstop+58,
yycrank+70,	yysvec+14,	yyvstop+61,
yycrank+72,	yysvec+14,	yyvstop+64,
yycrank+77,	yysvec+14,	yyvstop+67,
yycrank+88,	yysvec+14,	yyvstop+70,
yycrank+79,	yysvec+14,	yyvstop+73,
yycrank+91,	yysvec+14,	yyvstop+76,
yycrank+95,	yysvec+14,	yyvstop+79,
yycrank+99,	yysvec+14,	yyvstop+82,
yycrank+83,	yysvec+14,	yyvstop+85,
yycrank+66,	yysvec+14,	yyvstop+88,
yycrank+67,	yysvec+14,	yyvstop+91,
yycrank+62,	yysvec+14,	yyvstop+94,
yycrank+75,	yysvec+14,	yyvstop+97,
yycrank+0,	0,		yyvstop+100,
yycrank+66,	0,		yyvstop+102,
yycrank+0,	0,		yyvstop+104,
yycrank+0,	0,		yyvstop+106,
yycrank+150,	yysvec+24,	yyvstop+108,
yycrank+117,	yysvec+14,	yyvstop+111,
yycrank+126,	yysvec+14,	yyvstop+114,
yycrank+114,	yysvec+14,	yyvstop+117,
yycrank+134,	yysvec+14,	yyvstop+120,
yycrank+121,	yysvec+14,	yyvstop+123,
yycrank+96,	yysvec+14,	yyvstop+126,
yycrank+104,	yysvec+14,	yyvstop+129,
yycrank+92,	yysvec+14,	yyvstop+133,
yycrank+110,	yysvec+14,	yyvstop+137,
yycrank+97,	yysvec+14,	yyvstop+140,
yycrank+0,	0,		yyvstop+144,
yycrank+0,	0,		yyvstop+147,
yycrank+0,	yysvec+11,	yyvstop+149,
yycrank+163,	0,		yyvstop+152,
yycrank+167,	0,		yyvstop+154,
yycrank+0,	0,		yyvstop+156,
yycrank+173,	yysvec+24,	yyvstop+158,
yycrank+0,	0,		yyvstop+160,
yycrank+0,	0,		yyvstop+162,
yycrank+0,	0,		yyvstop+164,
yycrank+0,	0,		yyvstop+166,
yycrank+384,	0,		yyvstop+168,
yycrank+0,	0,		yyvstop+170,
yycrank+179,	yysvec+24,	yyvstop+172,
yycrank+0,	0,		yyvstop+174,
yycrank+459,	yysvec+14,	yyvstop+176,
yycrank+469,	yysvec+14,	yyvstop+181,
yycrank+0,	0,		yyvstop+184,
yycrank+0,	0,		yyvstop+186,
yycrank+0,	0,		yyvstop+188,
yycrank+0,	0,		yyvstop+190,
yycrank+0,	0,		yyvstop+192,
yycrank+144,	yysvec+14,	yyvstop+194,
yycrank+143,	yysvec+14,	yyvstop+197,
yycrank+146,	yysvec+14,	yyvstop+200,
yycrank+158,	yysvec+14,	yyvstop+203,
yycrank+149,	yysvec+14,	yyvstop+206,
yycrank+159,	yysvec+14,	yyvstop+209,
yycrank+154,	yysvec+14,	yyvstop+212,
yycrank+157,	yysvec+14,	yyvstop+215,
yycrank+146,	yysvec+14,	yyvstop+218,
yycrank+166,	yysvec+14,	yyvstop+221,
yycrank+171,	yysvec+14,	yyvstop+224,
yycrank+0,	yysvec+14,	yyvstop+227,
yycrank+134,	yysvec+14,	yyvstop+231,
yycrank+131,	yysvec+14,	yyvstop+234,
yycrank+132,	yysvec+14,	yyvstop+237,
yycrank+123,	yysvec+14,	yyvstop+240,
yycrank+0,	0,		yyvstop+243,
yycrank+0,	0,		yyvstop+245,
yycrank+162,	yysvec+14,	yyvstop+247,
yycrank+180,	yysvec+14,	yyvstop+250,
yycrank+186,	yysvec+14,	yyvstop+253,
yycrank+182,	yysvec+14,	yyvstop+256,
yycrank+196,	yysvec+14,	yyvstop+259,
yycrank+147,	yysvec+14,	yyvstop+262,
yycrank+153,	yysvec+14,	yyvstop+265,
yycrank+188,	yysvec+14,	yyvstop+268,
yycrank+182,	yysvec+14,	yyvstop+271,
yycrank+197,	yysvec+14,	yyvstop+274,
yycrank+0,	0,		yyvstop+277,
yycrank+0,	0,		yyvstop+279,
yycrank+0,	0,		yyvstop+281,
yycrank+0,	0,		yyvstop+284,
yycrank+492,	yysvec+14,	yyvstop+286,
yycrank+225,	yysvec+14,	yyvstop+290,
yycrank+257,	yysvec+14,	yyvstop+293,
yycrank+236,	yysvec+14,	yyvstop+296,
yycrank+259,	yysvec+14,	yyvstop+299,
yycrank+242,	yysvec+14,	yyvstop+302,
yycrank+249,	yysvec+14,	yyvstop+305,
yycrank+251,	yysvec+14,	yyvstop+308,
yycrank+252,	yysvec+14,	yyvstop+311,
yycrank+0,	yysvec+14,	yyvstop+314,
yycrank+259,	yysvec+14,	yyvstop+318,
yycrank+261,	yysvec+14,	yyvstop+321,
yycrank+243,	yysvec+14,	yyvstop+324,
yycrank+248,	yysvec+14,	yyvstop+327,
yycrank+232,	yysvec+14,	yyvstop+330,
yycrank+277,	yysvec+14,	yyvstop+333,
yycrank+280,	yysvec+14,	yyvstop+336,
yycrank+307,	yysvec+14,	yyvstop+339,
yycrank+308,	yysvec+14,	yyvstop+342,
yycrank+298,	yysvec+14,	yyvstop+345,
yycrank+276,	yysvec+14,	yyvstop+348,
yycrank+280,	yysvec+14,	yyvstop+351,
yycrank+0,	yysvec+14,	yyvstop+355,
yycrank+318,	yysvec+14,	yyvstop+359,
yycrank+319,	yysvec+14,	yyvstop+362,
yycrank+309,	yysvec+14,	yyvstop+365,
yycrank+346,	yysvec+14,	yyvstop+368,
yycrank+350,	yysvec+14,	yyvstop+371,
yycrank+0,	yysvec+14,	yyvstop+374,
yycrank+342,	yysvec+14,	yyvstop+378,
yycrank+347,	yysvec+14,	yyvstop+381,
yycrank+0,	yysvec+14,	yyvstop+384,
yycrank+346,	yysvec+14,	yyvstop+388,
yycrank+364,	yysvec+14,	yyvstop+391,
yycrank+363,	yysvec+14,	yyvstop+394,
yycrank+370,	yysvec+14,	yyvstop+397,
yycrank+334,	yysvec+14,	yyvstop+400,
yycrank+338,	yysvec+14,	yyvstop+403,
yycrank+334,	yysvec+14,	yyvstop+406,
yycrank+376,	yysvec+14,	yyvstop+409,
yycrank+364,	yysvec+14,	yyvstop+412,
yycrank+402,	yysvec+14,	yyvstop+415,
yycrank+407,	yysvec+14,	yyvstop+418,
yycrank+408,	yysvec+14,	yyvstop+421,
yycrank+375,	yysvec+14,	yyvstop+424,
yycrank+364,	yysvec+14,	yyvstop+427,
yycrank+422,	yysvec+14,	yyvstop+430,
yycrank+427,	yysvec+14,	yyvstop+433,
yycrank+428,	yysvec+14,	yyvstop+436,
yycrank+0,	yysvec+14,	yyvstop+439,
yycrank+0,	yysvec+14,	yyvstop+443,
yycrank+0,	yysvec+14,	yyvstop+447,
yycrank+0,	yysvec+14,	yyvstop+451,
yycrank+441,	yysvec+14,	yyvstop+455,
yycrank+463,	yysvec+14,	yyvstop+458,
yycrank+454,	yysvec+14,	yyvstop+461,
yycrank+454,	yysvec+14,	yyvstop+464,
yycrank+472,	yysvec+14,	yyvstop+467,
yycrank+479,	yysvec+14,	yyvstop+470,
yycrank+474,	yysvec+14,	yyvstop+473,
yycrank+0,	yysvec+14,	yyvstop+476,
yycrank+0,	yysvec+14,	yyvstop+480,
yycrank+443,	yysvec+14,	yyvstop+484,
yycrank+450,	yysvec+14,	yyvstop+487,
yycrank+445,	yysvec+14,	yyvstop+490,
yycrank+0,	yysvec+14,	yyvstop+493,
yycrank+0,	yysvec+14,	yyvstop+497,
yycrank+473,	yysvec+14,	yyvstop+501,
yycrank+485,	yysvec+14,	yyvstop+504,
yycrank+0,	yysvec+14,	yyvstop+507,
yycrank+0,	yysvec+14,	yyvstop+511,
yycrank+0,	yysvec+14,	yyvstop+515,
yycrank+481,	yysvec+14,	yyvstop+519,
yycrank+0,	yysvec+14,	yyvstop+522,
0,	0,	0};
struct yywork *yytop = yycrank+594;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,'$' ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,'$' ,'/' ,
'0' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,
'8' ,'8' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'X' ,'$' ,'$' ,01  ,01  ,01  ,01  ,'$' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'X' ,'$' ,'$' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
