.TH XSET 1 "1 August 1987" "X Version 11"
.SH NAME
xset - X window system user setup program
.SH SYNOPSIS
.B xset
option [ option ] [ \fIhost\fP:\fIdisplay\fP ]
.SH DESCRIPTION
This program is used to set various user preference options of the display.
the \fBb\fP option controls bell volume, pitch and duration,
The \fBc\fP option controls key click,
the \fBfp\fP option sets the font path,
the \fBled\fP option controls the keyboard LEDs,
the \fBm\fP option controls the mouse parameters,
the \fBp\fP option controls pixel color values,
the \fBr\fP option controls the auto repeat,
the \fBs\fP option lets you set the screen saver parameters,
and the \fBq\fP option gives you information on the current settings.
Most of these can be preceded with a \fB-\fP to disable the feature,
or followed by \fBon\fP or \fBoff\fP if you prefer.  They can also be
given with no further specifications, to reset the system defaults.
For example: ``xset c on'' turns on keyclick;
``xset -r'' would turn off autorepeat;
``xset b'' sets the bell volume, pitch and duration to the defaults.
.PP
The bell option accepts up to three numerical parameters.  If none are
given, the system defaults will be used.  If only one is given, the
bell volume will be set to that value, as a percentage of its maximum.
Likewise, the second parameter specifies the bell pitch, in hertz, and
the third one specifies the duration in milliseconds.  Note that not
all hardware can vary the bell characteristics.  The X server will set
the characteristics of the bell as closely as it can to the user's
specifications.
.PP
The keyclick option also takes an optional value from 0 to 100 to
indicate volume, as a percentage of maximum.  The X server will set
the volume to the nearest value that the hardware can support.
.PP
The font path option should be followed by a comma-separated list of
(operating system dependent) directories.  To restore the default
font path, use \fBfp default\fP.
.PP
The LED controls are for turning on or off one or all of the LEDs.
A common LED which can be controlled is the ``Caps Lock'' LED.  ``xset
led 3'' would turn led #3 on.  ``xset -led 3'' would turn it off.
The particular LED values may refer to different LEDs on different
hardware.  Omitting the LED number in these commands would turn all of
the LEDs on or off, respectively.
.PP
The parameters for the mouse are ``acceleration'' and ``threshold''.
The mouse, or whatever pointer the machine is connected to, will go
``acceleration'' times as fast when it travels more than ``threshold''
pixels in a short time.  This way, the mouse can be used for precise
alignment when it is moved slowly, yet it can be set to travel across
the screen in a flick of the wrist when desired.  One or both
parameters for the ``m'' option can be omitted, but if only one is
given, it will be interpreted as the acceleration.
.PP
The parameters for a pixel are the color map entry number in decimal,
and a color specification.  The root window colors can be changed by
altering entries 0 and 1.  The map entry must not be a read-only color,
or an error will result.
.PP
The parameters for the screen saver function determines how long the
server must be inactive for screen saving to go on, and the period
to change the background pattern to avoid burn in.
The arguments are specified in seconds.  ``xset s blank'' sets the
preference to blank the video (if the hardware can do so) rather than
display a background pattern.  ``xset s noblank'' sets the
preference to display a pattern rather than blank the video.
.PP
These settings will be reset to default values when you log out.
.PP
Note that not all X implementations are guaranteed to honor all of these
options.
.SH AUTHOR
Copyright (c) 1985, 1986, 1987 by Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full copyright notice.
.br
Bob Scheifler, MIT Laboratory for Computer Science
David Krikorian, MIT Project Athena (X11 version)
.SH "SEE ALSO"
X(8C)
