#include <stdio.h>
#include <dos.h>
#include <time.h>
#include <alloc.h>
#include "h\filsys.h"

#define BLOCK_SIZ	512
#define S_READ		0x02
#define S_WRITE		0x03

#define BIOS_DISK	0x13
int heads=15;
int sectors=17;
unsigned long first_blk=0x38876L;	/* start of fs */
unsigned fs_siz;
int unit=0x80;

char s_buf [BLOCK_SIZ];
char *buf;

main()
	{
	int of,i,b;
	struct filsys *sublk=(struct filsys*)s_buf;
	if ((buf=farmalloc(128L*BLOCK_SIZ))==0)
		{
		fprintf (stderr,"No mem\n");
		exit(1);
		}
	printf ("\nDump UNIX filesystem to DOS\n\n");
	blk_io(1,S_READ,sublk);
	fs_siz=sublk->s_fsize;
	printf ("Size of filesys :%6u blocks\n",sublk->s_fsize);
	printf ("Number of inodes:%6u\n",sublk->s_isize*16);
	printf ("Last update     :%s\n",ctime(&sublk->s_time));
	if ((of=_creat("c:\dump.unx",0))<0)
		{
		perror ("open");
		exit(1);
		}
	printf ("Dumping ");
	for(i=0;i<fs_siz;i+=128)
		{
		if (!i&255)
			printf (".");
		for (b=0;b<128;b++)
			blk_io(i,S_READ,buf+b*BLOCK_SIZ);
		if (write (of,s_buf,128*BLOCK_SIZ)!=128*BLOCK_SIZ)
			{
			perror("write");
			exit(1);
			}
		}

	close (of);
	farfree (buf);
	printf ("\nDump done.\n");
	}
blk_io(rblk,mode,buf)
unsigned int rblk,mode;
char *buf;
	{
	unsigned int cyl,sec,hed;
	unsigned long blk;
	static union REGS regs;

	blk=rblk+first_blk;
	cyl = (int)(blk / (heads * sectors));
	sec = (int)(blk % sectors)+1;
	hed = (int)(blk % (heads * sectors)) / sectors;
	regs.h.ah = mode;
	regs.h.dl = unit;
	regs.h.dh = hed;
	regs.h.ch = cyl & 0xff;
	regs.h.cl = (sec & 0x3f) + ((cyl >> 2) & 0xc0);
	regs.h.al = 1;
	regs.x.bx = (int)buf;
	_ES 	  = _DS;
	int86 (BIOS_DISK,&regs,&regs);
	if (regs.x.cflag) 
		error(regs.h.ah);
	}
error(code)
char code;
	{
	fprintf(stderr,"I/O error: %u\n",code);
	exit(1);
	}
