/*	tty.c
 *	common tty routines
 *
 *	(c) AT&T and Szigeti Szabolcs 1992
 */

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\tty.h"
#include "h\conf.h"
#include "h\inode.h"
#include "h\file.h"
#include "h\systm.h"

void sgtty (int*);
struct cblock cfree[NCLIST];
struct cblock *cfreelist=NULL;
int nchrdev;
char canonb[CANBSIZ];
/*
 * character table for uppercase terminals, where entry is non-null
 * the character is escaped by prepending a '\\'
 */
char	maptab[]=
{
	000,000,000,000,004,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,'|',000,'#',000,000,000,'`',
	'{','}',000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	'@',000,000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,000,000,'~',000,
	000,'A','B','C','D','E','F','G',
	'H','I','J','K','L','M','N','O',
	'P','Q','R','S','T','U','V','W',
	'X','Y','Z',000,000,000,000,000,
	};
/*
 * parity and special character table
 */
char partab[] ={

/*	NULL ^A   ^B   ^C   ^D   ^E   ^F   BELL		*/
	0001,0201,0201,0001,0201,0001,0001,0201,
/*      BS   TAB  LF   ^K   FF   CR   ^N   ^O		*/
	0202,0004,0003,0205,0005,0206,0201,0001,
/*      ^P   ^Q   ^R   ^S   ^T   ^U   ^V   ^W		*/
	0201,0001,0001,0201,0001,0201,0201,0001,
/*      ^X   ^Y   ^Z   ESC  ^/   ^]   ^^   ^_		*/
	0001,0201,0201,0001,0201,0001,0001,0201,
/*      SPC  !    "    #    $    %    &    '		*/
	0200,0000,0000,0200,0000,0200,0200,0000,
/*	(    )    *    +    ,    -    .    /		*/
	0000,0200,0200,0000,0200,0000,0000,0200,
/*	0    1	  2    3    4    5    6    7		*/
	0000,0200,0200,0000,0200,0000,0000,0200,
/*      8    9    :    ;    <    =    >    ?		*/
	0200,0000,0000,0200,0000,0200,0200,0000,
/*      @    A    B    C    D    E    F    G		*/
	0200,0000,0000,0200,0000,0200,0200,0000,
/*      H    I    J    K    L    M    N    O		*/
	0000,0200,0200,0000,0200,0000,0000,0200,
/*      P    Q    R    S    T    U    V    W		*/
	0000,0200,0200,0000,0200,0000,0000,0200,
/*	X    Y    Z    [    \    ]    `    _		*/
	0200,0000,0000,0200,0000,0200,0200,0000,
/*	     a    b    c    d    e    f    g		*/
	0000,0200,0200,0000,0200,0000,0000,0200,
/*      h    i    j    k    l    m    n    o    	*/
	0200,0000,0000,0200,0000,0200,0200,0000,
/*	p    q    r    s    t    u    v    w		*/
	0200,0000,0000,0200,0000,0200,0200,0000,
/*	x    y    z    {    |    }    ~    DEL          */
	0000,0200,0200,0000,0200,0000,0000,0201
};



/*
 * gtty syscall
 */
void gtty(fp,up)
register word up;
int fp;
	{
	int v[3];
	register int *vp;

	vp=v;
	u->u_rv=fp;
	sgtty(vp);
	if (u->u_error)
		return;
	suword(up++,*vp++);
	suword(up++,*vp++);
	suword(up,*vp);
	}
/*
 * stty syscall
 */
void stty(fp,up)
register word up;
int fp;
	{
	u->u_rv=fp;
	u->u_aux[0]=fuword(up++);
	u->u_aux[1]=fuword(up++);
	u->u_aux[2]=fuword(up);
	sgtty(0);
	}
/*
 * common part of gtty/stty
 */
void sgtty(v)
int *v;
	{
	register struct file *fp;
	register struct inode *ip;

	if ((fp=getf(u->u_rv))==NULL)
		return;
	ip=fp->f_inode;
	if((ip->i_mode&IFMT)!=IFCHR)
		{
		u->u_error=ENOTTY;
		return;
		}
	(*cdevsw[major(ip->i_addr[0])].d_sgtty)(ip->i_addr[0],v);
	}
/*
 * initialize clists and char devices
 */
void cinit(void)
	{
	register int ccp;
	register struct cblock *cp;
	struct cdevsw	*cdp;

	ccp = (int)cfree;		/* clist must begin on CROUND	*/
	ccp = (ccp+CROUND) & ~CROUND;	/* byte boundary		*/
	for(cp=(struct cblock *)ccp; cp < &cfree[NCLIST-1]; cp++)
		{
		cp->c_next = cfreelist;
		cfreelist = cp;
		}
	ccp=0;

	for(cdp=cdevsw;cdp->d_open;cdp++)
		ccp++;

	nchrdev=ccp;
	}



/*
 * flush tty's queues
 */

void flushtty(tp)
register struct tty *tp;
	{
	register word save;

	while (getc(&tp->t_canq)>=0);
	while (getc(&tp->t_outq)>=0);
	tp->t_state&=~(STOP|ASLEEP|7);
	wakeup((int)(&tp->t_rawq));
	wakeup((int)(&tp->t_outq));

	save=lock1();
	while (getc(&tp->t_rawq)>=0);
	tp->t_delct=0;
	unlock(save);
	}
/*
 * transform raw input into canonical
 */

canon(tp)
register struct tty *tp;
	{
	register char *bp;
	char *bp1;
	int c;

	lock();

	while(tp->t_delct==0)			/* wait for input	*/
		{
		if ((tp->t_state&CARR_ON)==0)
			return(0);
		sleep((int)&tp->t_rawq,TTIPRI);
		}
	enable();

LOOP:
	bp=&canonb[2];
	while ((c=getc(&tp->t_rawq))>=0)
		{
		if (c==0377)
			{
			tp->t_delct--;
			break;
			}
		if ((tp->t_flags&RAW)==0)
			{
			if (bp[-1]!='\\')		/* not escaped	*/
				{
				if (c==tp->t_erase)	/* erase max to BOL*/
					{
					if (bp>&canonb[2])
						bp--;
					continue;
					}
				if (c==tp->t_kill)	/* kill line	*/
					goto LOOP;
				if (c==CEOT)		/* ^D		*/
					continue;
				}
			else				/* upeercase terms*/
				if (maptab[c]&&(maptab[c]==c||
						(tp->t_flags&LCASE)))
					{
					if (bp[-2]!='\\')
						c=maptab[c];
					bp--;
				}
			}
		*bp++=c;
		if (bp>canonb+CANBSIZ)
			break;
	}
	bp1=bp;
	bp=&canonb[2];			/* transfer to canonical queue	*/
	while (bp<bp1)
		putc(*bp++,&tp->t_canq);
	return(1);
	}
/*
 * put incoming chars to clists
 */

void ttyinput(c,tp)
register int c;
register struct tty *tp;
	{
	int t_flags;

#ifdef DEBUG
	if (c=='~')
	{dumpp();return;}
#endif /* DEBUG */

	t_flags=tp->t_flags;
	if ((c&=0177)=='\r' && t_flags&CRMOD)		/* CR+LF mode	*/
		c='\n';
	if (c==CINTR || (c==CQUIT && (t_flags & RAW)==0))
		{
		signal (tp,c==CINTR? SIGINT : SIGQIT);
		flushtty(tp);
		return;
		}

	if (tp->t_rawq.c_cc>=TTYHOG)
		{
		flushtty(tp);
		return;
		}
	if ((t_flags&RAW)==0)
		{
		if (c=='S'-64)			/* stop output		*/
			{
			tp->t_state|=STOP;
			return;
			}
		if (c=='Q'-64)			/* resume output	*/
			{
			tp->t_state&=~STOP;
			wakeup((int)(&tp->t_outq));
			ttstart(tp);
			return;
			}
		if (c==tp->t_erase)		/* BS			*/
			{
			putc('\b',&tp->t_outq);
			putc(' ' ,&tp->t_outq);
			}
		}
	if (t_flags&LCASE && c>='A' && c<='Z')	/* ucase terminals	*/
		c+= 'a'-'A';
	putc(c,&tp->t_rawq);
	if (t_flags&RAW || c=='\n' || c==004)	/* end of line 		*/
		{
		wakeup((int)(&tp->t_rawq));
		if (putc(0377,&tp->t_rawq)==0)
			tp->t_delct++;
		}
	if (t_flags&ECHO)
		{
		ttyoutput(c,tp);
		ttstart(tp);
		}

	}

/*
 * put chars to output queue, may call itself
 * called from it and system level
 */

void ttyoutput(c,rtp)
register int c;
register struct tty *rtp;

	{
	char *colp;
	int ctype;

	c&=0177;

	if (c==004 && (rtp->t_flags&RAW)==0)
		return;
	if (c=='\t' && rtp->t_flags&XTABS)	/* xpand tabs to spaces	*/
		{
		do
			{
			if (rtp->t_state&SELFPOS)
				rtp->t_colp++;
			else
				ttyoutput(' ',rtp);
			}
		while (rtp->t_colp&07);
		return;
		}
	if (rtp->t_flags&LCASE)			/* escape som chars 	*/
		{
		colp = "({)}!|^~'`";
		while (*colp++)
			if (c==*colp++)
				{
				ttyoutput('\\',rtp);
				c=colp[-2];
				break;
				}
			if ('A'<=c && c<='Z')
				ttyoutput('\\',rtp);
			else
			if ('a'<=c && c<='z')
				c+='A'-'a';
		}
	if (c=='\n' && rtp->t_flags&CRMOD)
		ttyoutput('\r',rtp);

	if (putc(c,&rtp->t_outq))
		return;
	colp = &rtp->t_colp;
	ctype = partab[c];
	c=0;
	if ((rtp->t_state&SELFPOS)==0)		/* calculate pos in line*/
	switch (ctype&077)
		{
		case 0:
			(*colp)++;
		case 1: break;
		case 2:
			if (*colp)
				(*colp)--;
			break;
		case 3:
			ctype = (rtp->t_flags >> 8) & 03;
			if(ctype == 1)
				{ /* tty 37 */
				if (*colp)
					c = max((*colp>>4) + 3, 6);
				}
			else
			if(ctype == 2)
				{ /* vt05 */
				c = 6;
				}
			*colp = 0;
			break;
		case 4:
			ctype=(rtp->t_flags>>10)&03;
			if (ctype==1)
				{
				c=1-(*colp|~07);
				if (c<5)
					c=0;
				}
			*colp |=07;
			(*colp)++;
			break;
		case 5:
			if (rtp->t_flags&VTDELAY)
				c=0177;
			*colp=0;
		case 6:
			ctype=(rtp->t_flags>>12)&03;
			if (ctype==1)
				{
				c=5;
				}
			else
			if (ctype==2)
				{
				c=10;
				}
			*colp=0;
		}
	if (c)				/* delay		*/
		putc(c|0200,&rtp->t_outq);

	}
/*
 * restart after timeout
 */
void ttrstrt(tp)
register struct tty *tp;
	{
	tp->t_state&= ~TIMEOUT;
	ttstart(tp);
	}
/*
 * start output on a tty
 */

void ttstart(tp)
register struct tty *tp;
	{
	if (tp->t_state&SSTART)
		{
		(*(tp->t_addr))(tp);
		return;
		}
	}
/*
 * read tty
 */
void ttread(tp)
register struct tty *tp;
	{
	if ((tp->t_state&CARR_ON)==0)
		return;

	if (tp->t_canq.c_cc||canon(tp))
		while (tp->t_canq.c_cc && passc(getc(&tp->t_canq))>=0);
	}

/*
 * write to a tty
 */
void ttwrite(tp)
register struct tty *tp;
	{
	register int c;

	if ((tp->t_state&CARR_ON)==0)
		return;
	while ((c=cpass())>=0)

		{
		lock();
		while (tp->t_outq.c_cc>TTHIWAT||(tp->t_state&STOP))
			{
			ttstart(tp);
			tp->t_state|=ASLEEP;
			sleep((int)(&tp->t_outq),TTOPRI);
			}
		enable();
		ttyoutput(c,tp);
		}
	ttstart(tp);
	}
/*
 * sgtty on a tty
 */
ttysgtty(tp,v)
register struct tty *tp;
register int *v;
	{
	if (v)  	/* gtty */
		{
		*v++=tp->t_speeds;
		*v=((word)tp->t_kill<<8)+tp->t_erase;
		v[1]=tp->t_flags;
		return(1);
		}
	v=&u->u_aux[0];
	tp->t_speeds =*v++;
	tp->t_erase   = (*v)&0377;
	tp->t_kill   = (*v>>8)&0377;
	tp->t_flags  = v[1];
	return(0);
	}