/*	hd.c
 *	IBM AT IDE hard disk driver
 *
 *	(c) Szigeti Szabolcs 1992
 *
 *		minor device : 0 -> unix part  	( block and raw dev )
 *			       1 -> partiton #1	( block and raw dev )
 *			       2 -> partiton #2 ( block and raw dev )
 *			       3 -> partiton #3	( block and raw dev )
 *			       4 -> partiton #4 ( block and raw dev )
 */

/* TODO: (1) tidy code
 *       (2) autoconfigure parameters, from CMOS
 *	 (3) install non UNIX partitions
 *	 (4) security hole at raw, long r/w could go into next partition
 */

/*
	unix particios tabla felepitese:

offset 0	word	magic word 0x13ab
offset 2	byte[14] reserved
offset 16	long	part 1 block offset unix particiotol-tol
offset 20	word	part 1 meret blokkokban vagy 0 ha nem letezik
offset 22	word	fill
offset 24	long	part 2 offset
offset 28	word	part 2 meret
offser 30	word	fill
offset 32	long	part 3 offset
offset 36	word	part 3 meret
offset 38	word	fill
offset 40	long	part 4 offset
offset 44	word	part 4 meret
offset 46	word	fill
offset 48	char [16] hd tipus	 text, opcionalis
offset 64	end

									*/
#include "h\types.h"
#include "h\param.h"
#include "h\proc.h"
#include "h\user.h"
#include "h\conf.h"
#include "h\buf.h"
#include "h\systm.h"
#include "h\machine.h"

/*#define HDBUG*/ 	/*	Enable debug info	*/

#define	MAJOR	(0)
#define NUNIT 	5

#define PMAGIC	0x13ab	/*	Partition table magic word	*/
#define IBMPAROFF 0x1be
#define IBMPARSIZ 0x10
#define IBMRELBEG	0x8
#define IBMSIZ		0xc
#define IBMSYS		0x4

#define UNIXID		2	/* ua mint a XENIX flag */
#define UNIXPOFFS	0x1b0   /* unix part offset	*/


#define HD_READ		0x20	/* olvasasi parancs	*/
#define HD_WRITE        0x30	/* irasi parancs	*/
#define SEC_SIZ		512

#define READ	1
#define	WRITE	4
#define RECAL	2
#define RESET	3
#define	NO	0

#define HDREG1	0x1f0
#define HDREG2	0x1f1
#define HDREG3	0x1f2
#define HDREG4	0x1f3
#define HDREG5	0x1f4
#define HDREG6	0x1f5
#define HDREG7	0x1f6
#define HDREG8	0x1f7
#define HDREG9	0x3f6

struct devtab hdtab;
struct buf hdbuf;
struct hdpart
	{
	int magic;
	byte reserv[14];
	struct {
		dword offs;
		word siz;
		word fill;
	       } entry[NUNIT-1];	/* Az elso meret a fo particio */
	char name[16];
	};
		
struct 	{
	long maxblk;
	int  heads;
	int  sectors;
	dword offs;
	int precomp;
	int stepopt;
	char physdev;
	}
	hdpar[NUNIT];
byte hdprg[9];

static word actdev,cyl,sec,head,cnt,mod,totrs,inited=0;
char *dpo,ndrst;
static dword blk,addr;
extern struct sys_desc hddesc1;

#define HDSEL U_LDT+2*NPROC*8+8

hdopen(dev,flag)
int dev,flag;
	{
	if (!inited)
		if(hdinit()!=0)
			{
			u->u_error=EIO;
			return;
			}
		else
			{
			inited=1;
			}

	dev=minor(dev);
	if (hdpar[dev].maxblk==0||dev>=NUNIT)
		{
		u->u_error=ENXIO;
		return;
		}

	}
hdclose(dev,flag)
int dev,flag;
	{
	}


hdstrategy(bp)
register struct buf *bp;
	{
	register word save;
	
	if(minor(bp->b_dev)>=NUNIT ||
		 bp->b_blkno>=hdpar[minor(bp->b_dev)].maxblk)
		{
		bp->b_flags|=B_ERROR;
		iodone(bp);
		return;
		}
	bp->av_forw=0;
	save=lock1();
	if (hdtab.d_actf==0)
		hdtab.d_actf=bp;
	else
		hdtab.d_actl->av_forw=bp;
	hdtab.d_actl=bp;
	unlock(save);
	if (hdtab.d_active==0)
		hdstart();
	}

hdstart()
	{
	register struct buf *bp;
	register int dev;

	if ((bp=hdtab.d_actf)==0)
		{
		return;
		}
	actdev=dev=minor(bp->b_dev);
	cnt=-bp->b_wcount*2;
	blk=hdpar[dev].offs+bp->b_blkno;
	addr=bp->b_xmem+(word)(bp->b_addr);
	mod =(bp->b_flags&B_READ) ? B_READ : B_WRITE;

	hdtab.d_errcnt=0;

	dpo = 0;
	hddesc1.limit=cnt;
	hddesc1.base_l=(word)(addr&0xffff);
	hddesc1.base_h=(addr>>16)&0xff;

	hdistart();
	}
hdistart()
	{
	cyl=(int)(blk / (hdpar[actdev].heads * hdpar[actdev].sectors));
	sec=(int)(blk % hdpar[actdev].sectors)+1;
	head=(int)(blk % (hdpar[actdev].heads*hdpar[actdev].sectors))
			/hdpar[actdev].sectors;
	totrs=(cnt<SEC_SIZ)?cnt:SEC_SIZ; /* egyszerre max 1 sector	*/
	hdpstart();

	return;
	}
hdbsyw()
	{
	register int i,r;
	for (i=0,r=255;i<1000 &&(r&0x80)!=0;i++)
		r=inbyte(HDREG8);
	if ((r&0x80)!=0||(r&0x40)==0||(r&0x10)==0)
		{
		ndrst=1;
		return(-1);
		}
	return(0);                                  
	}
hdpstart()
	{
	word save;
	register int i,r=0;

	hdprg[0]=hdpar[actdev].stepopt;
	hdprg[1]=hdpar[actdev].precomp;
	hdprg[2]=1;	/* sector count */
	hdprg[3]=sec;
	hdprg[4]=cyl&0xff;
	hdprg[5]=(cyl&0x0300)>>8;
	hdprg[6]=((hdpar[actdev].physdev)<<4)|head|0xa0;
	hdprg[7]=(mod==B_READ)?HD_READ:HD_WRITE;

	if(hdprog())
		return;
	hdtab.d_active=READ;
	if (mod==B_READ)  
		return(0);

	hdtab.d_active=WRITE;
	for(i=0;i<1000 && (r&8)==0;i++)
		r=inbyte(HDREG8);
	if ((r&8)==0)
		{
		ndrst=1;
		return(-1);
		}
		wiwrite(HDSEL,dpo,totrs>>1,SEC_SIZ>>1);

	return(0);
	}
hdint()
	{
	register struct buf *bp=hdtab.d_actf;
	register word save;

	intack1();
	intack2();
	enable();

	save=hdtab.d_active;
	hdtab.d_active=0;

	switch (save)
		{
		case READ:	
				wiread(HDSEL,dpo,totrs>>1,SEC_SIZ>>1);
		case WRITE:
				if (hdstatus())
					{
					ndrst=1;
					hderror();
					return;
					}
				cnt-=totrs;
				dpo+=totrs;
				blk++;
				if(cnt<=0)
					{
					lock();
					hdtab.d_actf=hdtab.d_actf->av_forw;
					iodone(bp);
					enable();
					hdstart();
					}
				else
					hdistart();
				break;
		default:	prdev("Unexpected it",actdev|MAJOR<<8);
		}
	return;
	}

hdprog()
	{
	register int i,r;
	word save;

	if (hdbsyw())
		{
		hderror();
		return(-1);
		}
	r=HDREG2;
	save=lock1();
	for (i=1;i<8;i++,r++)
		outbyte(r,hdprg[i]);
	unlock(save);
	return(0);
	}
hderror()
	{
	register struct buf *bp=hdtab.d_actf;
	register word save;
	if(++hdtab.d_errcnt>9)
		{
		prdev("General error",actdev|MAJOR<<8);
		save=lock1();
		bp->b_flags|=B_ERROR;
		bp->b_resid=-bp->b_wcount-cnt;
		iodone (bp);
		hdtab.d_actf=hdtab.d_actf->av_forw;
		unlock(save);
		hdstart();
		return;
		}
	hdpstart();
	}
hdstatus()
	{
	register int r;

	r=inbyte(HDREG8);
	if ((r&0x80) !=0)
		return (0);
	if ((r&0x40)==0||(r&0x20)!=0||(r&0x10)==0||(r&1)!=0)
		{
		if ((r&01)!=0)
			r=inbyte(HDREG2);
		return(-1);
		}
	return(0);
	}

hdinit()
	{
	register int i;
	register struct hdpart *pt;
	struct buf *bp;
	int c;
	long upar;
	for (i=0;i<NUNIT;i++)
		{
		hdpar[i].maxblk=0;
		hdpar[i].heads=15;
		hdpar[i].sectors=17;
		hdpar[i].offs=0;
		hdpar[i].precomp=0;
		hdpar[i].stepopt=8;
		hdpar[i].physdev=0;
		}
	hdpar[0].maxblk=2;
	if((bp=(struct buf*)bread(0|MAJOR<<8,0))==NULL)
		return(-1);
	c=0;
	for (i=IBMPAROFF;i<(IBMPAROFF+4*IBMPARSIZ);i+=IBMPARSIZ)
		{
		if(*(bp->b_addr+i+IBMSYS)==UNIXID)
			{
			c=i;
			break;
			}
		}
		if (c==0)
			{
			prdev("No unix partition",MAJOR<<8|0);
			brelse(bp);
			return(-1);
			}
	upar=*(long*)(bp->b_addr+i+IBMRELBEG);
	c=*(int*)(bp->b_addr+i+IBMSIZ);
	hdpar[0].maxblk=c; 	/* minor dev 0 a teljes unix particio 	*/
	hdpar[0].offs=upar;	/* ahol blkno 0 a particios tabla	*/
	bp->b_flags|=B_ERROR;	/* kenyszeritjuk az ujraolvasast	*/
				/* KLUDGE !!! */
	brelse (bp);
	if ((bp=(struct buf*)bread(0|MAJOR<<8,0))==NULL)
		{
		prdev("Unable to read partition table",MAJOR<<8|0);
		return (-1);
		}
	pt=(struct hdpart*)(bp->b_addr+UNIXPOFFS);
	c=0;
	if (pt->magic!=PMAGIC)
		{
		prdev("Bad partition table",MAJOR<<8|0);
		}
	else	
		{
		for (i=1;i<NUNIT;i++)
			{
			if((hdpar[i].maxblk=pt->entry[i-1].siz)!=0) c++;
			hdpar[i].offs=hdpar[0].offs+pt->entry[i-1].offs;
#ifdef HDBUG
printf ("partition #%u  at %X, size: %u\n",i,hdpar[i].offs,hdpar[i].maxblk);
#endif
			}
#ifdef HDBUG
		printf("Hard drive: %s with %u UNIX partition\n",pt->name,c);
#endif
		}
	brelse (bp);
	return(0);
	}

hdread(dev)
	{
	physio(hdstrategy,&hdbuf,dev,B_READ);
	}
hdwrite(dev)
	{
	physio(hdstrategy,&hdbuf,dev,B_WRITE);
	}
hdsgtty(dev)
	{
	}