/*      co.c
 *	IBM console driver
 *
 *	(c) Szigeti Szabolcs 1992
 *
 *		minor device : 0 -> console ( char dev )
 */

/*
 * TODO : (1) tidy code
 *	  (2) autoconfigure video card type ( mono or color )
 *	  (3) keyboard driver is screwed up
 */

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\proc.h"
#include "h\machine.h"
#include "h\tty.h"
#include "h\systm.h"

#define NUNIT	1
#define MAJOR   0

struct tty coat;

/*	kiiras a konzolra, egyedi kiirorutin, nem interrupt vezerelt	*/

costart(tp)
register struct tty *tp;
	{
	register int c;

	while((c=getc(&tp->t_outq))>=0)
		{
		coout(c);
		}
	return(1);
	}

/*	konzolt megnyitjuk, alapertelmezeseket beallitjuk		*/

coopen(dev,flag)
int dev,flag;

	{
	register struct tty *tp;
	static int inited=0;

	if (!inited)
		{
		tp->t_dev=(MAJOR<<8)|dev;
		inited=1;
		}
	if (minor(dev)>=NUNIT)
		{
		u->u_error=ENXIO;
		return;
		}
	tp=&coat;
	if (cup->p_ttyp==NULL)
		{
		cup->p_ttyp=tp;
		}
	if((tp->t_state&ISOPEN)==0)
		{
		tp->t_state=ISOPEN|CARR_ON|SSTART|SELFPOS;
		tp->t_flags=XTABS|ECHO|CRMOD;
		tp->t_addr=costart;
		tp->t_kill='@';
		tp->t_erase='\b';
		}
	}

/*	konzolt lezarjuk						*/

coclose(dev)
int dev;
	{
	register struct tty *tp;

	tp=&coat;
	flushtty(tp);
	tp->t_state=0;
	}

coread(dev)
int dev;
	{
	ttread(&coat);
	}

cowrite(dev)
int dev;
	{
	register int c;
	while ((c=cpass())>=0)
		{
		lock();
		if (coat.t_state&STOP)
			{
			sleep((int)&coat.t_outq,TTOPRI);
			}
		enable();	
		ttyoutput(c,&coat);
		costart(&coat);
		}
	}

cosgtty(dev,v)
register dev,*v;
	{
	ttysgtty (&coat,v);

	}
				