/*
 * Memory management stuff
 *
 *	Bits for 68030 mmu
 *	Logical address are in the following format:
 *
 *		+-------+--------------+--------+
 *		| seg   |   page       | offset |
 *		+-------+--------------+--------+
 *		   (8)       (15)         (9)
 *	There is a single segment table and no page tables.
 *	Each segment table entry is marked early exit.  In
 *	this way the MMU can create the pte without going to memory.
 *	
 *	The system address space is divided into eight segments, each
 *	16MBs long.
 *		TEXTSEG		Instructions go here, and maybe data.
 *		DATASEG		Data go here, if pure text.
 *		STACKSEG	The stack segment grows down.
 *		MESGSEG		The Adaptive message space (YTBD).
 *		USERSEG		The famous u page.
 *		KERNELSEG	All of the physical memory is here.
 *		KNOCACHE	Same as KERNELSEG except no caching.
 *
 * 	Pagesize is 512
 *	Segment size is 16 Megabytes.
 */

#define	SEGSIZE	(btoc(16 * 1024 * 1024))
#define	TX	1
#define	ED	0x8000
#define	RO	4
#define	RW	0

struct	segment	{		/* segment entries.  See '030  manual */
	u_short	limit;		/* how many pages in this segment */
	u_short	status;		/* various control/status bits */
	long	addr;		/* page address */
};

/*
 * Index into segment table.
 */

#define	TEXTSEG		0000
#define	DATASEG		0001
#define	STACKSEG	0002
#define	MESGSEG		0003
#define	UPAGESEG	0004
#define	KERNELSEG	0200
#define	KNOCACHE	0201		/* kernel - no cache */
#define	MBUFSEG		0202		/* mbufs  - no cache */
#define	IOSEG		0377		/* io segment */
