#include "param.h"
#include "systm.h"

/*
 * This table is the switch used to transfer
 * to the appropriate routine for processing a system call.
 * Each row contains the number of arguments expected
 * and a pointer to the routine.
 */

int	alarm();
int	chdir();
int	chmod();
int	chown();
int	chroot();
int	select();
int	close();
int	creat();
int	dup();
int	exec();
int	exece();
int	fork();
int	fstat();
int	ftime();
int	getgid();
int	getpid();
int	getuid();
int	gtime();
int	gtty();
int	ioctl();
int	kill();
int	msgbind();
int	msgsend();
int	smsgrecv();
int	getsid();
int	setruid();
int	link();
int	mknod();
int	nice();
int	nosys();
int	nullsys();
int	open();
int	pause();
int	pipe();
int	profil();
int	msgfree();
int	ptrace();
int	read();
int	reboot();
int	setsid();
int	rexit();
int	saccess();
int	sbreak();
int	seek();
int	setgid();
int	setpgrp();
int	smsgalloc();
int	setuid();
int	smount();
int	ssig();
int	syslock();
int	stat();
int	stime();
int	stty();
int	sumount();
int	sync();
int	sysacct();
int	times();
int	umask();
int	unlink();
int	utime();
int	wait();
int	waitpid();
int	write();

struct sysent sysent[] =
{
	0, 0, nosys,			/*  0 = indir */
	1, 0, rexit,			/*  1 = exit */
	0, 0, fork,			/*  2 = fork */
	3, 0, read,			/*  3 = read */
	3, 0, write,			/*  4 = write */
	3, 0, open,			/*  5 = open */
	1, 0, close,			/*  6 = close */
	0, 0, wait,			/*  7 = wait */
	2, 0, creat,			/*  8 = creat */
	2, 0, link,			/*  9 = link */
	1, 0, unlink,			/* 10 = unlink */
	2, 0, exec,			/* 11 = exec */
	1, 0, chdir,			/* 12 = chdir */
	0, 0, gtime,			/* 13 = time */
	3, 0, mknod,			/* 14 = mknod */
	2, 0, chmod,			/* 15 = chmod */
	3, 0, chown,			/* 16 = chown; now 3 args */
	1, 0, sbreak,			/* 17 = break */
	2, 0, stat,			/* 18 = stat */
	3, 0, seek,			/* 19 = seek */
	0, 0, getpid,			/* 20 = getpid */
	3, 0, smount,			/* 21 = mount */
	1, 0, sumount,			/* 22 = umount */
	1, 0, setuid,			/* 23 = setuid */
	0, 0, getuid,			/* 24 = getuid */
	1, 0, stime,			/* 25 = stime */
	4, 0, ptrace,			/* 26 = ptrace */
	1, 0, alarm,			/* 27 = alarm */
	2, 0, fstat,			/* 28 = fstat */
	0, 0, pause,			/* 29 = pause */
	2, 0, utime,			/* 30 = utime */
	2, 0, stty,			/* 31 = stty */
	2, 0, gtty,			/* 32 = gtty */
	2, 0, saccess,			/* 33 = access */
	1, 0, nice,			/* 34 = nice */
	1, 0, ftime,			/* 35 = ftime; formerly sleep */
	0, 0, sync,			/* 36 = sync */
	2, 0, kill,			/* 37 = kill */
	1, 0, msgbind,			/* 38 = msgbind */
	4, 0, setpgrp,			/* 39 = setpgrp */
	1, 0, smsgalloc,		/* 40 = msgalloc */
	2, 0, dup,			/* 41 = dup */
	0, 0, pipe,			/* 42 = pipe */
	1, 0, times,			/* 43 = times */
	4, 0, profil,			/* 44 = prof */
	1, 0, msgfree,			/* 45 = msgfree */
	1, 0, setgid,			/* 46 = setgid */
	0, 0, getgid,			/* 47 = getgid */
	2, 0, ssig,			/* 48 = sig */
	1, 0, reboot,			/* 49 = restart system */
	2, 0, setsid,			/* 50 = setsid */
	1, 0, sysacct,			/* 51 = turn acct off/on */
	3, 0, waitpid,			/* 52 = waitpid */
	1, 0, syslock,			/* 53 = lock in core */
	3, 0, ioctl,			/* 54 = ioctl */
	2, 0, msgsend,			/* 55 = msgsend */
	2, 0, smsgrecv,			/* 56 = smsgrecv */
	1, 0, getsid,			/* 57 = getsid */
	1, 0, setruid,			/* 58 = set real uid */
	3, 0, exece,			/* 59 = exece */
	1, 0, umask,			/* 60 = umask */
	1, 0, chroot,			/* 61 = chroot */
	0, 0, nosys,			/* 62 = x */
	4, 0, select,			/* 63 = select */
};

/*
 * This array can be useful when you want to debug kernel calls.
 */

char *sysnames[] = {
	"nosys", "exit", "fork", "read", "write", "open", "close",
	"wait", "creat", "link", "unlink", "exec", "chdir", "gtime",
	"mknod", "chmod", "chown", "sbreak", "stat", "seek", "getpid",
	"mount", "umount", "setuid", "getuid", "time", "ptrace", "alarm",
	"fstat", "pause", "utime", "stty", "gtty", "access", "nice",
	"ftime", "sync", "kill", "msgbind", "setpgrp", "smsgalloc", "dup", 
	"pipe", "times", "profil", "msgfree", "setgid", "getgid", "ssig",
	"reboot", "setsid",
	"sysacct", "waitpid", "syslock", "ioctl", "msgsend", "smsgrecv",
	"getsid",
	"setruid", "exece", "umask", "chroot", "nosys", "select"
};
