#include "param.h"
#include "systm.h"
#include "dir.h"
#include "signal.h"
#include "seg.h"
#include "ipm.h"
#include "sid.h"
#include "user.h"
#include "filsys.h"
#include "mount.h"
#include "proc.h"
#include "inode.h"
#include "conf.h"
#include "buf.h"
#include "tty.h"
#include "map.h"

/*
 * Initialization code.
 * Called from cold start routine as
 * soon as a stack and segmentation
 * have been established.
 * Functions:
 *	clear and free user core
 *	turn on clock
 *	hand craft 0th process
 *	call all initialization routines
 *	fork - process 0 to schedule
 *	   - process 1 execute bootstrap
 *
 * loop at low address in user mode -- /etc/init
 *	cannot be executed.
 */

struct inode *rootdir;
char	*bufstart;
struct buf *sbuf;

main()
{
	extern int locore;

	startup();

	/*
	 * set up system process
	 */

	proc[0].p_addr = (caddr_t) btoc(locore);
	proc[0].p_size = USIZE;
	proc[0].p_stat = SRUN;
	proc[0].p_flag |= SLOAD|SSYS;
	proc[0].p_nice = NZERO;
	u.u_exdata.ux_mag = 0407;	/* OMAGIC */
	u.u_procp = &proc[0];
	u.u_cmask = CMASK;

	/*
	 * initialize devices and system tables
	 */

	clkstart();
	cinit();
	binit();
	iinit();
	sidinit();
	stinit();
	rootdir = iget(rootdev, ROOTINO);
	rootdir->i_flag &= ~ILOCK;
	u.u_cdir = iget(rootdev, ROOTINO);
	u.u_cdir->i_flag &= ~ILOCK;
	u.u_rdir = NULL;
	u.u_start = time;

	/*
	 * make init process
	 * enter scheduling loop
	 * with system process
	 */

	if (newproc(0)) {
		expand(USIZE + (int) btoc (szicode));
		estabur((unsigned) 0, btoc(szicode), (unsigned) 0, RO);
		copyout((caddr_t)icode, (caddr_t) 0, szicode);
		return(0);
	}
	sched();
}

/*
 * iinit is called once (from main) very early in initialization.
 * It reads the root's super block and initializes the current date
 * from the last modified date.
 *
 * panic: iinit -- cannot read the super block.
 * Usually because of an IO error.
 */

iinit()
{
	register struct buf *cp, *bp;
	register struct filsys *fp;

	(*bdevsw[major(rootdev)].d_open)(rootdev, 1);
	bp = bread(rootdev, SUPERB);
	cp = geteblk();
	if (u.u_error)
		panic("iinit");
	bcopy(bp->b_un.b_addr, cp->b_un.b_addr, sizeof (struct filsys));
	brelse(bp);
	mount[0].m_bufp = cp;
	mount[0].m_dev = rootdev;
	fp = cp->b_un.b_filsys;
	fp->s_flock = 0;
	fp->s_ilock = 0;
	fp->s_ronly = 0;
	fp->s_ninode = 0;
	fp->s_inode[0] = 0;
	clkset(fp->s_time);
}


/*
 * This is the set of buffers proper, whose heads
 * were declared in buf.h.  There can exist buffer
 * headers not pointing here that are used purely
 * as arguments to the I/O routines to describe
 * I/O to be done--e.g. swbuf for swapping.
 */

char 	buffers[NBUF][BSIZE+10];

/*
 * Initialize the buffer I/O system by freeing
 * all buffers and setting all device buffer lists to empty.
 * An extra bit gets or'd into the address of the buffer
 * so that it is access thru the non-cached mapping.
 */

binit()
{
	register struct buf *bp;
	register struct buf *dp;
	register int i;
	register unsigned int a;
	struct bdevsw *bdp;

	bfreelist.b_forw = bfreelist.b_back =
	    bfreelist.av_forw = bfreelist.av_back = &bfreelist;
	for (i=0; i<NBUF; i++) {
		bp = &buf[i];
		bp->b_dev = NODEV;
		a = (u_long)buffers[i];
		bp->b_un.b_addr = (caddr_t) (a | 0x81000000);
		bp->b_back = &bfreelist;
		bp->b_forw = bfreelist.b_forw;
		bfreelist.b_forw->b_back = bp;
		bfreelist.b_forw = bp;
		bp->b_flags = B_BUSY;
		brelse(bp);
	}
	for (bdp = bdevsw; bdp->d_open; bdp++) {
		dp = bdp->d_tab;
		if(dp) {
			dp->b_forw = dp;
			dp->b_back = dp;
		}
		nblkdev++;
	}
}
