#include "param.h"
#include "types.h"
#include "buf.h"
#include "conf.h"
#include "ipm.h"
#include "seg.h"
#include "dir.h"
#include "signal.h"
#include "user.h"
#include "proc.h"

/*
 * dumpsys saves the unix image onto the dump device so that
 * savecore can put it in a file during boot.
 * This needs a home.
 */
dumpsys()
{
	extern   char end;
	register caddr_t start;
	register struct buf *bp;
	struct buf *geteblk();
	extern dev_t dumpdev;
	extern off_t dumplo;
	extern maxmem;
	static   u_char dumpcnt = 0;

	/* avoid multiple calls */
	if (dumpcnt)
		return;
	dumpcnt++;
	bp = geteblk();
	{ extern bwcbug; bwcbug = 1;}
	bp->b_dev = dumpdev;
	bp->b_blkno = dumplo;
	bp->b_un.b_addr = (caddr_t)ctob(u.u_procp->p_addr);	/* dump the user segment */
	bp->b_bcount = ctob(USIZE);
	(*bdevsw[major(dumpdev)].d_strategy)(bp);
	while (!(bp->b_flags & (B_DONE|B_ERROR)))
		;
	bp->b_blkno += ctod(USIZE);
	bp->b_un.b_addr = (caddr_t)0x80000000;
	bp->b_bcount = (int)&end & ~0xFF000000;
	printf("dumping %d bytes of core\n", bp->b_bcount);
	(*bdevsw[major(dumpdev)].d_strategy)(bp);
	while (!(bp->b_flags & (B_DONE | B_ERROR)))
		;
	if (bp->b_flags & B_ERROR)
		printf("error dumping kernel\n");
	brelse(bp);
}
