/* tcp.h: Transmission  control protocol header file */

struct	tcp	{
	short	src;
	short	dest;
	u_long	seq;
	u_long	ack;
	u_short	flags;	/* and headler length */
	u_short	wnd;
	u_short	chksum;
	u_short	urgptr;
	u_long	options;
};

/* Flags */

#define	FIN	001
#define	SYN	002
#define	RST	004
#define	PSH	010
#define	ACK	020
#define	URG	040

#define	SETDO(x)	((x) << 13)
#define	GETDO(x)	(((x) >> 13) & 0xf)

/*
 * tcp control back -- state information for a tcp connection.
 */

struct	tcb	{
	long	state;		/* current state */
	long	flags;		/* what's happening? */
	short	lport;		/* local port number */
	short	fport;		/* foreign port number */
	in_addr	laddr;		/* local internet address */
	in_addr	faddr;		/* foreign internet address */
	long	rtt;		/* round trip time */
	long	srtt;		/* smothed round trip time */
	long	tries;		/* how many resends */
	u_long	snd_una;	/* send unacknowledged */
	u_long	snd_nxt;	/* send next */
	u_long	snd_wnd;	/* send window */
	u_long	snd_up;		/* send urgent pointer */
	u_long	snd_wl1;	/* seqment sequence number used for last w up */
	u_long	snd_wl2;	/* segment ack number for last wind update */
	u_long	iss;		/* initial send seguence number */
	u_long	rcv_nxt;	/* receive next	*/
	u_long	rcv_wnd;	/* receive window */
	u_long	rcv_up;		/* receive urgent pointer */
	u_long	irs;		/* initial receive seq number */
	int	qstate;		/* what's going on with this stream */
	struct	queue	*upq;	/* going to user space */
	struct	queue	*dnq;	/* going to the network */
	u_long	rt_timer;	/* clocks left to wait for an ack */
	u_long	tw_timer;	/* time_wait timer */
	u_long	cl_timer;	/* close request timer */
	u_long	per_timer;	/* persist timer */
};

/*	states	*/

#define	CLOSED		0
#define	LISTEN		1
#define	SYN_SENT	2
#define	SYN_RECEIVED	3
#define	ESTABLISHED	4
#define	FIN_WAIT_1	5
#define	FIN_WAIT_2	6
#define	CLOSE_WAIT	7
#define	CLOSING		8
#define	LAST_ACK	9
#define	TIME_WAIT	10

/*	flags		*/

#define	TCP_ISOPEN	00001		/* being used */
#define	TCP_CLOSING	00004		/* wishing to close */
#define	TCP_CLEXPIRED	00010		/* I guess we can close now */

/* 	qstate		*/

#define	TCP_IDLE	0
#define	TCP_WOPEN	1		/* waiting for connection to complete */
#define	TCP_STARTED	2		/* up and running */


#define	NTCB	100			/* number of possible connections */
#define	MAXRCVWND	2048		/* our recv window */
#define	MAXRTO		(2 * 60 * 2)

#define	MAXTRIES	3
#define KEEPALIVE_TIME	120		/* 1 min */

#define	TCPRTO(tp)	((tp)->rtt << ((tp)->tries - 1) > MAXRTO ? \
				MAXRTO : \
				(tp)->rtt << ((tp)->tries - 1))
