/* sd.c: Driver for scsi disc drives */

#include "param.h"
#include "systm.h"
#include "buf.h"
#include "dir.h"
#include "conf.h"
#include "signal.h"
#include "seg.h"
#include "ipm.h"
#include "sid.h"
#include "user.h"

#define	NRO	7
#define	b_actf	av_forw
#define	b_actl	av_back
#define	b_active b_bcount
#define b_errcnt b_resid
#define	b_cylin	b_resid

struct {
	int	blkoff;
	daddr_t	nblocks;
} sd_sizes[] = {
	0,	10240,
	10240,	20480,
	30720,	249848,
	280568,	249848,
	530416,	249848,
	780264,	9999999,
	30720,	7495444,
	0,	9999999
};

static	char	rs[] = { 3, 0, 0, 0, 4, 0 };
static	char	w[] =  { 0x2a, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
static	char	r[] =  { 0x28, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
static	char	data[100];
struct	buf	sdtab;
struct	buf	rsdbuf;
static	int	firsttime[NRO];

#define	DK_N	0			/* monitoring device number */


sdopen(dev)
{
	int sdopenintr();
	int unit;

	unit = minor(dev);
	if (firsttime[unit >> 3] == 0) {
		scsi(unit >> 3, B_READ, rs, data, 4, sdopenintr);
		sleep(sdopenintr, PRIBIO);
		scsi(unit >> 3, B_READ, rs, data, 4, sdopenintr);
		sleep(sdopenintr, PRIBIO);
		firsttime[unit >> 3] = 1;
	}
}

sdopenintr(a, s)
{
	wakeup(sdopenintr);
}


sdstrategy(bp)
register struct buf *bp;
{
	register struct buf *dp;
	register int unit;
	long sz;

	unit = minor(bp->b_dev);
	sz = bp->b_bcount;
	sz = (sz+511)>>9;
	if (unit >= (NRO<<3) ||
	   bp->b_blkno + sz >= sd_sizes[unit&07].nblocks) {
		bp->b_flags |= B_ERROR;
		iodone(bp);
		return;
	}
	bp->av_forw = NULL;
	unit >>= 3;
	bp->b_cylin = bp->b_blkno + sd_sizes[unit].blkoff;
	dp = &sdtab;
	splbio();
	disksort(dp, bp);
	if (dp->b_active == NULL)
		sdstart();
	spl0();
}

sdstart()
{
	register struct buf *bp;
	register char *cdb;
	register int unit;
	int tl;
	daddr_t bn;
	int sdintr();


	if ((bp = sdtab.b_actf) == NULL)
		return;
	sdtab.b_active++;
	unit = minor(bp->b_dev);
	bn = bp->b_blkno + sd_sizes[unit & 07].blkoff;
	cdb = (bp->b_flags & B_READ) ? r : w;
	cdb[2] = bn >> 24 & 0xff;
	cdb[3] = bn >> 16 & 0xff;
	cdb[4] = bn >> 8 & 0xff;
	cdb[5] = bn & 0xff;
	tl = bp->b_bcount + 511 >> 9;
	cdb[7] = tl >> 8 & 0xff;
	cdb[8] = tl & 0xff;
	scsi(unit >> 3, bp->b_flags & B_READ, cdb,
		bp->b_un.b_addr, bp->b_bcount, sdintr);
	dk_busy |= 1 << DK_N;
	dk_numb[DK_N] += 1;
	unit = bp->b_bcount >> 6;
	dk_wds[DK_N] += unit;
}

sdintr(status)
{
	register struct buf *bp;
	register int ctr;

	if (sdtab.b_active == NULL) 
		return;
	dk_busy &= ~(1 << DK_N);
	bp = sdtab.b_actf;
	sdtab.b_active = NULL;
	if (status) {
		printf("sdintr: status 0x%x\n", status);
		bp->b_flags |= B_ERROR;
	}
	sdtab.b_actf = bp->av_forw;
	bp->b_resid = 0;
	iodone(bp);
	sdstart();
}

sdread(dev)
{

	physio(sdstrategy, &rsdbuf, dev, B_READ);
}

sdwrite(dev)
{

	physio(sdstrategy, &rsdbuf, dev, B_WRITE);
}
