/*
 *  Configuration information
 */

#include "param.h"
#include "acct.h"
#include "buf.h"
#include "file.h"
#include "inode.h"
#include "proc.h"
#include "text.h"
#include "callo.h"
#include "mount.h"
#include "ipm.h"
#include "sid.h"
#include "conf.h"
#include "stream.h"


extern nodev(), nulldev();
extern syopen(), syread(), sywrite(), syioctl();
extern mmread(), mmwrite();
extern sdopen(), sdstrategy();
extern	mtopen(), mtclose(), mtstrategy();
extern struct buf sdtab;
extern struct buf mttab;

struct bdevsw bdevsw[] = {
/* 0*/	sdopen, nulldev, sdstrategy, &sdtab,	/* scsi disc */
	0
};


extern	ziopen(), ziclose(), ziread(), ziwrite(), ziioctl();
extern	sdread(), sdwrite();
extern	mtread(), mtwrite();
extern	struct tty zitty[];
extern	enopen(), enclose();
extern	cmopen(), cmclose();
extern cmdopen(), cmdread();
extern	struct qinit enqinit[];
extern	struct qinit cmqinit[];
extern	ptopen(), ptclose();
extern	struct	qinit	ptqinit[];
extern	ipopen(), ipclose();
extern	struct	qinit	ipqinit[];
extern	udpopen();
extern	struct	qinit	udpqinit[];
extern	struct	qinit	lbqinit[];
extern	fdopen();
extern	tcpdopen();
extern	tcpdclose();
extern	struct	qinit	tcpdqinit[];
extern	pmread(), pmwrite(), pmclose();
extern	struct	qinit pimqinit[];
extern	pimclose(), pimopen();
extern	lrread(), lrwrite();
extern	struct qinit lrqinit[];

struct cdevsw cdevsw[] = {
{	/*  0: console */
	ziopen,		ziclose,	ziread,		ziwrite,
	ziioctl,	nulldev,	zitty,		NULL
},{	/*  1: ttys */
	nodev,		nodev,		nodev,		nodev,
	nodev,		nodev,		NULL,		NULL
}, {	/*  2: rst */
	mtopen,		mtclose,	mtread,		mtwrite,
	nulldev,	nulldev,	NULL,		NULL
}, {	/*  3: memory */
	nulldev,	nulldev,	mmread,		mmwrite,
	nulldev,	nulldev,	NULL,		NULL
}, {	/*  4: raw disc */
	sdopen,		nulldev,	sdread,		sdwrite,
	nulldev,	nulldev,	NULL,		NULL
}, {	/*  5: en */
	enopen,		enclose,	nulldev,	nulldev,
	nulldev,	nulldev,	NULL,		enqinit
}, {	/*  6: ncm */
	cmopen,		cmclose,	nulldev,	nulldev,
	nulldev,	nulldev,	NULL,		cmqinit
}, {	/*  7: fd */
	fdopen,		nulldev, 	nulldev, 	nulldev,
	nulldev,	nulldev,	NULL,		NULL
}, {	/*  8: pim control/status device */
	nulldev, 	pmclose,	pmread,		pmwrite,
	nulldev,	nulldev,	NULL,		NULL
}, {	/*  9: tty */
	syopen,		nulldev,	syread,		sywrite,
	syioctl,	nulldev,	NULL,		NULL
}, {	/* 10: pt */
	ptopen,		ptclose,	nulldev,	nulldev,
	nulldev,	nulldev,	NULL,		ptqinit
}, {	/* 11: ip */
	ipopen,		ipclose,	nulldev, 	nulldev,
	nulldev, 	nulldev,	NULL,		ipqinit
}, {	/* 12: udp */
	udpopen, 	nulldev,	nulldev,	nulldev,
	nulldev,	nulldev,	NULL,		udpqinit
}, {	/* 13: loopback */
	nulldev,	nulldev,	nulldev,	nulldev,
	nulldev, 	nulldev, 	NULL,		lbqinit
}, {	/* 14: tcp */
	tcpdopen, 	tcpdclose,	nulldev,	nulldev,
	nulldev,	nulldev,	NULL,		tcpdqinit
}, {	/* 15: cm dips */
	cmdopen,	nulldev,	cmdread,	nulldev,
	nulldev,	nulldev,	NULL,		NULL
}, {	/* 16: pim events */
	pimopen,	pimclose,	nulldev,	nulldev,
	nulldev,	nulldev,	NULL,		pimqinit
}, {	/* 17: lr control/status */
	nulldev,	nulldev, 	lrread,		lrwrite,
	nulldev,	nulldev,	NULL,		NULL
}, {	/* 18: lr events */
	nulldev,	nulldev,	nulldev,	nulldev,
	nulldev,	nulldev,	NULL,		lrqinit
},
	{ 0 }
};


dev_t	rootdev = makedev(0, 0);
dev_t	pipedev = makedev(0, 0);
dev_t	swapdev = makedev(0, 1);
dev_t	dumpdev = makedev(0, 1);
daddr_t	swplo = 0;
daddr_t	dumplo = 5000;
int	nswap = 20480;


/*  qinit structures for LDs */

extern	struct	qinit	etqinit[];
extern	struct	qinit	ttqinit[];
extern	struct	qinit	ipldqinit[];
extern	struct	qinit	udpldqinit[];
extern	struct	qinit	tcpl[];
extern	struct	qinit	lrldqinit[];

struct	qinit	*qinit_ld[] = {
	ttqinit,		/* tty_ld */
	NULL,			/* buf_ld */
	NULL, 			/* mesg_ld */
	NULL,			/* rmesg_ld */
	NULL,			/* conn_ld */
	ipldqinit,		/* ip_ld */
	tcpl,			/* tcp_ld */
	udpldqinit,		/* udp_ld */
	NULL,			/* crap_ld */
	etqinit,		/* et_ld */
	lrldqinit,		/* lr_ld */
	NULL
};

int	nlds = 12;
struct	file	file[NFILE];	/* file table */
struct	inode	inode[NINODE];	/* inode table */
struct	proc	proc[NPROC];	/* process table */
struct	text	text[NTEXT];	/* text table */
struct	buf	bfreelist;
struct	callo	callout[NCALL];	/* Callout table */
struct	mount	mount[NMOUNT];	/* Mount table */
struct	buf	buf[NBUF];
struct	acct	acctbuf;
struct	inode	*acctp;
struct	mesg	mesg[NMSGS];
struct	sid	sid[NSIDS];

/* This should be macros */

max(a,b)	{ return a > b ? a : b; }
min(a,b)	{ return a < b ? a : b; }
int	bwcbug;
