/* snm main.c */
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/timeb.h>
#include <signal.h>
#include <string.h>
/* #include <limits.h> */
#include <stdio.h>
#include <sys/ipm.h>
#include <sys/inet/tcp_user.h>
#include <sys/inet/udp_user.h>
#include <sys/inet/in.h>

#define MAXCONN 50
#define TCP_PORT 2111
#define UDP_PORT 2112
#define MTU 1520
#define OPEN_MAX 20 /* from limits.h on gun */

struct neighbor {
	time_t lasttime;
	struct tcpuser peer;
	int fd;
};

int findfd();
void printconx();
in_addr node2addr();
void retmsg();
void clean();
static struct neighbor n[MAXCONN];
int lfd;
static int n2aflag;
int debug = 1;
char *anfname;

main(argc, argv)
int argc;
char *argv[];
{
	fd_set rfds;
	register int i, j;
	int result, tmp;
	char *p;
	struct mesghdr mh;
	char *m;
	int msgrecfd;
	char message[4096];
	int udpfd;
	in_addr daddr;
	struct mesghdr *hp;
	char *mp;
	struct tcpuser luser;
	extern errno;
	struct udpaddr *udpp;
	int len;

	signal(SIGINT, clean);

	switch(argc) {
	case 3:
		if (strcmp(argv[1], "-f") == 0) {
			n2aflag = 1;
			anfname = argv[2];
			break;
		}
		/* fall through */
	case 2:
		fprintf(stderr, "usage: %s [-f filename]\n", argv[0]);
		exit(-1);
		break;
	case 1:
		printf("1\n");
		n2aflag = 0;
		break;
	}
		
	if ((lfd = tcp_sock()) < 0)
		fatal("opening incoming stream socket");

	bzero(&luser, sizeof luser);
	luser.lport = TCP_PORT;

	tcp_listen(lfd, &luser);

	p = (char *)getenv("SNM_SID");
	if (p)
		msgrecfd = msgbind(atoi(p));
	else
		fatal("SNM_SID not in environment");

	if ((udpfd = udp_datagram(UDP_PORT)) < 0 )
		fatal("opening udp socket");

	while(1) {
		FD_ZERO(&rfds);
		FD_SET(msgrecfd, &rfds);
		FD_SET(udpfd, &rfds);
		for (i=0;i<MAXCONN;i++)
			if (n[i].fd)
				FD_SET(n[i].fd, &rfds);
		FD_SET(lfd, &rfds);
		if (select(getdtablesize(), &rfds, (fd_set *)0, (fd_set *)0, 0) < 0) {
			perror("selecting");
			continue;
		}

		if (FD_ISSET(msgrecfd, &rfds)) {
			m = msgrecv(msgrecfd, &mh);
			switch (mh.flags & 0x07) {
			case 0:
			case MESG_IMPORTANT:
				if ((i = findfd(mh.dest.node, mh.dest.scope)) >= 0) {
					time(&n[i].lasttime);
					if (write(n[i].fd, &mh, sizeof mh) < 0 ||
					write(n[i].fd, m, mh.length) < 0) {
						if (debug) {
							perror("TCP write failed");
							printf("msg dropped for node %s\n", mh.dest.node);
						}
						break;
					}
				} else {
						if((daddr = node2addr(mh.dest.node, mh.dest.scope, n2aflag)) == 0) {
							printf( "snm:bad node address, msg dropped\n");
							printf("dropping offending message\n");
							hexdump(&mh, sizeof mh);
							break;
						}
						i = 0;
						while (n[i].fd) /* find first free fd */
							i++;
						if ((n[i].fd = tcp_sock()) < 0) {
							if (debug)
								perror("snm:tcp_sock():dropped msg");
							break;
						}
						bzero(&n[i].peer, sizeof n[i].peer);
						n[i].peer.faddr = daddr;
						n[i].peer.fport = htons(TCP_PORT);
						if (tcp_connect(n[i].fd, &n[i].peer) < 0) {
							perror("new connection failed");
							printf("failed for peer:\n");
							hexdump(&n[i].peer, sizeof(n[i].peer));
							close (n[i].fd);
							n[i].fd = 0;
							bzero((char *)&n[i].peer, sizeof(n[i].peer));
							break;
						}
						time(&n[i].lasttime);
						if (write(n[i].fd, &mh, sizeof mh) < 0 ||
						write(n[i].fd, m, mh.length) < 0) {
							if (debug) {
								perror("TCP write failed");
								printf("msg dropped for node %s\n", mh.dest.node);
							}
						}
					}
					break;
				case MESG_FAST:
					bcopy((char *)&mh, message + sizeof (struct udpaddr), sizeof mh);
					bcopy(m, message + sizeof(struct udpaddr) + sizeof mh, mh.length);
					udpp = (struct udpaddr *)message;
					len = sizeof(struct udpaddr) + sizeof mh + mh.length;
					if (udpp->host = node2addr(mh.dest.node, mh.dest.scope, n2aflag)) {
						udpp->port = UDP_PORT;
						if (write(udpfd, message, len) < 0) {
							retmsg(&mh, m);
							perror("sending datagram message");
						}
					} else {
						fprintf(stderr, "bad UDP address %d\n", mh.dest.node);
					}
					break;
				default:
					fprintf(stderr, "bad flags in msgrecv()\m");
					break;
			}
			msgfree(m);
		}

		if (FD_ISSET(udpfd, &rfds)) {
			if (read(udpfd, message, MTU) <= 0)
				perror("reading message from rudpsock");
			hp = (struct mesghdr *)message + sizeof(struct udpaddr);
			mp = (char *)hp + sizeof(struct mesghdr);
			p = msgalloc(hp->length);
			bcopy(mp, p, hp->length); 
			/* mp->dest.node = 0;
			mp->dest.scope = 0; hmmmmmmmmmm */
			if (msgsend(hp, p) == -1)
				perror("snm:udp -> msgsend error");
		}

		for (i=0;i<MAXCONN;i++)
			if (n[i].fd)
				if (FD_ISSET(n[i].fd, &rfds))
					switch(read(n[i].fd, &mh, sizeof mh)) {
					case -1: /* problem */
						perror("reading s-hdr from stream sock");
						break;
					case 0: /* he went away */
						fprintf(stderr, "closing i=%d conx to %s\n",
						i, in_ntoa(n[i].peer.faddr));
						if (close(n[i].fd) == -1)
							perror("close failed");
						n[i].fd = 0;
						bzero((char *)&n[i].peer, sizeof n[i].peer);
						break;
					default: /* got something */
						p = msgalloc(mh.length);
						time(&n[i].lasttime);
						if (read(n[i].fd, p, mh.length) <= 0)
							perror("reading p from stream sock");
						if (msgsend(&mh, p) == -1)
							perror("snm:message send");
					}

		if (FD_ISSET(lfd, &rfds)) {
			i=0;
			while (n[i].fd && i<MAXCONN)
				i++;
			/* check for out of range */
			if ((n[i].fd = tcp_accept(lfd, &n[i].peer)) < 0)
				perror("accepting stream conx");
			for (j=0;j<MAXCONN;j++)
				if (i != j)
					if (n[i].peer.faddr == n[j].peer.faddr) {
						close(n[j].fd);
						n[j].fd = 0;
						bzero((char *)&n[j].peer, sizeof n[j].peer);
					}
			time(&n[i].lasttime);
			if (debug)
				printf("added new conx to %s\n", in_ntoa(n[i].peer.faddr));
		}
	}
}


int findfd(node, scope)
u_short node;
u_short scope;
{
	int i;
	char *q, *p;

	for (i=0;i<MAXCONN;i++)
		if (n[i].fd)
			if (n[i].peer.faddr = node2addr(node, scope, n2aflag))
				return(i);
	return(-1);
}

void clean()
{
	int i;
	for (i=0;i<MAXCONN;i++)
		if (n[i].fd)
			close(n[i].fd);
	close(lfd);
	exit(0);
}

in_addr 
node2addr(node, scope, n2aflag)
u_short node;
u_short scope;
{
	static in_addr *addr;
	struct hostent *hp;
	char line[80];
	char *p;
	FILE *fp;

	if (n2aflag) {
		if ((fp = fopen(anfname,"r")) == 0)
			fatal("opening anfname");
		while (fgets(line, 80, fp)) {
			p = strtok(line, " ");            /* fix this */
			if (atoi(p) == node) {
				p = strtok(NULL, " \n");
				fclose(fp);
				return(in_address(p));
			}
		}
		fclose(fp);
		return(0);
	} else
		return(0x80008001 | (u_int)node << 16);
}

void retmsg(mp, dp)
struct mesghdr *mp;
char *dp;
{
	char *p;
	struct mesghdr rm;

	if (!(mp->flags & MESG_RETURNED)) {
		bcopy((char *)&mp, (char *)&rm, sizeof rm);
		rm.flags |= MESG_RETURNED;
		msgsend(&rm, p);
	}
}

fatal(msg)
	char *msg;
{
	perror(msg);
	exit(-1);
}

