/* udp_datagram.c: get and bound udp socket to sport */

#include <sys/inet/in.h>
#include <sys/inet/udp_user.h>

udp_datagram(sport)
	udp_port sport;
{
	int fd;
	struct udpuser u;

	if ((fd = udp_sock()) == -1)
		return -1;
	u.lport = sport;
	u.laddr = INADDR_ANY;
	u.faddr = 0;
	u.fport = 0;	/* this means just bind */
	u.code = UDPC_DATAGRAM;
	if (write(fd, (char *)&u, sizeof u) == -1
	||  read(fd, (char *)&u, sizeof u)  == -1
	||  u.code != UDPC_OK) {
		close(fd);
		return -1;
	}
	return fd;
}
