# include <ctype.h>
# include <stdio.h>
# undef BOOTSTRAP
# define IAR	/* use integer arithmetic to speed things up */

# ifdef BOOTSTRAP
double digits[10];
double ten;
# else BOOTSTRAP
double pow10[] = {10., 100., 1e4, 1e8, 1e16, 1e32, 1e64, 1e128, 1e256};
double digits[10] = {0., 1., 2., 3., 4., 5., 6., 7., 8., 9.};
double ten=10.;
# endif BOOTSTRAP

/* Any integer <= maxd can be represented exactly as a double, */
/* where maxd = *(double *)imaxd */
/* Note: maxd = 9007199254740991 in decimal */
int imaxd[] = {0x433fffff, 0xffffffff};

double
atof(s)
register char *s;
{
	double d, p10, exp10;
	register char c;
	int needneg, needinv, exp, eexp, neexp;
# ifdef IAR
	register int id;
	int maxi, intok;
	double maxd;
# endif IAR

# ifdef BOOTSTRAP
	for (exp = 0; exp < 10; exp++) {
		digits[exp] = exp;
	}
	exp = 10;
	ten = exp;	/* avoid compiler-generated double */
# endif BOOTSTRAP

	maxd = *(double *)imaxd;
# ifdef IAR
	maxi = (0x7fffffff - 9)/10;
# endif IAR
	needneg = 0;
	d = 0;

	while (isspace(c = *s))
		s++;
	switch (c) {
	  case '-':
		needneg = 1;
	  case '+':
		s++;
		break;
	}
	exp = 0;
# ifdef IAR
	id = 0;
	intok = 1;
	while (c = *s++) {
		if ('0' <= c && c <= '9') {
			if (intok) {
				if (id < maxi)
					id = id * 10 + (c-'0');
				else {
					intok = 0;
					d = id;
					d = ten*d + digits[c-'0'];
				}
			}
			else {
				if (d < maxd) {
					d = ten*d + digits[c-'0'];
				}
				else
					exp++;
			}
		}
		else
			break;
	}
# else IAR
	while (c = *s++) {
		if ('0' <= c && c <= '9') {
			if (d < maxd) {
				d = ten*d + digits[c-'0'];
			}
			else
				exp++;
		}
		else
			break;
	}
# endif IAR

# ifdef IAR
	if (c == '.') {
		while (c = *s++) {
			if ('0' <= c && c <= '9') {
				if (intok) {
					if (id < maxi) {
						id = id * 10 + (c-'0');
						exp--;
					}
					else {
						intok = 0;
						d = id;
						d = ten*d + digits[c-'0'];
						exp--;
					}
				}
				else {
					if (d < maxd) {
						d = ten*d + digits[c-'0'];
						exp--;
					}
				}
			}
			else
				break;
		}
	}
	if (intok)
		d = id;
# else IAR
	if (c == '.') {
		while (c = *s++) {
			if ('0' <= c && c <= '9') {
				if (d < maxd) {
					d = ten*d + digits[c-'0'];
					exp--;
				}
			}
			else
				break;
		}
	}
# endif IAR
	eexp = 0;
	neexp = 0;
	if ((c == 'e') || (c == 'E'))
	{
		
		switch (c = *s) {
	  	case '-':
			neexp = 1;
	  	case '+':
			s++;
			break;
		}
		while  ('0' <= (c = *s++) && c <= '9')
			eexp = 10*eexp + (c-'0');
	}
	if (neexp)
		exp -= eexp;
	else
		exp += eexp;
	needinv = 0;
	if (exp < 0) {
		needinv = 1;
		exp = -exp;
	}
	p10 = ten;
# ifdef BOOTSTRAP
	exp10 = digits[1];
# else BOOTSTRAP
	exp10 = 1.;
# endif BOOTSTRAP
# ifdef BOOTSTRAP
	for (; exp; exp >>= 1) {
		if (exp & 1)
			exp10 *= p10;
		p10 *= p10;
# else BOOTSTRAP
	for (id=0; exp && id<=8; exp >>= 1, id++) {
		if (exp & 1)
			exp10 *= pow10[id];
# endif BOOTSTRAP
	}

	if (needinv)
		d /= exp10;
	else
		d *= exp10;
	if (needneg)
		d = -d;
	return d;
}
