/* q.c */
#include <sys/types.h>
#include <string.h>
#include <stdio.h>
#include <sys/ethernet.h>
#include <sys/ipm.h>
#include "pep.h"
#include "malloc.h"

extern int dbg;
extern int pc;
static struct qtop *top;
char errstr[128];
char *ascii2hex();
static char addr1[] = {0x22, 0x00, 0x00, 0x00, 0x00, 0x00};
static char addr2[] = {0x23, 0x00, 0x00, 0x00, 0x00, 0x00};

int 
resend() /*scan the q heads and resend as needed*/
{
	register struct qtop *p;

	p = top;
	while (p) {
		if (p->size > 0) {
			if (p->resends >= MAX_RESENDS) {
				if (retmsg(p->scope, p->curr_trid) >= 0) {
					sendtop(p->scope);
	
						sprintf(errstr,
						"max resends for %d\n",
						p->scope);
						err(errstr);
				} else {
					err("remtop error\n");
				}
			} else {
				if (p->timeo++ >= MAX_TIMEO) {
					p->timeo = 0;
					if (sendagain(p->scope) < 0)
						err("pep:sendagain() failed\n");
					p->resends++;
				}
			}
		}
		p = p->next;
	}
}

/*make a struct wire frame and send it on the enet for the resend
handler.  Different from sendtop because the trid is not incremented*/
static int 
sendagain(scope)
u_short scope;
{
        register struct qtop *p;
	char *w;
	struct pephdr *pp;
	char *mhp;

        p = top;
	err("sendagain\n");
        while(p->scope != scope)
                p = p->next;
        if (p->head) {
                w = malloc(ETHERHLEN+PEPHLEN+MHHLEN + p->head->mh->length);
		if (w) {
			pp = (struct pephdr *)(w + ETHERHLEN);
			mhp = (char *)pp + PEPHLEN;
			memcpy(w, &p->enet, ETHERHLEN);
			pp->type = PEP_DATA;
			pp->trid = p->curr_trid;
			memcpy(mhp, p->head->mh, MHHLEN);
			memcpy(mhp + MHHLEN, p->head->data, p->head->mh->length);
			etherwrite(w, ETHERHLEN+PEPHLEN+MHHLEN + p->head->mh->length);
			free(w);
		}
        } else {
                return(-1);
        }
}

int 
remtop(scope, trid)/*remove top member from the specified q*/
u_short scope;
u_int trid;
{
	register struct qtop *p;
	register struct memb *tmp;

	p = top;
	if (dbg)
		printf("pep:remtop:p = %x\n", p);
	while(p->scope != scope && p != NULL)
		p = p->next;
	if (p->head && p != NULL) {
		tmp = p->head;
		if (p->curr_trid == trid) {
			p->head = tmp->next;
			if (p->head == NULL)
				p->tail = p->head;
			decpc(tmp->mh->length);
			free(tmp->mh);
			msgfree(tmp->data);
			free(tmp);
			p->resends = 0;
			p->timeo = 0;
			return(--p->size);
		} else {
			/* this is a duplicate ACK */
			err("q.c duplicat ack received\n");
			return(-1);
		}
	} else {
		return(0);
	}
}
int
retmsg(scope, trid)
u_short scope;
u_int trid;
{
	register struct qtop *p;
	register struct memb *tmp;
	struct mesghdr nmh;

	p = top;
	while(p->scope != scope)
		p = p->next;
	if (p->head) {
		tmp = p->head;
		if (p->curr_trid == trid) {
			p->head = tmp->next;
			if (p->head == NULL)
				p->tail = p->head;
			bcopy(&tmp->mh->orig, &nmh.dest, sizeof nmh.dest);
			bcopy(&tmp->mh->dest, &nmh.orig, sizeof nmh.orig);
			nmh.flags = tmp->mh->flags | MESG_RETURNED;
			nmh.length = tmp->mh->length;
			decpc(nmh.length);
			if (msgsend(&nmh, tmp->data) < 0) {
				perror("msgsend");
				msgfree(tmp->data);
			}
			free(tmp->mh);
			free(tmp);
			p->resends = 0;
			p->timeo = 0;
			return(--p->size);
		} else {
			/* this is a duplicate ACK */
			err("q.c duplicat ack received\n");
			return(-1);
		}
	} else  {
		return (0);
	}
}

int
sendtop(scope)/*send top member on transmit q*/
u_short scope;
{
	register struct qtop *p;
	char *w;
        struct pephdr *pp;
        char *mhp;

        p = top;

	while (p != NULL && p->scope != scope )
                p = p->next;
	if (p != NULL && p->head) {
                w = malloc(ETHERHLEN+PEPHLEN+MHHLEN + p->head->mh->length);
		if(!w)
			err("null malloc\n");
                pp = (struct pephdr *)(w + ETHERHLEN);
                mhp = (char *)((char *)pp + PEPHLEN);
                memcpy(w, &p->enet, ETHERHLEN);
                pp->type = PEP_DATA;
                pp->trid = ++p->curr_trid;
                memcpy(mhp, p->head->mh, MHHLEN);
                memcpy(mhp + MHHLEN, p->head->data, p->head->mh->length);
		etherwrite(w, ETHERHLEN+PEPHLEN+MHHLEN + p->head->mh->length);
                free(w);
        } else {
		err("sendtop failed\n");
		return(-1);
        }
}

int 
pepsend(msgh, data)/*add the member to the xmit q and send if on the top*/
register struct mesghdr *msgh;
char *data;
{
	int a;

	if ((a = addm(msgh, data)) == 1)
		sendtop(msgh->dest.scope);
/*	else
		fprintf(stderr, "pepsend:ret from addm = %d\n", a);
*/
}

static struct qtop *
new_top(msgh) /*make a new q head for the specified scope*/
register struct mesghdr *msgh;
{
	register struct qtop *s;

	s = (struct qtop *)calloc(1, sizeof(struct qtop));
	s->scope = msgh->dest.scope;
	scope2enet(s->enet.dhost, msgh->dest.scope);
	s->enet.type = PEP_ETYPE;
	return (s);
}

static int 
scope2enet(dh, scope)/*uses algorithm to cvt a scope to enet*/
register u_char *dh;
u_short scope;
{
	u_short *pidp;

	pidp = (u_short *)&dh[4];

	if (scope & 0x4000) {
		memcpy(dh, addr2, ETHERALEN);
		*pidp = scope;
	} else {
		memcpy(dh, addr1, ETHERALEN);
		*pidp = scope;
	}
}

static int 
addm(msgh, adata)/*add a message to the xmt q and return the q size*/
struct mesghdr *msgh;
register char *adata;
{
	register struct qtop *p;
	register struct memb *t;
	struct qtop *tmp, *s;
	struct mesghdr *mh;

	mh = (struct mesghdr *)malloc(sizeof(struct mesghdr));
	memcpy(mh, msgh, sizeof(struct mesghdr));
	p = top;
	while(p) {
		if (mh->dest.scope == p->scope) {
			t = (struct memb *)malloc(sizeof(struct memb));
			t->mh = mh;
			t->data = adata;
			t->next = NULL;
			if (p->head == NULL && p->tail == NULL){
				p->head = t;
				p->tail = t;
				p->size = 1;
			} else {
				p->tail->next = t;
				p->tail = t;
				p->size++;
			}
			return(p->size);
		}
		p = p->next;
	}
	s = new_top(mh);
	t = (struct memb *)malloc(sizeof(struct memb));
	t->mh = mh;
	t->data = adata;
	t->next = NULL;
	s->head = t;
	s->tail = t;
	s->size = 1;
	if (top) {
		tmp = top;
		top = s;
		s->next = tmp;
	} else {
		top = s;
	}
	return(s->size);
}

printq()/*debugging only...prints the transmit q*/
{
	struct qtop *p;
	struct memb *q;
	p = top;
	while (p) {
		q = p->head;
		do {
			if (q)
				q = q->next;
		} while (q);
		p = p->next;
	}
}

static 
hex(x) /*cvt an ascii char to a hex number*/
char x;
{
	switch (x)
	{
		case '0': return(0);
		case '1': return(1);
		case '2': return(2);
		case '3': return(3);
		case '4': return(4);
		case '5': return(5);
		case '6': return(6);
		case '7': return(7);
		case '8': return(8);
		case '9': return(9);
		case 'a': return(10);
		case 'b': return(11);
		case 'c': return(12);
		case 'd': return(13);
		case 'e': return(14);
		case 'f': return(15);
		default:
			(void)printf("bad hex char = %c\n",x);
			exit(-1);
	}
}

static char *
ascii2hex(ret, instring)/*cvt an ascii enet string to a binary addr*/
register char *ret;
register char *instring;
{
	register int i;

	for (i=0;i<6;i++)
		ret[i] = hex(*instring++) + 16 * hex(*instring++);
}

incpc(len)
u_short len;
{
	pc += (len + 511)/512;
}

decpc(len)
u_short len;
{
	pc -= (len + 511)/512;
	if (pc < 0)
		pc = 0;
}
