#include <sys/types.h>
#include <sys/ipm.h>
#include <sid.h>
#include <sys/signal.h>
#include <sys/times.h>
#include <stdio.h>

ding();

main(argc, argv)
int argc;
char *argv[];
{
	time_t ts, te;
	struct tms t;
	int fd, i, *ip, cnt;
	static struct mesghdr mho, mhi;
	char buf[128], *p;

	signal(SIGALRM, ding);
	if (argc-- == 1) {
		fprintf(stderr, "usage: %s node [scope[ [ flags [count]]]\n",
			argv[0]);
		exit(1);
	}
	argv++;
	if (argc-- > 0)
		mho.dest.node = strtol(*argv++, 0, 0);
	if (argc-- > 0)
		mho.dest.scope = strtol(*argv++, 0, 0);
	if (argc-- > 0)
		mho.flags = strtol(*argv++, 0, 0);
	cnt = argc > 0 ? strtol(*argv, 0, 0) : 10;
	mho.dest.sid = SID_ECHO;
	printf("%d %d %d %d\n", mho.dest.net, mho.dest.node, mho.dest.scope,
		mho.dest.sid);
	printf("flags = %d\n", mho.flags);
	mho.orig.net = getnetwork();
	mho.orig.node = getnode();
	mho.orig.scope = getscope();
	mho.orig.sid = fdsid(fd = msgbind(0));
	i = 1;
	do {
		if ((p = msgalloc(512)) < 0)
			fatal("msgalloc");
		sprintf(p, "%d Pling!!!\n", cnt);
		mho.length = strlen(p);
		ts = times(&t);
		if (msgsend(&mho, p) < 0)
			fatal("msgsend returned -1");
		alarm(5);
		p = msgrecv(fd, &mhi);
		alarm(0);
		if ((int)p != -1) {
			te = times(&t);
			sscanf(p, "%d", &i);
			msgfree(p);
			if (i != cnt) {
				printf("out of sequence msg received\n");
				continue;
			}
			if (mhi.flags & MESG_RETURNED) {
				printf("MESG_RETURNED bit set\n");
				continue;
			}
			printf("%d ms\n", (te-ts)*17+8);

		} else
			printf("no response\n");
		i++;
	} while(--cnt);
}

ding()
{
	signal(SIGALRM, ding);
}
fatal(s)
char *s;
{
	perror(s);
	exit(-1);
}
