/*
 *  Print execution profile
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <nlist.h>

typedef	short UNIT;		/* unit of profiling */

/*	a.out.h	4.1	83/05/03	*/
/* this stuff borrowed from <a.out.h> because of definition conflicts
/* of struct nlist between <a.out.h> and <nlist.h> 
*/

/*
 * Header prepended to each a.out file.
 */
struct exec {
	long	a_magic;	/* magic number */
unsigned long	a_text;		/* size of text segment */
unsigned long	a_data;		/* size of initialized data */
unsigned long	a_bss;		/* size of uninitialized data */
unsigned long	a_syms;		/* size of symbol table */
unsigned long	a_entry;	/* entry point */
unsigned long	a_trsize;	/* size of text relocation */
unsigned long	a_drsize;	/* size of data relocation */
};

#define	OMAGIC	0407		/* old impure format */
#define	NMAGIC	0410		/* read-only text */
#define	ZMAGIC	0413		/* demand load format */

#define N_SYMOFF(x) \
	(sizeof(struct exec)+(x).a_text+(x).a_data + (x).a_trsize+(x).a_drsize)
#define N_STROFF(x) \
	(N_SYMOFF(x) + (x).a_syms)

struct stat stbuf;
struct nl {
	char		*name;
	unsigned	value;
	float		time;
	long		ncall;
};

struct hdr {
	UNIT	*lowpc;
	UNIT	*highpc;
	int	ncount;
};

struct nl nl[9000];

struct cnt {
	unsigned cvalue;
	long	cncall;
};

FILE	*pfile, *nfile;
unsigned highpc;
unsigned lowpc;
int	ransca;
int	ranoff;
unsigned pcl;
unsigned pch;
unsigned bufs;
int	nname;
double	ftime;
double	actime;
double	totime;
double	maxtime;
double scale;
int	lastx;
int	lasty;
struct nl *np;
struct nl *npe;
int	aflg;
int	vflg;
int	lflg;
int	zflg;		/* include routines with zero usage in the output */
long	symoff;
long stoff;
long stsize;

main(argc, argv)
char **argv;
{
	char *namfil;
	int timcmp(), valcmp();
	int i, overlap;
	long pfpos;
	int lastsx;
	struct cnt *cp;
	int tx, ty;
	struct exec xbuf;
	struct hdr h;
	char *st;
	struct cnt *cntbuf, *cpe;

	lowpc = -1;
	highpc = -1;
	argv++;
	namfil = "a.out";
	while (argc>1) {
		if (**argv == '-') {
			if (*++*argv == 'l')
				lflg++;
			if (**argv == 'a')
				aflg = 040;
			if(**argv == 'v')
				vflg++;
			if (**argv == 'z')
				zflg++;
			if(**argv >= '0' && **argv <= '9') {
				i = atoi(*argv);
				if(lowpc == -1)
					lowpc = i;
				else
					highpc = i;
			}
		} else
			namfil = *argv;
		argc--;
		argv++;
	}
	if (lowpc >= 100)
		lowpc = 0;
	if(highpc <= lowpc || highpc > 100)
		highpc = 100;
	ransca = 100./(highpc-lowpc);
	ranoff = 2040. + 40.8*lowpc*ransca;
	if((nfile=fopen(namfil,"r"))==NULL) {
		fprintf(stderr, "%s: not found\n", namfil);
		done();
	}
	fread((char *)&xbuf, 1, sizeof(xbuf), nfile);
	if (xbuf.a_magic!=OMAGIC && xbuf.a_magic!=NMAGIC && xbuf.a_magic!=ZMAGIC) {
		fprintf(stderr, "%s: bad format\n", namfil);
		done();
	}
	if((pfile = fopen("mon.out","r")) == NULL) {
		fprintf(stderr, "No mon.out\n");
		done();
	}
	fstat(fileno(pfile), &stbuf);
	fread((char *)&h, sizeof(struct hdr), 1, pfile);
	lowpc = h.lowpc - (UNIT *)0;
	highpc = h.highpc - (UNIT *)0;
	bufs = stbuf.st_size - sizeof(struct hdr) - h.ncount*sizeof(struct cnt);
	stoff = N_STROFF(xbuf);
	symoff = N_SYMOFF(xbuf);
	fseek(nfile, stoff, 0);
	fread((char *)&stsize, sizeof(stsize), 1, nfile);
	st = (char *)malloc(stsize + sizeof(long));
	fseek(nfile, stoff, 0);
	fread(st, stsize, 1, nfile);
	fseek(nfile, symoff, 0);
	npe = nl;
	for (nname = 0; xbuf.a_syms > 0; xbuf.a_syms -= sizeof(struct nlist)) {
		struct nlist nbuf;
		fread((char *)&nbuf, sizeof(nbuf), 1, nfile);
		if (nbuf.n_type!=N_TEXT && nbuf.n_type!=N_TEXT+N_EXT)
			continue;
		if (aflg==0 && nbuf.n_type!=N_TEXT+N_EXT)
			continue;
		npe->value = nbuf.n_value/sizeof(UNIT);
		npe->name = &st[(long)nbuf.n_name];
		npe++;
		nname++;
	}

	cntbuf = (struct cnt *)malloc(h.ncount * sizeof(struct cnt));
	cpe = cntbuf + h.ncount;
	fread((char *)cntbuf, sizeof(struct cnt), h.ncount, pfile);
	pfpos = ftell(pfile);
	if (nname == 0) {
		fprintf(stderr, "%s: no symbols\n", namfil);
		done();
	}
	npe->value = -1;
	npe++;
	for (cp = cntbuf; cp < cpe; cp++)
		for (np = nl; np < npe; np++) {
			if ((unsigned)(cp->cvalue/sizeof(UNIT) - np->value) <= 20) {
				np->ncall = cp->cncall;
				break;
			}
		}
	qsort(nl, nname, sizeof(struct nl), valcmp);
	scale = highpc - lowpc;
	scale /= bufs/sizeof(UNIT);
	for(i=0;;i++) {
		register j;
		unsigned short ccnt;
		fread((char *)&ccnt, sizeof(ccnt), 1, pfile);
		if(feof(pfile))
			break;
		if (ccnt == 0)
			continue;
		pcl = lowpc + scale*i;
		pch = lowpc + scale*(i+1);
		ftime = (double)ccnt;
		totime += ftime;
		if(ftime > maxtime)
			maxtime = ftime;
		for (j=0; j<nname; j++) {
			if (pch < nl[j].value)
				break;
			if (pcl >= nl[j+1].value)
				continue;
			overlap=(min(pch,nl[j+1].value)-max(pcl,nl[j].value));
			nl[j].time += overlap*ftime/scale;
		}
	}
	if (totime==0.0) {
		fprintf(stderr, "No time accumulated\n");
		done();
	}
	actime = 0;
	printf("    %%time  cumsecs   #calls     spent  name\n");
	if (!lflg)
		qsort(nl, nname, sizeof(struct nl), timcmp);
	for (np = nl; np<npe-1; np++) {
		if (np->time == 0 && np->ncall == 0 && zflg == 0)
			continue;
		ftime = np->time/totime;
		actime += np->time;
		printf("%9.1f%9.2f", 100*ftime, actime/60);
		printf("%9ld", np->ncall);
		printf(" %9.2f ", np->time * 0.016666);
		printf("%s\n", np->name);
	}
	done();
}

min(a, b)
unsigned a, b;
{
	if (a<b)
		return(a);
	return(b);
}

max(a, b)
unsigned a, b;
{
	if (a>b)
		return(a);
	return(b);
}

valcmp(p1, p2)
struct nl *p1, *p2;
{
	return(p1->value - p2->value);
}

timcmp(p1, p2)
struct nl *p1, *p2;
{
	float d;

	d = p2->time - p1->time;
	if (d > 0.0)
		return(1);
	if (d < 0.0)
		return(-1);
	return(0);
}

done()
{

	exit(0);
}
