/* man: print pages from the manual */
/* (c) 1990 Brantley Coile, all rights reserved */
/*  derived from free bsd */

#include <stdio.h>
#include <ctype.h>
#include <sgtty.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>

int	cflag;
char	*strcpy();
char	*strcat();
int	section;
int	troffit;
int	force;
int	quick = 1;
int	killtmp;

#define	eq(a,b)	(strcmp(a,b) == 0)

main(argc, argv)
	int argc;
	char *argv[];
{

	umask(0);
	if (argc <= 1) {
		fprintf(stderr, "Usage: man [-qtnf] [section] title ...\n");
		exit(1);
	}
	if (chdir("/usr/man") < 0) {
		fprintf(stderr, "Can't chdir to /usr/man.\n");
		exit(1);
	}
	argc--, argv++;
	while (argc > 0 && argv[0][0] == '-') {
		switch(argv[0][1]) {
		case 't':
			troffit++;
			quick = 0;
			break;
		case 'n':
			troffit = 0;
			quick = 0;
			break;
		case 'q':	/* quick print */
			quick++;
			break;
		case 'f':	/* force source */
			force++;
			quick = 0;
			break;
		}
		argc--, argv++;
	}
	section = 0;
	do {
		if (argv[0][0] >= '0' && argv[0][0] <= '9' 
		&& argv[0][1] == 0) {
			section = argv[0][0];
			argc--, argv++;
			if (argc == 0)
				exit(1);
			continue;
		}
		manual(section, argv[0]);
		argc--, argv++;
	} while (argc > 0);
	exit(0);
}

manual(sec, name)
	char sec;
	char *name;
{
	char section = sec;
	char work[100], work2[100], cmdbuf[100];
	struct stat stbuf, stbuf2;
	int last;
	char *sp = "123456789";

	strcpy(work, "manx/");
	strcat(work, name);
	strcat(work, ".x");
	last = strlen(work) - 1;
	if (section == 0) {
		for (section = *sp++; section; section = *sp++) {
			work[3] = section;
			work[last] = section;
			work[last+1] = 0;
			if (stat(work, &stbuf) >= 0)
				break;
		}
		if (section == 0) {
			if (sec == 0)
				printf("%s not found\n", name);
			else
				printf("%d %s not found\n", sec, name);
			return;
		}
	} else {
		work[3] = section;
		work[last] = section;
		if (stat(work, &stbuf) < 0) {
			printf("%d %s not found\n", name, section);
			return;
		}
	}
	if (troffit)
		troff(work);
	else if (quick) {
		strcpy(work2, "/usr/spool/man/man");
		strcat(work2, work+3);
		if (stat(work2, &stbuf2) < 0) {
			nroff(work);
			return;
		}
		sprintf(cmdbuf, "cat %s\n", work2);
		system(cmdbuf);
	} else
		nroff(work);
}

nroff(cp)
	char *cp;
{
	char cmd[BUFSIZ];

	sprintf(cmd, "nroff -man %s", cp);
	system(cmd);
}

troff(cp)
	char *cp;
{
	char cmdbuf[BUFSIZ];

	sprintf(cmdbuf, "troff -man %s\n", cp);
	system(cmdbuf);
}

