# doctype: synthesize proper command line for troff
# usage: doctype [options...] [file]
while :
do
	case $1 in
	-n)	nroff=1; shift;;
	-*)	args="$args $1"; shift;;
	*)	break;;
	esac
done
echo -n "cat $* | "
egrep -h '^\.(EQ|TS|\[|PS|IS|PP|TH)' $* |
sort -u |
awk '
/^\.TH/ { man++ }
/^\.PP/	{ ms++ }
/^\.EQ/ { eqn++ }
/^\.TS/ { tbl++ }
/^\.PS/ { pic++ }
/^\.IS/ { ideal++ }
/^\.\[/	{ refer++ }
END	{
	if (refer > 0)	printf "refer | "
	if (pic > 0)	printf "pic | "
	if (ideal > 0)	printf "ideal | "
	if (tbl > 0)	printf "tbl | "
	if (eqn > 0 && 1'$nroff' == 11)
			printf "n"
	if (eqn > 0)	printf "eqn | "
	if (1'$nroff' == 11)
		printf "nroff "
	else
		printf "troff "
	if (man > 0) {	printf "-man"; ms = 0 }
	if (ms > 0)	printf "-ms"
	if ("'$args'" != "")
		printf "%s", "'$args'"
	if (1'$nroff' == 11 && tbl > 0)
		printf " | col"
	printf "\n"
} '
