#include <stdio.h>
#include <a.out.h>

static struct nlist *syms;
static int nsyms;			/* number of symbols in table */
static	int compar();

setsyms(fd)			/* setup symbol table from a.out file */
{
	char *malloc(), *calloc();
	char *strtab;
	struct exec h;
	struct nlist *sp;
	int stsize;

	lseek(fd, 0, 0);		/* rewind */
	read(fd, (char *)&h, sizeof h);
	syms = (struct nlist *) malloc(h.a_syms);
	if (syms == NULL) {
		fprintf(stderr, "not enough room for symbol table\n");
		exit(1);
	}
	lseek(fd, N_SYMOFF(h), 0);
	if (read(fd, (char *)syms, h.a_syms) != h.a_syms) {
		fprintf(stderr, "didn't read all of symbol table\n");
		exit(1);
	}
	read(fd, (char *)&stsize, sizeof stsize);
	strtab = malloc(stsize);
	if (strtab == NULL) {
		fprintf(stderr, "Not enough room for string table\n");
		exit(1);
	}
	lseek(fd, -(sizeof stsize), 1);
	if (read(fd, strtab, stsize) != stsize) {
		fprintf(stderr, "Can't read string table\n");
		exit(1);
	}
	nsyms = h.a_syms / sizeof (struct nlist);

	/* connect the symbols with the strings */

	for (sp = syms; sp < &syms[nsyms]; sp++) {
		if (sp->n_un.n_strx)
			sp->n_un.n_name = &strtab[sp->n_un.n_strx];
		else
			sp->n_un.n_name = "NO NAME";
	}
	qsort((char *)syms, nsyms, sizeof (struct nlist), compar);
}

static
compar(a, b)
	struct nlist *a, *b;
{
	return a->n_value - b->n_value;
}
struct nlist *
get_next_sym(sp)		/* read the next symbol */
	struct nlist *sp;
{
	if (sp == NULL)
		sp = syms;
	else if (++sp >= &syms[nsyms])
		return NULL;
	return sp;
}


struct nlist *
lookup(cp, op)		/* find the named symbol */
	char *cp;
{
	register struct nlist *sp;

	for (sp = syms; sp < &syms[nsyms]; sp++)
		if (strcmp(sp->n_un.n_name, cp) == 0)
			return sp;
	return NULL;
}


struct nlist *
findfn(addr, offsetp, argsizep)		/* find function name */
	int *offsetp, *argsizep;
{
	register struct nlist *sp, *sq;

	sq = NULL;
	for (sp = syms; sp < &syms[nsyms]; sp++) {
		if ((sp->n_type & N_TYPE) != N_TEXT)
			continue;
		if (index(sp->n_un.n_name, '.') != NULL)
			continue;
		if (sp->n_value > addr)
			break;
		sq = sp;
	}
	if (sq == NULL)
		return NULL;
	*offsetp = addr - sq->n_value;
	*argsizep = 0;
	return sq;
}
