/* setup.c:  Setup symbol and core files */

#include "defs.h"


Map	txtmap;
Map	datmap;
int	wtflag;
int	fcor;
int	fsym;
long	maxfile, maxstor, txtsiz, datsiz, datbas, stksiz;
char	*errflg;
int	magic;
long	symbas, symnum, entrypt;

int	argcount;
int	signo;
union	{
	struct user u;
	char space[4096];
} corhdr;
int	*endhdr = (int *) ((char *) &corhdr + sizeof corhdr);
char	*symfil	 = "a.out";
char	*corfil = "core";

#define	TXTHDRSIZ	(sizeof(struct exec))

setsym()
{
	int relflg, symval, symflg;
	Symslave *symptr;
	Symptr symp;
	struct exec txthdr;

	fsym = getfile(symfil, 1);
	txtmap.ufd = fsym;
	if (read(fsym, txthdr, TXTHDRSIZ) == TXTHDRSIZ) {
		magic = txthdr.a_magic;
		if (magic != 0410 && magic != 0407) 
			magic = 0;
		else {
			symnum = txthdr.a_syms / sizeof (struct nlist);
			txtsiz = txthdr.a_text;
			datsiz = txthdr.a_data;
			symbas = txtsiz + datsiz;
			txtmap.b1 = 0;
			txtmap.e1 = (magic == 0407 ? symbas : txtsiz);
			txtmap.f1 = TXTHDRSIZ;
			txtmap.b2 = datbas = (magic == 0410 ? 
				round(txtsiz, TXTRNDSIZ) : 0);
			txtmap.e2 = txtmap.b2 + 
				(magic == 0407 ? symbas : datsiz);
			txtmap.f2 = TXTHDRSIZ + 
				(magic == 0407 ? 0 : txtmap.e1);
			entrypt = txthdr.a_entry;
			relflg = (txthdr.a_trsize || txthdr.a_drsize);
			if (relflg == 0)
				symbas <<= 1;
		}
	}
	if (magic == 0)
		txtmap.e1 = maxfile;
}


setcor()
{
	fcor = getfile(corfil, 2);
	datmap.ufd = fcor;
	if (read(fcor, (char *)&corhdr, ctob(USIZE)) == ctob(USIZE)) {
		txtsiz = ctob(corhdr.u.u_tsize);
		datsiz = ctob(corhdr.u.u_dsize);
		stksiz = ctob(corhdr.u.u_ssize);
		datmap.b1 = datbas = (magic == 0401 ? round(txtsiz, TXTRNDSIZ)  : 0);
		datmap.e1 = (magic == 0407 ? txtsiz : datmap.b1) + datsiz;
		datmap.f1 = ctob(USIZE);
		datmap.b2 = maxstor-stksiz;
		datmap.e2 = maxstor;
		datmap.f2 = ctob(USIZE) + (magic == 0410 ? datsiz : datmap.e1);
		if (magic && magic != corhdr.u.u_exdata.ux_mag)
			puts("bad core magic number");
	} else
		datmap.e1 = maxfile;
}

create(f)
	char *f;
{
	int fd;

	if ((fd = creat(f, 0644)) >= 0) {
		close(fd);
		return open(f, wtflag);
	} else
		return -1;
}

getfile(filnam, cnt)
	char *filnam;
{
	register int fsym;

	if (!eqstr("-", filnam)) {
		fsym = open(filnam, wtflag);
		if ((fsym < 0) && argcount > cnt) {
			if (wtflag)
				fsym = create(filnam);
			if (fsym < 0)
				printf("cannot open `%s'\n", filnam);
		}
	} else
		fsym = -1;
	return fsym;
}
