/*
 * adb - main command loop and error/interrupt handling
 */
#include "defs.h"
#include <setjmp.h>

MSG		NOEOR;

INT		mkfault;
INT		executing;
INT		infile;
CHAR		*lp;
L_INT		maxoff;
L_INT		maxpos;
ADDR		sigint;
ADDR		sigqit;
INT		wtflag;
L_INT		maxfile;
STRING		errflg;
L_INT		exitflg;

CHAR		lastc;
INT		eof;

INT		lastcom;

long	maxoff = MAXOFF;
long	maxpos = MAXPOS;
char	*Ipath = "/usr/lib/adb";

# include <sgtty.h>
struct sgttyb adbtty,subtty;
jmp_buf	env;

main(argc, argv)
	register char **argv;
	int argc;
{
	ioctl(0, TIOCGETP, &adbtty);
	ioctl(0, TIOCGETP, &subtty);

another:
	if (argc>1) {
		if (eqstr("-w", argv[1])) {
			wtflag = 2;		/* suitable for open() */
			argc--, argv++;
			goto another;
		}
		if (eqstr("-k", argv[1])) {
			kernel = 1;
			argc--, argv++;
			goto another;
		}
		if (argv[1][0] == '-' && argv[1][1] == 'I') {
			Ipath = argv[1]+2;
			argc--, argv++;
		}
	}
	if (argc > 1)
		symfil = argv[1];
	if (argc > 2)
		corfil = argv[2];
	xargc = argc;
	setsym();
	setcor();
	setvar();

	if ((sigint=signal(SIGINT,SIG_IGN)) != SIG_IGN) {
		sigint = fault;
		signal(SIGINT, fault);
	}
	sigqit = signal(SIGQUIT, SIG_IGN);
	setjmp(env);
	if (executing)
		delbp();
	executing = 0;
	for (;;) {
		if (errflg) {
			printf("%s\n", errflg);
			exitflg = errflg;
			errflg = 0;
		}
		if (mkfault) {
			mkfault=0;
			printc('\n');
			prints(DBNAME);
		}

		lp=0; rdc(); lp--;
		if (eof) {
			if (infile) {
				iclose(-1, 0); eof=0; done();/*reset()*/;
			} else
				done();
		} else
			exitflg = 0;
		command(0, lastcom);
		flushbuf();
	/*	if (lp && lastc!='\n')
			error(NOEOR);
	*/
	}
}

done()
{
	endpcs();
	exit(exitflg);
}

long
round(a,b)
register long a, b;
{
	register long w;

	w = (a/b)*b;
	if (a!=w)
		w += b;
	return(w);
}

long
upround(a,b)
register long a,b;
{
	register long w;

	w = (a / b) * b;
	if ((a != w) || ((w % a) == 0))
		 w += b;
	return(w);
}

/*
 * If there has been an error or a fault, take the error.
 */
chkerr()
{
	if (errflg || mkfault)
		error(errflg);
}

/*
 * An error occurred; save the message for later printing,
 * close open files, and reset to main command loop.
 */
error(n)
	char *n;
{
	errflg = n;
	iclose(0, 1); oclose();
	longjmp(env);
}

/*
 * An interrupt occurred; reset the interrupt
 * catch, seek to the end of the current file
 * and remember that there was a fault.
 */
fault(a)
{
	signal(a, fault);
	lseek(infile, 0L, 2);
	mkfault++;
}
