static char *RCSid = "$Header: inst.c,v 1.2 86/04/22 13:58:05 mark Exp $";

/*
 * $Log:	inst.c,v $
 * Revision 1.2  86/04/22  13:58:05  mark
 * see brad
 * 
 * Revision 1.1  86/02/28  13:34:27  root
 * Initial revision
 * 
 */

/*
**	to use the dissambler, one calls the function disasm() (defined as
**	follows:
**
**	ushort * disasm(opcode,buf,opprint)
**	ushort *opcode;
**	char *buf;
**	char * (*opprint)();
**
**	disasm is given a pointer to a short containing the opcode (and any
**	subsequent extension words), a pointer to a buffer into which the
**	dissasembled string (null delimited) is to be returned and a pointer
**	to a function (provided by the user).  It does the obvious, returning
**	a pointer to the next instruction (assuming there is one).  The
**	last argument is provided by the user, since the format of any text
**	value to be printed out in symbolic form should be chosen by the user;
**	the function is given a 32-bit value and returns a pointer to
**	a (null-delimited) string containing the symbolic form of that 32 bit
**	value; it could be as simple as an int to ascii routine, e.g.
**	  sprintf(buffer,"%X",value)
*/


/*
**	this table provides for matching an opcode with an entry;
**	the algorithm for the match is
**
**	  if ((opcode & ~mask1) == value
**	      && (opcode & ~imask1) != inval1)
**	      && (opcode & ~imask2) != inval2))
**	  	match
**
**	a linear search is done in instabN given N, the value of the first
**	four bits of the opcode; if the delimiting NULL entry is reached,
**	we have an error;
**
**	once a match is made, the function in the table is called with
**	four params: a (char*) ptr to the opcode, the opcode string, a
**	ptr to a buffer into which the resulting dissambly string is stuffed,
**	and a function which will map addresses into a character string (for
**	relative offsets, etc.); the function called returns a ptr to the
**	location in memory which follows the one just disassembled
*/

# include "inst.h"


#ifdef NODAS
struct inst instab0[]=
{
{"btst",  0x0100,    0x0e3f,    EA,	EAM,	0x0000,	0x0000,	_dr_ea},
{"bchg",  0x0140,    0x0e3f,    EA,	EAM,	0x0000,	0x0000,	_dr_ea},
{"bclr",  0x0180,    0x0e3f,    EA,	EAM,	0x0000,	0x0000,	_dr_ea},
{"bset",  0x01c0,    0x0e3f,    EA,	EAM,	0x0000,	0x0000,	_dr_ea},
{"btst",  0x0800,    0x003f,    EA,	EAM,	0x0000,	0x0000,	_imm_ea},
{"bchg",  0x0840,    0x003f,    EA,	EAM,	0x0000,	0x0000,	_imm_ea},
{"bclr",  0x0880,    0x003f,    EA,	EAM,	0x0000,	0x0000,	_imm_ea},
{"bset",  0x08c0,    0x003f,    EA,	EAM,	0x0000,	0x0000,	_imm_ea},
{"or",	  0x0000,    0x00ff,    EA,	EAM,	SZ,	SZM,	_imm},
{"and",   0x0200,    0x00ff,    EA,	EAM,	SZ,	SZM,	_imm},
{"sub",   0x0400,    0x00ff,    EA,	EAM,	SZ,	SZM,	_imm},
{"add",   0x0600,    0x00ff,    EA,	EAM,	SZ,	SZM,	_imm},
{"eor",   0x0a00,    0x00ff,    EA,	EAM,	SZ,	SZM,	_imm},
{"cmp",   0x0c00,    0x00ff,    EA,	EAM,	SZ,	SZM,	_imm},
{"movep", 0x0008,    0x0fc7,    0x0000,	0x0000,	0x0000,	0x0000,	_movep},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab1[] =
{
{"movb",  0x1000,    0x0fff,    0x0000,	0x0000,	0x0000,	0x0000,	_move},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab2[] =
{
{"movl",  0x2000,    0x0fff,    0x0000,	0x0000,	0x0000,	0x0000,	_move},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab3[] =
{
{"movw",  0x3000,    0x0fff,    0x0000,	0x0000,	0x0000,	0x0000,	_move},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab4[] =
{
{"negx",  0x4000,    0x00ff,    EA,	EAM,	SZ,	SZM,	_sz_ea},
{"clr",	  0x4200,    0x00ff,    EA,	EAM,	SZ,	SZM,	_sz_ea},
{"neg",	  0x4400,    0x00ff,    EA,	EAM,	SZ,	SZM,	_sz_ea},
{"not",	  0x4600,    0x00ff,    EA,	EAM,	SZ,	SZM,	_sz_ea},
{"tst",	  0x4a00,    0x00ff,    EA,	EAM,	SZ,	SZM,	_sz_ea},
{"mov",	  0x40c0,    0x063f,    EA,	EAM,	MSP,	MSPM,	_mover},
{"nbcd",  0x4800,    0x003f,    EA,	EAM,	0x0000,	0x0000,	_ea},
{"pea",	  0x4840,    0x003f,    EA,	EAM,	0x0000,	0xffc7,	_ea},
{"tas",	  0x4ac0,    0x003f,    EA,	EAM,	0x0000,	0x0000,	_ea},
{"jsr",	  0x4e80,    0x003f,    EA,	EAM,	0x0000,	0x0000,	_ea},
{"jmp",	  0x4ec0,    0x003f,    EA,	EAM,	0x0000,	0x0000,	_ea},
{"movem", 0x4880,    0x047f,    0x0000,	0xffc7,	0x0000,	0x0000,	_movem},
{"chk",	  0x4180,    0x0e3f,    EA,	EAM,	0x0000,	0x0000,	_ea_dr},
{"lea",	  0x41c0,    0x0e3f,    EA,	EAM,	0x0000,	0x0000,	_ea_ar},
{"swap",  0x4840,    0x0007,    0x0000,	0x0000,	0x0000,	0x0000,	_dr},
{"ext",	  0x4880,    0x0047,    0x0000,	0x0000,	0x0000,	0x0000,	_ext},
{"trap",  0x4e40,    0x000f,    0x0000,	0x0000,	0x0000,	0x0000,	_trap},
{"link",  0x4e50,    0x0007,    0x0000,	0x0000,	0x0000,	0x0000,	_ar_imm},
{"unlk",  0x4e58,    0x0007,    0x0000,	0x0000,	0x0000,	0x0000,	_ar},
{"mov",	  0x4c60,    0x000f,    0x0000,	0x0000,	0x0000,	0x0000,	_mvusp},
{"illegal",  0x4afc,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	_noop},
{"reset", 0x4e70,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	_noop},
{"nop",	  0x4e71,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	_noop},
{"stop",  0x4e72,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	_noop},
{"rte",	  0x4e73,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	_noop},
{"rts",	  0x4e75,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	_noop},
{"trapv", 0x4e76,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	_noop},
{"rtr",	  0x4e77,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	_noop},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab5[] =
{
{"addq",  0x5000,    0x0eff,    SZ,	SZM,	0x0000,	0x0000,	_imm_sz_ea},
{"subq",  0x5100,    0x0eff,    SZ,	SZM,	0x0000,	0x0000,	_imm_sz_ea},
{"s",	  0x50c0,    0x0f3f,    EA,	EAM,	0x0000,	0x0000,	_scc},
{"db",	  0x50c8,    0x0f07,    0x0000,	0x0000,	0x0000,	0x0000,	_dbcc},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab6[] =
{
{"b",	  0x6000,    0x0fff,    0x0000,	0x0000,	0x0000,	0x0000,	_bcc},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab7[] =
{
{"moveq", 0x7000,    0x0eff,    0x0000,	0x0000,	0x0000,	0x0000,	_moveq},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab8[] =
{
{"divu",  0x80c0,    0x0e3f,    EA,	EAM,	0x0000,	0x0000,	_ea_dr},
{"divs",  0x81c0,    0x0e3f,    EA,	EAM,	0x0000,	0x0000,	_ea_dr},
{"sbcd",  0x8100,    0x0e0f,    0x0000,	0x0000,	0x0000,	0x0000,	_lim_ea},
{"or",	  0x8000,    0x0fff,    EA,	EAM,	0x0000,	0x0000,	_dr_op_ea},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab9[] =
{
{"sub",	  0x90c0,    0x0f3f,    0x0000,	0xff3f,	0x0000,	0x0000,	_adr_op_ea},
{"subx",  0x9100,    0x0ecf,    SZ,	SZM,	0x0000,	0x0000,	_lim_ea},
{"sub",	  0x9000,    0x0fff,    SZ,	SZM,	0x0000,	0x0000,	_dr_op_ea},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab11[] =
{
{"cmp",	  0xb0c0,    0x0f3f,    0x0000,	0xff3f,	0x0000,	0x0000,	_adr_op_ea},
{"cmpm",  0xb108,    0x0ec7,    EA,	EAM,	SZ,	SZM,	_dr_sz_ea},
{"eor",	  0xb100,    0x0eff,    EA,	EAM,	SZ,	SZM,	_dr_sz_ea},
{"cmp",	  0xb000,    0x0fff,    SZ,	SZM,	0x0000,	0x0000,	_dr_op_ea},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab12[] =
{
{"mulu",  0xc0c0,    0x0e3f,    EA,	EAM,	0x0000,	0x0000,	_ea_dr},
{"muls",  0xc1c0,    0x0e3f,    EA,	EAM,	0x0000,	0x0000,	_ea_dr},
{"abcd",  0xc100,    0x0e0f,    EA,	EAM,	0x0000,	0x0000,	_lim_ea},
{"exgd",  0xc140,    0x0e07,    0x0000,	0x0000,	0x0000,	0x0000,	_exgd},
{"exga",  0xc148,    0x0e07,    0x0000,	0x0000,	0x0000,	0x0000,	_exga},
{"exgm",  0xc188,    0x0e07,    0x0000,	0x0000,	0x0000,	0x0000,	_exgm},
{"and",	  0xc000,    0x0fff,    EA,	EAM,	SZ,	SZM,	_dr_op_ea},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab13[] =
{
{"add",	  0xd0c0,    0x0f3f,    0x0000,	0xff3f,	0x0000,	0x0000,	_adr_op_ea},
{"addx",  0xd100,    0x0ecf,    SZ,	SZM,	0x0000,	0x0000,	_lim_ea},
{"add",	  0xd000,    0x0fff,    SZ,	SZM,	0x0000,	0x0000,	_dr_op_ea},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst instab14[] =
{
{"as",	  0xe000,    0x0fe7,    SZ,	SZM,	0x0000,	0x0000,	_sh_dr},
{"ls",	  0xe008,    0x0fe7,    SZ,	SZM,	0x0000,	0x0000,	_sh_dr},
{"rox",	  0xe010,    0x0fe7,    SZ,	SZM,	0x0000,	0x0000,	_sh_dr},
{"ro",	  0xe018,    0x0fe7,    SZ,	SZM,	0x0000,	0x0000,	_sh_dr},
{"as",	  0xe0c0,    0x0137,    EA,	EAM,	0x0000,	0x0000,	_shmem},
{"ls",	  0xe2c0,    0x0137,    EA,	EAM,	0x0000,	0x0000,	_shmem},
{"rox",	  0xe4c0,    0x0137,    EA,	EAM,	0x0000,	0x0000,	_shmem},
{"ro",	  0xe6c0,    0x0137,    EA,	EAM,	0x0000,	0x0000,	_shmem},
{NULL,	  0x0000,    0x0000,    0x0000,	0x0000,	0x0000,	0x0000,	NULL},
};

struct inst *_optable[16] = 
{
	instab0,
	instab1,
	instab2,
	instab3,
	instab4,
	instab5,
	instab6,
	instab7,
	instab8,
	instab9,
	NULL,
	instab11,
	instab12,
	instab13,
	instab14,
	NULL
};
#endif NODAS

ushort *
disasm(opcode,buf,opprint)
ushort *opcode;
char *buf;
char * (*opprint)();
{
	register struct inst *list;

# ifdef DEBUG
	printf("disasm() opcode = %x, *opcode = %x\n",opcode,*opcode);
	flushbuf(); 
# endif DEBUG

#ifdef NODAS
	if ((list = _optable[(*opcode) >> 12]) == NULL)
		return NULL;
#endif  NODAS

#ifndef NODAS		/* are we using the stand alone disassembler*/
	print_ins(*opcode);
#else
	while (list->opcode)
	{
		if ((*opcode & ~list->mask1) == list->value &&
			(*opcode & ~list->imask1) != list->inval1 &&
			(*opcode & ~list->imask2) != list->inval2)
	  		return (*list->op) (opcode,list->opcode,buf,opprint);
		list++;
	}
#endif NODAS

# ifdef DEBUG
	printf("failure to match %x (%x)\n",opcode,*opcode);
# endif DEBUG
	return NULL;
}
