/*
 * C compiler.
 * Code driver (sel, out)
 */
#ifdef   vax
#include "INC$LIB:cc1.h"
#else
#include "cc1.h"
#endif

PREGSET	curbusy;
PREGSET	curxreg;
PREGSET	maxbusy;
int	nstorelist;
TREE	*storelist[NSTORE];

/*
 * Generate code for an
 * expression. The argument `tp' is
 * a pointer to a marked tree. 
 * The context is `c'. If `c' is MFLOW
 * then `r' is a truth sense and `n'
 * is a label.
 */
code(tp, c, s, n)
TREE *tp;
register s;
{
	register TREE *ap;

	ap = tp;
	walk(ap, amd);
#if !TINY
	if (sflag) snapf("%W%E", "Before select", ap);
#endif
	if (c != MFLOW) {
		s = ANYR;
		if (c == MSWITCH) {
			s = SWREG;
			c = MRVALUE;
		}
		if (c == MRETURN) {
			s = pertype[ap->t_type].p_frreg;
			c = pertype[ap->t_type].p_frcxt;
		}
	}
	curtemp = maxauto;
	curbusy = regbusy;
	curxreg = 0;
	nstorelist = 0;
	if (code1(&tp, c, s) != 0) {
		ap = tp;
#if !TINY
		if (sflag) snapf("%W%E%W", "After select", ap, NULL);
#endif
		output(ap, c, s, n);
	} else
		nomatch(tp);
}

nomatch(tp)
TREE *tp;
{
#if !TINY
	snapf("%W%E%W", "No match", tp, NULL);
	if (! sflag)
#endif
	cbotch("no match, op=%d", tp->t_op);
}

/*
 * Select the node pointed to by tpp
 * and any stores generated by its selection.
 * Prepend the store nodes onto tpp with
 * COMMA's and store the result node into tpp.
 * This routine makes side effects happen
 * in the right places.
 * A failure to select is fatal.
 */
code1(tpp, c, r)
TREE **tpp;
{
	register TREE	*ap;
	int	match;
	PREGSET	savbusy;
	PREGSET	savxreg;
	int	savstor;

	ap = *tpp;
	match = 1;
	savbusy = curbusy;
	savxreg = curxreg;
	savstor = nstorelist;

#if !TINY
	if (sflag > 1) snapf("%W%E", "Before code1", ap);
#endif
	if (select(ap, c, r) == 0) {
		/* nomatch(ap); */
		match = 0;
	}

	if (savstor < nstorelist) {
		register int i;
		PREGSET	used;
		REGNAME rreg;
		int	type;
		int	size;

		used = ap->t_used;
		rreg = ap->t_rreg;
		type = ap->t_type;
		size = ap->t_size;
		for (i = savstor; i < nstorelist; i += 1) {
			curbusy = savbusy;
			curxreg = 0;
			ap = storelist[i];
			if (select(ap, MEFFECT, ANYR) == 0) {
				/* nomatch(ap); */
				match = 0;
			}
#if !TINY
			if (sflag > 2)
				snapf("%W%E%W", "Stored node", ap, NULL);
#endif
			used |= ap->t_used;
			ap = leftnode(COMMA, ap, type, size);
			ap->t_used = used;
			ap->t_rreg = rreg;
			ap->t_rp = *tpp;
			*tpp = ap;
		}
	}
	if (curtemp > maxtemp)
		maxtemp = curtemp;
	maxbusy |= ap->t_used;
	curbusy = savbusy;
	curxreg = savxreg;
	nstorelist = savstor;
	return (match);
}


