/*
 * h/i386/mch.h
 * Machine specific header for the i386 compiler.
 * Typedefs, register names and macros for all compiler phases.
 * This one builds a TINY i386 COHERENT compiler with memory tempfiles.
 */

#define	DATE		"7/18/93"	/* Date			*/
#define	VERSMWC		"V4.3.4"	/* MWC version number	*/
#define	VERSINT		"X324"		/* Intel version number	*/

#define	EATDOL		0	/* Eat '$' in identifiers?	*/
#define	APPENDBAR	0	/* Append '_' to identifiers?	*/
#define	IEEE		1	/* IEEE format?			*/
#define	DECVAX		0	/* DECVAX format?		*/
#define	NATIVEFP	0	/* Host fp == target fp?	*/
#define	FOLD_DOUBLES	1	/* Fold doubles? Assumes host fp == target fp! */
#define MCFFP		0	/* Motorola fast floating point? */
#define	TINY		1	/* No code gen debug info?	*/
#ifndef	YATC
#define	YATC		0	/* Not code table compile	*/
#endif
#define	SIZEOF_LARGE	0	/* sizeof_t == ival_t		*/
#define SPLIT_CC1	0	/* CC1A-CC1B?			*/
#define AS_FORMAT	1	/* Coherent/Rainbow .s format?	*/
#define	INTEL		0	/* Intel copyright?		*/
#define	OMF286		0	/* 286 object format?		*/
#define	TEMPBUF		1	/* Memory tempfile buffers?	*/

#define	EMUFIXUPS	0	/* M: 8087 emulation fixups?	*/

/*
 * Types.
 * Cf. common/i386/tyname.c.
 */
#define	S8	0		/* Signed byte			*/
#define	U8	1		/* Unsigned byte		*/
#define	S16	2		/* Signed word			*/
#define	U16	3		/* Unsigned word		*/
#define	S32	4		/* Signed long			*/
#define	U32	5		/* Unsigned long		*/
#define	F32	6		/* Short floating point		*/
#define	F64	7		/* Long  floating point		*/
#define	BLK	8		/* Block of bytes		*/
#define	FLD8	9		/* Field, byte wide		*/
#define	FLD16	10		/* Field, word wide		*/
#define	FLD32	11		/* Field, dword wide		*/
#define	PTR	12		/* Pointer			*/
#define	PTB	13		/* Pointer to BLK		*/

#define	TRUTH	S32		/* Type used for truth values	*/
#define	OFFS	PTR		/* Offset LEAF type		*/
#define	IVAL_T	S32		/* Type for ival_t con		*/
#define	LVAL_T	S32		/* Type for lval_t con		*/
#define	DVAL_T	F64		/* Type for dval_t con		*/
#define	I_FMT	"%ld"		/* printf format for ival_t con	*/
#define	I_FMTX	"%lx"		/* printf format for ival_t con	*/
#define	NBPBYTE	8		/* # of bits in a "byte"	*/

/*
 * Flag bit type for each machine type.
 */
#define	FS8	0x0001
#define	FU8	0x0002
#define	FS16	0x0004
#define	FU16	0x0008
#define	FS32	0x0010
#define	FU32	0x0020
#define	FF32	0x0040
#define	FF64	0x0080
#define	FBLK	0x0100
#define	FFLD8	0x0200
#define	FFLD16	0x0400
#define	FFLD32	0x0800
#define	FPTR	0x1000
#define FPTB	0x2000

/*
 * Allocation types.
 */
#ifdef  vax
typedef	int	ival_t;		/* 32 bit ints			*/
typedef	unsigned int uival_t;	/* 32 bit uints			*/
typedef	int	lval_t;		/* 32 bit longs			*/
typedef	unsigned int ulval_t;	/* 32 bit ulongs		*/
typedef int	sizeof_t;	/* 32 bit sizeof constants	*/
#else
typedef	long	ival_t;		/* 32 bit ints			*/
typedef	unsigned long uival_t;	/* 32 bit uints			*/
typedef	long	lval_t;		/* 32 bit longs			*/
typedef	unsigned long ulval_t;	/* 32 bit ulongs		*/
typedef long	sizeof_t;	/* 32 bit sizeof constants	*/
#endif
typedef	char	dval_t[8];	/* doubles			*/

/*
 * Types used in several phases.
 */
typedef	int		PREGSET;
typedef	unsigned long	ADDRESS;
typedef long		SIGNEDADDRESS;

/*
 * Limits.
 */
#define	MAXIV	0x7FFFFFFFL	/* Max integer			*/
#define	MAXUV	0xFFFFFFFFL	/* Max unsigned integer		*/
#define	MAXUCE	255		/* Max unsigned char enumeration */
#define	UIMASK	0x00000000L	/* Unsigned int check mask	*/
#define	SIMASK	0x80000000L	/* Signed int check mask	*/
#define	SLMASK	0x80000000L	/* Signed long check mask	*/
#define	ASMASK	0xFFFFFFFFL	/* Address space mask		*/
#define MAXMEMB	MAXIV		/* Max struct/union member offset */
#define	MAXESIZE MAXUV		/* Max struct/union/array size	*/

/*
 * Registers.
 * This list includes the machine's actual registers,
 * registers that are given names for the benefit of the code output routines,
 * and the pseudo registers used by the code generator.
 * Cf. common/i386/regnam.c, n1/i386/gen1.c, n1/i386/table1.c.
 */
/* 32-bit general registers. */
#define	EAX	0
#define	EDX	1
#define	EBX	2
#define	ECX	3
#define	ESI	4
#define	EDI	5
#define	ESP	6
#define	EBP	7

/* Quad-word register for multiplication, division, floating point. */
#define	EDXEAX	8

/* 16-bit i8086 registers. */
#define	AX	9
#define	DX	10
#define	BX	11
#define	CX	12
#define	SI	13
#define	DI	14
#define	SP	15
#define	BP	16

/* Eight-bit parts of i8086 registers. */
#define	AL	17
#define	BL	18
#define	CL	19
#define	DL	20
#define	AH	21
#define	BH	22
#define	CH	23
#define	DH	24

/* Floating point register (NDP stacktop %st0), used by NDP version only. */
#define	FPAC	25

/* Pseudoregisters. */
#define	NONE	26
#define	ANYR	27
#define	ANYL	28
#define	PAIR	29
#define	TEMP	30
#define	LOTEMP	31
#define	HITEMP	32

#define	FRREG	EAX	/* First real reg		*/
#define	NFBREG	7	/* Number of last flag bit reg	*/
#define	NRREG	26	/* Number of real regs, incl. FPAC */
#define	NREG	31	/* Number of last reg		*/

/* Flag bits, same order as register numbers above. */
#define	BEAX	0x0001
#define	BEDX	0x0002
#define	BEBX	0x0004
#define	BECX	0x0008
#define	BESI	0x0010
#define	BEDI	0x0020
#define	BESP	0x0040
#define	BEBP	0x0080
#define	BFPAC	0x0100

/*
 * Machine registers.
 * The processor uses these codes in the REGM field of an instruction.
 * This makes it easier to get the register code from an AFIELD
 * and to find the indexing mode associated with a register.
 * Unless Intel changes the chip, do not change the values here.
 */
#define	MEAX	0
#define	MECX	1
#define	MEDX	2
#define	MEBX	3
#define	MESP	4
#define	MEBP	5
#define	MESI	6
#define	MEDI	7

#define	NMREG	8

/*
 * Definitions for the "a_mode" field of an AFIELD object (cc1, cc2).
 * Some bits are used only by the peephole optimizer in the "regstate" table.
 * The indexing mode bits are packed efficiently but not very intuitively.
 */
#define	A_NONE	0		/* General "none" value			*/
#define	A_REGM	0x0007		/* Register code, etc.			*/
#define	A_IREG	0x0038		/* Scaled index register code		*/
#define	A_ISS	0x00C0		/* Scale factor, [0123] for [1248]	*/
#define	A_AMOD	0x0F00		/* Address mode				*/
#define	A_X	0x0800		/* Flag for indexed address modes	*/
#define	A_FLAGS	0xF000		/* Flag bit mask			*/
#define	A_EA	0x1000		/* Flag for peephole; effective address	*/
#define A_OFFS	0x2000		/* Flag for getfield; offset present	*/
#define	A_LID	0x4000		/* Flag for getfield; local id present	*/
#define	A_GID	0x8000		/* Flag for getfield; global id present	*/

#define	NOBASE		-1			/* No SIB base present	*/
#define	SIB(m)		((m) & 0xFF)		/* Extract SIB		*/
#define	IREG(m)		(((m) & A_IREG) >> 3)	/* Extract index reg	*/
#define	SCALE(m)	(((m) & A_ISS) >> 6)	/* Extract scale factor	*/

/* A_AMOD values. */
#define	A_BR	(1<<8)		/* Byte register			*/
#define	A_WR	(2<<8)		/* Word register			*/
#define	A_DR	(3<<8)		/* Dword register			*/
#define	A_IMM	(4<<8)		/* Immediate				*/
#define	A_DIR	(5<<8)		/* Direct				*/
#define	A_XB	(A_X|(6<<8))	/* Indexed using base register only	*/
#define	A_XSIB	(A_X|(7<<8))	/* Indexed using SIB			*/

#define	A_REAX	(A_DR|MEAX)	/* eax */
#define	A_RECX	(A_DR|MECX)	/* ecx */
#define	A_REDX	(A_DR|MEDX)	/* edx */
#define	A_REBX	(A_DR|MEBX)	/* ebx */
#define	A_RESP	(A_DR|MESP)	/* esp */
#define	A_REBP	(A_DR|MEBP)	/* ebp */
#define	A_RESI	(A_DR|MESI)	/* esi */
#define	A_REDI	(A_DR|MEDI)	/* edi */

#define	A_RAX	(A_WR|MEAX)	/* ax */
#define	A_RCX	(A_WR|MECX)	/* cx */
#define	A_RDX	(A_WR|MEDX)	/* dx */
#define	A_RBX	(A_WR|MEBX)	/* bx */
#define	A_RSP	(A_WR|MESP)	/* sp */
#define	A_RBP	(A_WR|MEBP)	/* bp */
#define	A_RSI	(A_WR|MESI)	/* si */
#define	A_RDI	(A_WR|MEDI)	/* di */

#define	A_RAL	(A_BR|MEAX)	/* al */
#define	A_RCL	(A_BR|MECX)	/* cl */
#define	A_RDL	(A_BR|MEDX)	/* dl */
#define	A_RBL	(A_BR|MEBX)	/* bl */
#define	A_RAH	(A_BR|MEAX|4)	/* ah */
#define	A_RCH	(A_BR|MECX|4)	/* ch */
#define	A_RDH	(A_BR|MEDX|4)	/* dh */
#define	A_RBH	(A_BR|MEBX|4)	/* bh */

#define	A_XEAX	(A_XB|MEAX)	/* [eax] */
#define	A_XECX	(A_XB|MECX)	/* [ecx] */
#define	A_XEDX	(A_XB|MEDX)	/* [edx] */
#define	A_XEBX	(A_XB|MEBX)	/* [ebx] */
#define	A_XEBP	(A_XB|MEBP)	/* [ebp] */
#define	A_XESI	(A_XB|MESI)	/* [esi] */
#define	A_XEDI	(A_XB|MEDI)	/* [edi] */

/* end of h/i386/mch.h */
